/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store;

import org.joyqueue.store.StoreConfigKey;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;

public class StoreConfig {
    public static final int DEFAULT_MESSAGE_FILE_SIZE = 0x8000000;
    public static final int DEFAULT_INDEX_FILE_SIZE = 524288;
    public static final int DEFAULT_THREAD_COUNT = 4;
    public static final int DEFAULT_PRE_LOAD_BUFFER_CORE_COUNT = 3;
    public static final int DEFAULT_PRE_LOAD_BUFFER_MAX_COUNT = 10;
    public static final long DEFAULT_PRINT_METRIC_INTERVAL_MS = 0L;
    public static final boolean DEFAULT_MESSAGE_FILE_LOAD_ON_READ = false;
    public static final boolean DEFAULT_INDEX_FILE_LOAD_ON_READ = true;
    public static final String STORE_PATH = "/store";
    private String storePath;
    private int messageFileSize = 0x8000000;
    private int indexFileSize = 524288;
    private int threadCount = 4;
    private int preLoadBufferCoreCount = 3;
    private int preLoadBufferMaxCount = 10;
    private long printMetricIntervalMs = 0L;
    private int maxMessageLength = 0x400000;
    private int writeRequestCacheSize = 128;
    private long writeTimeoutMs = 3000L;
    private long flushIntervalMs = 50L;
    private int fileHeaderSize = 128;
    private long maxDirtySize = 0xA00000L;
    private int diskFullRatio = 90;
    private PropertySupplier propertySupplier;

    public StoreConfig(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath() {
        if (this.storePath == null || this.storePath.isEmpty()) {
            StoreConfig storeConfig = this;
            synchronized (storeConfig) {
                if (this.storePath == null) {
                    String prefix = "";
                    if (this.propertySupplier != null) {
                        Property property = this.propertySupplier.getProperty("application.data.path");
                        prefix = property == null ? prefix : property.getString();
                    }
                    this.storePath = prefix + STORE_PATH;
                }
            }
        }
        return this.storePath;
    }

    public void setPath(String path) {
        if (path != null && !path.isEmpty()) {
            this.storePath = path;
        }
    }

    public int getMessageFileSize() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.MESSAGE_FILE_SIZE, (Object)this.messageFileSize);
    }

    public void setMessageFileSize(int messageFileSize) {
        this.messageFileSize = messageFileSize;
    }

    public int getIndexFileSize() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.INDEX_FILE_SIZE, (Object)this.indexFileSize);
    }

    public void setIndexFileSize(int indexFileSize) {
        this.indexFileSize = indexFileSize;
    }

    public int getMaxMessageLength() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.MAX_MESSAGE_LENGTH, (Object)this.maxMessageLength);
    }

    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    public int getWriteRequestCacheSize() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.WRITE_REQUEST_CACHE_SIZE, (Object)this.writeRequestCacheSize);
    }

    public void setWriteRequestCacheSize(int writeRequestCacheSize) {
        this.writeRequestCacheSize = writeRequestCacheSize;
    }

    public long getFlushIntervalMs() {
        return (Long)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.FLUSH_INTERVAL_MS, (Object)this.flushIntervalMs);
    }

    public void setFlushIntervalMs(long flushIntervalMs) {
        this.flushIntervalMs = flushIntervalMs;
    }

    public int getFileHeaderSize() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.FILE_HEADER_SIZE, (Object)this.fileHeaderSize);
    }

    public void setFileHeaderSize(int fileHeaderSize) {
        this.fileHeaderSize = fileHeaderSize;
    }

    public long getWriteTimeoutMs() {
        return (Long)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.WRITE_TIMEOUT, (Object)this.writeTimeoutMs);
    }

    public void setWriteTimeoutMs(long writeTimeoutMs) {
        this.writeTimeoutMs = writeTimeoutMs;
    }

    public int getThreadCount() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.THREAD_COUNT, (Object)this.threadCount);
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getPreLoadBufferCoreCount() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.PRELOAD_BUFFER_CORE_COUNT, (Object)this.preLoadBufferCoreCount);
    }

    public void setPreLoadBufferCoreCount(int preLoadBufferCoreCount) {
        this.preLoadBufferCoreCount = preLoadBufferCoreCount;
    }

    public int getPreLoadBufferMaxCount() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.PRELOAD_BUFFER_MAX_COUNT, (Object)this.preLoadBufferMaxCount);
    }

    public void setPreLoadBufferMaxCount(int preLoadBufferMaxCount) {
        this.preLoadBufferMaxCount = preLoadBufferMaxCount;
    }

    public long getMaxDirtySize() {
        return (Long)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.MAX_DIRTY_SIZE, (Object)this.maxDirtySize);
    }

    public void setMaxDirtySize(long maxDirtySize) {
        this.maxDirtySize = maxDirtySize;
    }

    public long getPrintMetricIntervalMs() {
        return (Long)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.PRINT_METRIC_INTERVAL_MS, (Object)this.printMetricIntervalMs);
    }

    public void setPrintMetricIntervalMs(long printMetricIntervalMs) {
        this.printMetricIntervalMs = printMetricIntervalMs;
    }

    public int getDiskFullRatio() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.DISK_FULL_RATIO, (Object)this.diskFullRatio);
    }

    public void setDiskFullRatio(int diskFullRatio) {
        this.diskFullRatio = diskFullRatio;
    }

    public boolean isMessageFileLoadOnRead() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.MESSAGE_FILE_LOAD_ON_READ, (Object)false);
    }

    public boolean isIndexFileLoadOnRead() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)StoreConfigKey.INDEX_FILE_LOAD_ON_READ, (Object)true);
    }
}

