/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.joyqueue.store.StoreLockedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreLock {
    private static final Logger logger = LoggerFactory.getLogger(StoreLock.class);
    private final File lockFile;
    private FileChannel channel;
    private FileLock lock;

    public StoreLock(File lockFile) {
        this.lockFile = lockFile;
    }

    public void lock() throws IOException {
        this.channel = new RandomAccessFile(this.lockFile, "rw").getChannel();
        this.lock = this.channel.tryLock();
        if (this.lock == null) {
            this.channel.close();
            throw new StoreLockedException();
        }
    }

    public void unlock() {
        try {
            if (this.lock != null) {
                this.lock.release();
                this.channel.close();
                this.lockFile.delete();
            }
        }
        catch (IOException e) {
            logger.warn("Unlock file {} failed!", (Object)this.lockFile.getAbsoluteFile());
        }
    }
}

