/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.store.PartitionGroupStoreManager;
import org.joyqueue.store.ReadResult;
import org.joyqueue.store.Store;
import org.joyqueue.store.StoreManagementService;
import org.joyqueue.store.file.PositioningStore;
import org.joyqueue.store.file.StoreFile;
import org.joyqueue.store.index.IndexItem;
import org.joyqueue.store.utils.ByteBufferUtils;
import org.joyqueue.store.utils.PreloadBufferPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreManagement
implements StoreManagementService {
    private static final Logger logger = LoggerFactory.getLogger(StoreManagement.class);
    private final int messageFileHeaderSize;
    private final int indexFileHeaderSize;
    private final int maxMessageSize;
    private final PreloadBufferPool bufferPool;
    private final Store store;

    public StoreManagement(int messageFileHeaderSize, int indexFileHeaderSize, int maxMessageSize, PreloadBufferPool bufferPool, Store store) {
        this.messageFileHeaderSize = messageFileHeaderSize;
        this.indexFileHeaderSize = indexFileHeaderSize;
        this.maxMessageSize = maxMessageSize;
        this.bufferPool = bufferPool;
        this.store = store;
    }

    public StoreManagementService.TopicMetric[] storeMetrics() {
        return (StoreManagementService.TopicMetric[])this.store.topics().stream().map(this::topicMetric).toArray(StoreManagementService.TopicMetric[]::new);
    }

    public StoreManagementService.PartitionGroupMetric partitionGroupMetric(String topic, int partitionGroup) {
        StoreManagementService.PartitionGroupMetric partitionGroupMetric = null;
        PartitionGroupStoreManager partitionGroupStoreManger = this.store.partitionGroupStore(topic, partitionGroup);
        if (null != partitionGroupStoreManger) {
            partitionGroupMetric = new StoreManagementService.PartitionGroupMetric();
            partitionGroupMetric.setPartitionGroup(partitionGroup);
            partitionGroupMetric.setFlushPosition(partitionGroupStoreManger.flushPosition());
            partitionGroupMetric.setIndexPosition(partitionGroupStoreManger.indexPosition());
            partitionGroupMetric.setLeftPosition(partitionGroupStoreManger.leftPosition());
            partitionGroupMetric.setReplicationPosition(partitionGroupStoreManger.commitPosition());
            partitionGroupMetric.setRightPosition(partitionGroupStoreManger.rightPosition());
            partitionGroupMetric.setPartitionMetrics((StoreManagementService.PartitionMetric[])Arrays.stream(partitionGroupStoreManger.listPartitions()).map(partition -> this.getPartitionMetric(partitionGroupStoreManger, (short)partition)).filter(Objects::nonNull).toArray(StoreManagementService.PartitionMetric[]::new));
        }
        return partitionGroupMetric;
    }

    private StoreManagementService.PartitionMetric getPartitionMetric(PartitionGroupStoreManager partitionGroupStoreManger, short partition) {
        StoreManagementService.PartitionMetric partitionMetric = null;
        PositioningStore<IndexItem> indexStore = partitionGroupStoreManger.indexStore(partition);
        if (null != indexStore) {
            partitionMetric = new StoreManagementService.PartitionMetric();
            partitionMetric.setPartition(partition);
            partitionMetric.setLeftIndex(indexStore.left() / 12L);
            partitionMetric.setRightIndex(indexStore.right() / 12L);
        }
        return partitionMetric;
    }

    public StoreManagementService.TopicMetric topicMetric(String topic) {
        StoreManagementService.TopicMetric topicMetric = new StoreManagementService.TopicMetric();
        topicMetric.setTopic(topic);
        topicMetric.setPartitionGroupMetrics((StoreManagementService.PartitionGroupMetric[])this.store.partitionGroups(topic).stream().map(partitionGroup -> this.partitionGroupMetric(topic, (int)partitionGroup)).filter(Objects::nonNull).toArray(StoreManagementService.PartitionGroupMetric[]::new));
        return topicMetric;
    }

    public StoreManagementService.PartitionMetric partitionMetric(String topic, short partition) {
        return this.store.partitionGroups(topic).stream().map(g -> this.store.partitionGroupStore(topic, (int)g)).filter(Objects::nonNull).map(partitionGroupStoreManger -> this.getPartitionMetric((PartitionGroupStoreManager)partitionGroupStoreManger, partition)).filter(Objects::nonNull).findAny().orElse(null);
    }

    public File[] listFiles(String path) {
        File dir = new File(path);
        if (!dir.isAbsolute()) {
            dir = new File(this.store.base(), path);
        }
        return this.listFiles(dir);
    }

    public File[] listFiles(File directory) {
        return directory.listFiles();
    }

    public long freeSpace() {
        return this.store.base().getFreeSpace();
    }

    public long totalSpace() {
        return this.store.base().getTotalSpace();
    }

    private long usableSpace() {
        return this.store.base().getUsableSpace();
    }

    public byte[][] readMessages(String topic, int partitionGroup, long position, int count) {
        try {
            return (byte[][])this.store.partitionGroupStore(topic, partitionGroup).messageStore().batchRead(position, count).stream().map(ByteBuffer::array).toArray(x$0 -> new byte[x$0][]);
        }
        catch (Throwable t) {
            logger.warn("Exception:", t);
            return null;
        }
    }

    private byte[] getBytes(ByteBuffer b) {
        byte[] bytes = new byte[b.capacity()];
        ByteBuffer wrappedBuffer = ByteBuffer.wrap(bytes);
        ByteBufferUtils.copy(b, wrappedBuffer);
        return bytes;
    }

    public byte[][] readMessages(String topic, short partition, long index, int count) {
        try {
            return (byte[][])this.store.partitionGroups(topic).stream().map(g -> this.store.partitionGroupStore(topic, (int)g)).filter(Objects::nonNull).filter(s -> Arrays.stream(s.listPartitions()).anyMatch(p -> p == partition)).map(s -> {
                try {
                    return s.read(partition, index, count, Long.MAX_VALUE);
                }
                catch (IOException e) {
                    return null;
                }
            }).filter(Objects::nonNull).filter(r -> r.getCode() == JoyQueueCode.SUCCESS).map(ReadResult::getMessages).flatMap(Arrays::stream).map(this::getBytes).toArray(x$0 -> new byte[x$0][]);
        }
        catch (Throwable t) {
            logger.warn("Exception:", t);
            return null;
        }
    }

    public byte[][] readMessages(File file, long position, int count, boolean includeFileHeader) {
        try {
            ByteBuffer byteBuffer;
            StoreFile storeFile = null;
            ArrayList<byte[]> messages = new ArrayList<byte[]>(count);
            for (int i = 0; i < count && null != (byteBuffer = (ByteBuffer)storeFile.read((int)position, -1)); ++i) {
                position += (long)(byteBuffer.remaining() + 1);
                messages.add(this.getBytes(byteBuffer));
            }
            return (byte[][])messages.toArray((T[])new byte[0][]);
        }
        catch (Throwable t) {
            logger.warn("Exception:", t);
            return null;
        }
    }

    public Long[] readIndices(String topic, short partition, long index, int count) {
        try {
            return (Long[])this.store.partitionGroups(topic).stream().map(g -> this.store.partitionGroupStore(topic, (int)g)).filter(Objects::nonNull).filter(s -> Arrays.stream(s.listPartitions()).anyMatch(p -> p == partition)).map(s -> s.indexStore(partition)).map(is -> {
                try {
                    return is.batchRead(index, count);
                }
                catch (Exception e) {
                    logger.warn("Exception: ", (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).flatMap(Collection::stream).map(IndexItem::getOffset).toArray(Long[]::new);
        }
        catch (Throwable t) {
            logger.warn("Exception:", t);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public Long[] readIndices(File file, long position, int count, boolean includeFileHeader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readFile(File file, long position, int length) {
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            byte[] retBytes = new byte[length];
            raf.read(retBytes);
            byte[] byArray = retBytes;
            return byArray;
        }
        catch (Throwable t) {
            logger.warn("Exception:", t);
            return null;
        }
    }

    public byte[] readPartitionGroupStore(String topic, int partitionGroup, long position, int length) {
        try {
            PositioningStore<ByteBuffer> messageStore = this.store.partitionGroupStore(topic, partitionGroup).messageStore();
            return messageStore.readBytes(position, length);
        }
        catch (Throwable t) {
            logger.warn("Exception:", t);
            return null;
        }
    }
}

