/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.joyqueue.store.ReadException;
import org.joyqueue.toolkit.buffer.RByteBuffer;
import org.joyqueue.toolkit.lang.Close;

public class SingleFilePositionStore
implements Closeable {
    private static final byte RS = 30;
    private static final ByteBuffer RS_BUFF = (ByteBuffer)ByteBuffer.wrap(new byte[]{30}).mark();
    private final int fileHeaderSize;
    private final File file;
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;

    public SingleFilePositionStore(File file, int fileHeaderSize) throws IOException {
        this.fileHeaderSize = fileHeaderSize;
        this.file = file;
        this.raf = new RandomAccessFile(file, "rws");
        this.fileChannel = this.raf.getChannel();
        if (this.fileChannel.position() < (long)fileHeaderSize) {
            this.fileChannel.position(fileHeaderSize);
        }
    }

    public synchronized void append(RByteBuffer ... rByteBuffers) throws IOException {
        long position = -1L;
        try {
            position = this.fileChannel.position();
            for (RByteBuffer buff : rByteBuffers) {
                this.appendOne(buff);
            }
            this.fileChannel.force(false);
        }
        catch (Throwable t) {
            this.fileChannel.truncate(position);
            throw t;
        }
    }

    private void appendOne(RByteBuffer byteBuffer) throws IOException {
        try {
            this.fileChannel.write(byteBuffer.getBuffer());
            this.fileChannel.write((ByteBuffer)RS_BUFF.reset());
        }
        finally {
            if (null != byteBuffer) {
                byteBuffer.close();
            }
        }
    }

    public RByteBuffer get(long position) throws IOException {
        int length = this.readMessageLength(position);
        if (length > 4) {
            RByteBuffer rb = new RByteBuffer(ByteBuffer.allocate(length + 1), null);
            int readLength = this.read(rb.getBuffer(), position);
            if (readLength != length + 1) {
                throw new ReadException(String.format("Message length check failed after read. Expect: %d, actual: %d, store: %s, position: %d.", length + 1, rb.remaining(), this.file.getAbsolutePath(), position));
            }
            rb.flip();
            if (30 != rb.get(rb.position() + length)) {
                throw new ReadException(String.format("Message should be end with char:RS(0x1E). Store: %s, position: %d.", this.file.getAbsolutePath(), position));
            }
            rb.limit(rb.limit() - 1);
            return rb;
        }
        return null;
    }

    private int readMessageLength(long position) throws IOException {
        ByteBuffer rb = ByteBuffer.allocate(4);
        int length = this.read(rb, position);
        rb.flip();
        return length == 4 ? rb.getInt() : -1;
    }

    private int read(ByteBuffer buffer, long position) throws IOException {
        return this.fileChannel.read(buffer, this.absPosition(position));
    }

    private long absPosition(long position) {
        return (long)this.fileHeaderSize + position;
    }

    @Override
    public synchronized void close() {
        Close.close((Closeable)this.fileChannel);
        Close.close((Closeable)this.raf);
    }

    public long length() throws IOException {
        return this.fileChannel.position() - (long)this.fileHeaderSize;
    }
}

