/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.StampedLock;
import org.joyqueue.store.file.BufferAppender;
import org.joyqueue.store.file.BufferReader;
import org.joyqueue.store.file.LogSerializer;
import org.joyqueue.store.file.StoreFile;
import org.joyqueue.store.utils.BufferHolder;
import org.joyqueue.store.utils.PreloadBufferPool;
import org.joyqueue.toolkit.concurrent.CasLock;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;

public class StoreFileImpl<T>
implements StoreFile<T>,
BufferHolder {
    private static final Logger logger = LoggerFactory.getLogger(StoreFileImpl.class);
    private static final int MAPPED_BUFFER = 0;
    private static final int DIRECT_BUFFER = 1;
    private static final int NO_BUFFER = -1;
    private final long filePosition;
    private final int headerSize;
    private final boolean loadOnRead;
    private final File file;
    private final StampedLock bufferLock = new StampedLock();
    private final LogSerializer<T> serializer;
    private ByteBuffer pageBuffer = null;
    private int bufferType = -1;
    private PreloadBufferPool bufferPool;
    private final int capacity;
    private long lastAccessTime = SystemClock.now();
    private int flushPosition;
    private int writePosition = 0;
    private long timestamp = -1L;
    private final CasLock fileLock = new CasLock();
    private AtomicBoolean forced = new AtomicBoolean(false);
    private FileChannel fileChannel;
    private RandomAccessFile raf;
    private volatile boolean writeClosed = true;

    StoreFileImpl(long filePosition, File base, int headerSize, LogSerializer<T> serializer, PreloadBufferPool bufferPool, int maxFileDataLength, boolean loadOnRead) {
        this.filePosition = filePosition;
        this.headerSize = headerSize;
        this.serializer = serializer;
        this.bufferPool = bufferPool;
        this.loadOnRead = loadOnRead;
        this.file = new File(base, String.valueOf(filePosition));
        if (this.file.exists() && this.file.length() > (long)headerSize) {
            this.flushPosition = this.writePosition = (int)(this.file.length() - (long)headerSize);
        }
        this.capacity = Math.max(maxFileDataLength, (int)(this.file.length() - (long)headerSize));
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public long position() {
        return this.filePosition;
    }

    private void loadRoUnsafe() throws IOException {
        if (null != this.pageBuffer) {
            throw new IOException("Buffer already loaded!");
        }
        this.bufferPool.allocateMMap(this);
        try {
            MappedByteBuffer loadBuffer;
            try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");
                 FileChannel fileChannel = raf.getChannel();){
                loadBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this.headerSize, this.file.length() - (long)this.headerSize);
            }
            if (this.loadOnRead) {
                loadBuffer.load();
            }
            this.pageBuffer = loadBuffer;
            this.bufferType = 0;
            this.pageBuffer.clear();
            this.forced.set(true);
        }
        catch (ClosedByInterruptException cie) {
            throw cie;
        }
        catch (Throwable t) {
            logger.warn("Exception: ", t);
            this.bufferPool.releaseMMap(this);
            this.pageBuffer = null;
            throw t;
        }
    }

    private void loadRwUnsafe() throws IOException {
        if (this.bufferType == 1) {
            return;
        }
        if (this.bufferType == 0) {
            this.unloadUnsafe();
        }
        this.loadDirectBuffer();
        this.writeClosed = false;
    }

    private void loadDirectBuffer() throws IOException {
        ByteBuffer buffer = this.bufferPool.allocateDirect(this);
        boolean needLoadFileContent = this.file.exists() && this.file.length() > (long)this.headerSize;
        boolean writeTimestamp = !this.file.exists();
        this.raf = new RandomAccessFile(this.file, "rw");
        this.fileChannel = this.raf.getChannel();
        if (writeTimestamp) {
            this.writeTimestamp();
        }
        if (needLoadFileContent) {
            int length;
            logger.debug("Reload file for write! size: {}, file: {}.", (Object)this.file.length(), (Object)this.file);
            this.fileChannel.position(this.headerSize);
            while ((length = this.fileChannel.read(buffer)) > 0) {
            }
            buffer.clear();
        }
        this.pageBuffer = buffer;
        this.bufferType = 1;
    }

    @Override
    public long timestamp() {
        if (this.timestamp == -1L) {
            this.readTimestamp();
        }
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTimestamp() {
        ByteBuffer timeBuffer = ByteBuffer.allocate(8);
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");
             FileChannel fileChannel = raf.getChannel();){
            fileChannel.position(0L);
            fileChannel.read(timeBuffer);
        }
        catch (FileNotFoundException ignored) {
            timeBuffer.putLong(0, -1L);
        }
        catch (Exception e) {
            logger.warn("Exception: ", (Throwable)e);
        }
        finally {
            this.timestamp = timeBuffer.getLong(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTimestamp() {
        ByteBuffer timeBuffer = ByteBuffer.allocate(8);
        long creationTime = SystemClock.now();
        timeBuffer.putLong(0, creationTime);
        this.ensureOpen();
        try {
            this.fileChannel.position(0L);
            this.fileChannel.write(timeBuffer);
        }
        catch (Exception e) {
            logger.warn("Exception:", (Throwable)e);
        }
        finally {
            this.timestamp = creationTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unload() {
        long stamp = this.bufferLock.writeLock();
        try {
            if (this.isClean()) {
                this.unloadUnsafe();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bufferLock.unlockWrite(stamp);
        }
    }

    @Override
    public void forceUnload() {
        long stamp = this.bufferLock.writeLock();
        try {
            this.unloadUnsafe();
        }
        finally {
            this.bufferLock.unlockWrite(stamp);
        }
    }

    @Override
    public boolean hasPage() {
        return this.bufferType != -1;
    }

    @Override
    public T read(int position, int length) throws IOException {
        return this.read(position, length, this.serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R read(int position, int length, BufferReader<R> bufferReader) throws IOException {
        this.touch();
        long stamp = this.bufferLock.readLock();
        try {
            while (!this.hasPage()) {
                long ws = this.bufferLock.tryConvertToWriteLock(stamp);
                if (ws != 0L) {
                    stamp = ws;
                    this.loadRoUnsafe();
                    continue;
                }
                this.bufferLock.unlockRead(stamp);
                stamp = this.bufferLock.writeLock();
            }
            long rs = this.bufferLock.tryConvertToReadLock(stamp);
            if (rs != 0L) {
                stamp = rs;
            }
            ByteBuffer byteBuffer = this.pageBuffer.asReadOnlyBuffer();
            byteBuffer.position(position);
            byteBuffer.limit(this.writePosition);
            R r = bufferReader.read(byteBuffer, length);
            return r;
        }
        finally {
            this.bufferLock.unlock(stamp);
        }
    }

    @Override
    public ByteBuffer readByteBuffer(int position, int length) throws IOException {
        return this.read(position, Math.min(length, this.writePosition - position), (src, len) -> {
            ByteBuffer dest = ByteBuffer.allocate(len);
            if (len < src.remaining()) {
                src.limit(src.position() + len);
            }
            dest.put(src);
            dest.flip();
            return dest;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int append(T t) throws IOException {
        this.touch();
        long stamp = this.bufferLock.readLock();
        try {
            while (this.bufferType != 1) {
                long ws = this.bufferLock.tryConvertToWriteLock(stamp);
                if (ws != 0L) {
                    stamp = ws;
                    this.loadRwUnsafe();
                    continue;
                }
                this.bufferLock.unlockRead(stamp);
                stamp = this.bufferLock.writeLock();
            }
            long rs = this.bufferLock.tryConvertToReadLock(stamp);
            if (rs != 0L) {
                stamp = rs;
            }
            int n = this.appendToPageBuffer(t, this.serializer);
            return n;
        }
        finally {
            this.bufferLock.unlock(stamp);
        }
    }

    private <R> int appendToPageBuffer(R t, BufferAppender<R> bufferAppender) {
        this.pageBuffer.position(this.writePosition);
        int writeLength = bufferAppender.append(t, this.pageBuffer);
        this.writePosition += writeLength;
        return writeLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int appendByteBuffer(ByteBuffer byteBuffer) throws IOException {
        this.touch();
        long stamp = this.bufferLock.readLock();
        try {
            while (this.bufferType != 1) {
                long ws = this.bufferLock.tryConvertToWriteLock(stamp);
                if (ws != 0L) {
                    stamp = ws;
                    this.loadRwUnsafe();
                    continue;
                }
                this.bufferLock.unlockRead(stamp);
                stamp = this.bufferLock.writeLock();
            }
            long rs = this.bufferLock.tryConvertToReadLock(stamp);
            if (rs != 0L) {
                stamp = rs;
            }
            int n = this.appendToPageBuffer(byteBuffer, (src, dest) -> {
                int writeLength = src.remaining();
                dest.put((ByteBuffer)src);
                return writeLength;
            });
            return n;
        }
        finally {
            this.bufferLock.unlock(stamp);
        }
    }

    private void touch() {
        this.lastAccessTime = SystemClock.now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int flush() throws IOException {
        long stamp = this.bufferLock.readLock();
        try {
            if (this.writePosition > this.flushPosition && this.fileLock.tryLock()) {
                try {
                    int n = this.flushPageBuffer(this.fileChannel);
                    return n;
                }
                finally {
                    this.fileLock.unlock();
                }
            }
            int n = 0;
            return n;
        }
        finally {
            this.bufferLock.unlockRead(stamp);
        }
    }

    private int flushPageBuffer(FileChannel fileChannel) throws IOException {
        this.ensureOpen();
        int flushEnd = this.writePosition;
        ByteBuffer flushBuffer = this.pageBuffer.asReadOnlyBuffer();
        flushBuffer.position(this.flushPosition);
        flushBuffer.limit(flushEnd);
        fileChannel.position(this.headerSize + this.flushPosition);
        int flushSize = flushEnd - this.flushPosition;
        while (flushBuffer.hasRemaining()) {
            fileChannel.write(flushBuffer);
        }
        this.flushPosition = flushEnd;
        if (flushSize > 0) {
            this.forced.compareAndSet(true, false);
        }
        return flushSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(int position) throws IOException {
        block32: {
            long stamp = this.bufferLock.writeLock();
            try {
                if (position < this.writePosition) {
                    this.writePosition = position;
                }
                if (position >= this.flushPosition) break block32;
                this.fileLock.waitAndLock();
                try {
                    this.flushPosition = position;
                    if (this.fileChannel != null && this.fileChannel.isOpen()) {
                        this.fileChannel.truncate(position + this.headerSize);
                        break block32;
                    }
                    try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
                         FileChannel fileChannel = raf.getChannel();){
                        fileChannel.truncate(position + this.headerSize);
                    }
                }
                finally {
                    this.fileLock.unlock();
                }
            }
            finally {
                this.bufferLock.unlockWrite(stamp);
            }
        }
    }

    @Override
    public boolean isClean() {
        return this.flushPosition >= this.writePosition;
    }

    @Override
    public int writePosition() {
        return this.writePosition;
    }

    @Override
    public int fileDataSize() {
        return Math.max((int)this.file.length() - this.headerSize, 0);
    }

    @Override
    public int flushPosition() {
        return this.flushPosition;
    }

    @Override
    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    private void unloadUnsafe() {
        if (0 == this.bufferType) {
            this.unloadMappedBuffer();
        } else if (1 == this.bufferType) {
            this.unloadDirectBuffer();
            try {
                this.closeFileChannel();
            }
            catch (IOException e) {
                logger.warn("Close file {} exception: ", (Object)this.file.getAbsolutePath(), (Object)e);
            }
            this.writeClosed = true;
        }
    }

    private void closeFileChannel() throws IOException {
        this.force();
        if (null != this.fileChannel) {
            this.fileChannel.close();
        }
        if (null != this.raf) {
            this.raf.close();
        }
    }

    private void unloadDirectBuffer() {
        ByteBuffer direct = this.pageBuffer;
        this.pageBuffer = null;
        this.bufferType = -1;
        if (null != direct) {
            this.bufferPool.releaseDirect(direct, this);
        }
    }

    private void unloadMappedBuffer() {
        try {
            ByteBuffer mapped = this.pageBuffer;
            this.pageBuffer = null;
            this.bufferType = -1;
            if (null != mapped) {
                Method getCleanerMethod = mapped.getClass().getMethod("cleaner", new Class[0]);
                getCleanerMethod.setAccessible(true);
                Cleaner cleaner = (Cleaner)getCleanerMethod.invoke((Object)mapped, new Object[0]);
                cleaner.clean();
            }
            this.bufferPool.releaseMMap(this);
        }
        catch (Exception e) {
            logger.warn("Release direct buffer exception: ", (Throwable)e);
        }
    }

    @Override
    public int size() {
        return this.capacity;
    }

    @Override
    public boolean isFree() {
        return this.isClean();
    }

    @Override
    public boolean evict() {
        return this.unload();
    }

    @Override
    public void force() throws IOException {
        if (this.forced.compareAndSet(false, true)) {
            this.fileLock.waitAndLock();
            this.ensureOpen();
            try {
                this.fileChannel.force(true);
            }
            catch (Throwable t) {
                this.forced.set(false);
                throw t;
            }
            finally {
                this.fileLock.unlock();
            }
        }
    }

    private void ensureOpen() {
        if (this.fileChannel == null || !this.fileChannel.isOpen()) {
            throw new IllegalStateException(String.format("File %s is not open!", this.file.getAbsolutePath()));
        }
    }

    @Override
    public void closeWrite() {
        this.writeClosed = true;
    }

    @Override
    public boolean writable() {
        return this.bufferType == 1 && !this.writeClosed;
    }
}

