/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store.file;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.joyqueue.store.PartialLogException;
import org.joyqueue.store.ReadException;
import org.joyqueue.store.file.LogSerializer;
import org.joyqueue.store.message.MessageParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMessageSerializer
implements LogSerializer<ByteBuffer> {
    private static final Logger logger = LoggerFactory.getLogger(StoreMessageSerializer.class);
    private final long maxLogLength;

    public StoreMessageSerializer(long maxLogLength) {
        this.maxLogLength = maxLogLength;
    }

    private static boolean checkCRC(ByteBuffer buffer) {
        ByteBuffer body = MessageParser.getByteBuffer((ByteBuffer)buffer, (int)MessageParser.BODY);
        if (body.remaining() > 0) {
            CRC32 crc32 = new CRC32();
            crc32.update(body);
            long crc = crc32.getValue();
            return crc == MessageParser.getLong((ByteBuffer)buffer, (int)MessageParser.CRC);
        }
        return false;
    }

    private ByteBuffer read(ByteBuffer src) {
        int length;
        ByteBuffer buffer;
        if (src.remaining() >= 4 && StoreMessageSerializer.checkCRC(buffer = this.readByLength(src, length = src.getInt(src.position())))) {
            return buffer;
        }
        throw new ReadException();
    }

    @Override
    public ByteBuffer read(ByteBuffer src, int length) {
        src.mark();
        try {
            if (length < 0) {
                return this.read(src);
            }
            return this.readByLength(src, length);
        }
        catch (Throwable t) {
            src.reset();
            throw t;
        }
    }

    private ByteBuffer readByLength(ByteBuffer src, int length) {
        if (length > 4 && (long)length < this.maxLogLength) {
            if (src.remaining() < length) {
                throw new PartialLogException();
            }
            byte[] readBuffer = new byte[length];
            src.get(readBuffer, 0, length);
            ByteBuffer buffer = ByteBuffer.wrap(readBuffer);
            return buffer;
        }
        throw new ReadException();
    }

    @Override
    public int trim(ByteBuffer src, int length) {
        int pos;
        int vRemaining;
        int len;
        ByteBuffer sliced = src.slice();
        int lengthOfSrc = sliced.remaining();
        int term = -1;
        for (pos = 0; (vRemaining = lengthOfSrc - pos) > MessageParser.getFixedAttributesLength() && pos < length; pos += len) {
            len = sliced.getInt(pos);
            if (len > MessageParser.getFixedAttributesLength() && (long)len < this.maxLogLength) {
                if (vRemaining < len) break;
                if (term < 0) {
                    term = sliced.getInt(pos + MessageParser.TERM);
                    continue;
                }
                if (term != sliced.getInt(pos + MessageParser.TERM)) break;
                continue;
            }
            logger.warn("Invalid length! length from message: {}, message offset: {}", (Object)len, (Object)pos);
            throw new ReadException();
        }
        return pos;
    }

    @Override
    public int size(ByteBuffer buffer) {
        return buffer.remaining();
    }

    @Override
    public int append(ByteBuffer from, ByteBuffer to) {
        int length = from.remaining();
        from.mark();
        to.put(from);
        from.reset();
        return length;
    }
}

