/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store.index;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.joyqueue.store.index.BuildIndexFailedException;
import org.joyqueue.store.message.MessageParser;

public class IndexItem {
    public static final int STORAGE_SIZE = 12;
    private short partition;
    private long index;
    private long offset;
    private int length;
    private boolean isBatchMessage = false;
    private short batchMessageSize = 1;

    public IndexItem() {
    }

    public IndexItem(short partition, long index, int length, long offset) {
        this.partition = partition;
        this.index = index;
        this.length = length;
        this.offset = offset;
    }

    public static IndexItem parseMessage(ByteBuffer byteBuffer, long offset) throws BuildIndexFailedException {
        try {
            return new IndexItem(MessageParser.getShort((ByteBuffer)byteBuffer, (int)MessageParser.PARTITION), MessageParser.getLong((ByteBuffer)byteBuffer, (int)MessageParser.INDEX), MessageParser.getInt((ByteBuffer)byteBuffer, (int)MessageParser.LENGTH), offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new BuildIndexFailedException(e);
        }
    }

    public static IndexItem from(ByteBuffer byteBuffer, short partition, long index) {
        IndexItem indexItem = IndexItem.from(byteBuffer);
        indexItem.setPartition(partition);
        indexItem.setIndex(index);
        return indexItem;
    }

    public static IndexItem from(ByteBuffer byteBuffer) {
        IndexItem indexItem = new IndexItem();
        indexItem.setOffset(byteBuffer.getLong());
        indexItem.setLength(byteBuffer.getInt());
        return indexItem;
    }

    public short getPartition() {
        return this.partition;
    }

    public void setPartition(short partition) {
        this.partition = partition;
    }

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void serializeTo(ByteBuffer buffer) {
        buffer.putLong(this.offset);
        buffer.putInt(this.length);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IndexItem) {
            IndexItem indexItem = (IndexItem)obj;
            return indexItem.getOffset() == this.getOffset() && indexItem.getIndex() == this.getIndex() && indexItem.getLength() == indexItem.getLength() && indexItem.getPartition() == this.getPartition();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.index, this.length, this.partition);
    }

    public boolean isBatchMessage() {
        return this.isBatchMessage;
    }

    public void setBatchMessage(boolean batchMessage) {
        this.isBatchMessage = batchMessage;
    }

    public short getBatchMessageSize() {
        return this.batchMessageSize;
    }

    public void setBatchMessageSize(short batchMessageSize) {
        this.batchMessageSize = batchMessageSize;
    }
}

