/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store.transaction;

import java.nio.ByteBuffer;
import org.joyqueue.store.PartialLogException;
import org.joyqueue.store.ReadException;
import org.joyqueue.store.file.LogSerializer;

public class TransactionMessageSerializer
implements LogSerializer<ByteBuffer> {
    private ByteBuffer read(ByteBuffer src) {
        if (src.remaining() >= 4) {
            int length = src.getInt(src.position());
            return this.readByLength(src, length);
        }
        throw new ReadException();
    }

    @Override
    public ByteBuffer read(ByteBuffer src, int length) {
        src.mark();
        try {
            if (length < 0) {
                return this.read(src);
            }
            return this.readByLength(src, length);
        }
        catch (Throwable t) {
            src.reset();
            throw t;
        }
    }

    private ByteBuffer readByLength(ByteBuffer src, int length) {
        if (length > 4) {
            if (src.remaining() < length) {
                throw new PartialLogException();
            }
            byte[] readBuffer = new byte[length];
            src.get(readBuffer, 0, length);
            ByteBuffer buffer = ByteBuffer.wrap(readBuffer);
            return buffer;
        }
        throw new ReadException();
    }

    @Override
    public int trim(ByteBuffer src, int length) {
        int pos;
        int vRemaining;
        int len;
        ByteBuffer sliced = src.slice();
        int lengthOfSrc = sliced.remaining();
        for (pos = 0; (vRemaining = lengthOfSrc - pos) > 4 && pos < length; pos += len) {
            len = sliced.getInt(pos);
            if (len > 4) {
                if (vRemaining < len) break;
                continue;
            }
            throw new ReadException();
        }
        return pos;
    }

    @Override
    public int size(ByteBuffer buffer) {
        return buffer.remaining();
    }

    @Override
    public int append(ByteBuffer from, ByteBuffer to) {
        int length = from.remaining();
        from.mark();
        to.put(from);
        from.reset();
        return length;
    }
}

