/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store.transaction;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.store.ReadException;
import org.joyqueue.store.StoreInitializeException;
import org.joyqueue.store.WriteResult;
import org.joyqueue.store.file.PositioningStore;
import org.joyqueue.store.transaction.TransactionMessageSerializer;
import org.joyqueue.store.transaction.TransactionStore;
import org.joyqueue.store.utils.PreloadBufferPool;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionStoreManager
implements TransactionStore,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TransactionStoreManager.class);
    private final File base;
    private final AtomicInteger idSequence;
    private final ExecutorService writeExecutor;
    private final Map<Integer, PositioningStore<ByteBuffer>> storeMap;
    private final PositioningStore.Config config;
    private final PreloadBufferPool bufferPool;

    public TransactionStoreManager(File base, PositioningStore.Config config, PreloadBufferPool bufferPool) {
        this.base = base;
        this.config = config;
        this.bufferPool = bufferPool;
        this.idSequence = new AtomicInteger(0);
        this.loadFiles();
        this.writeExecutor = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1024), new ThreadPoolExecutor.AbortPolicy());
        this.storeMap = new HashMap<Integer, PositioningStore<ByteBuffer>>();
    }

    private void loadFiles() {
        if (!this.base.isDirectory()) {
            throw new StoreInitializeException(String.format("Init transaction store directory failed! Directory NOT exists: %s!", this.base.getAbsolutePath()));
        }
        File[] files = this.base.listFiles();
        if (files != null) {
            this.idSequence.set(Arrays.stream(files).filter(File::isDirectory).map(File::getName).filter(fileName -> fileName.matches("\\d+")).mapToInt(Integer::parseInt).max().orElse(-1));
            this.idSequence.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PositioningStore<ByteBuffer> get(int id) {
        Map<Integer, PositioningStore<ByteBuffer>> map = this.storeMap;
        synchronized (map) {
            return this.storeMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PositioningStore<ByteBuffer> getOrCreate(int id) throws IOException {
        Map<Integer, PositioningStore<ByteBuffer>> map = this.storeMap;
        synchronized (map) {
            if (!this.storeMap.containsKey(id)) {
                File storeBase = new File(this.base, String.valueOf(id));
                if (storeBase.exists() || storeBase.mkdir()) {
                    PositioningStore<ByteBuffer> store = new PositioningStore<ByteBuffer>(storeBase, this.config, this.bufferPool, new TransactionMessageSerializer());
                    this.storeMap.put(id, store);
                    return store;
                }
                throw new IOException(String.format("Failed to create directory: %s.", storeBase.getAbsolutePath()));
            }
            return this.storeMap.get(id);
        }
    }

    private WriteResult write(int id, List<ByteBuffer> messages) {
        WriteResult writeResult = new WriteResult();
        try {
            PositioningStore<ByteBuffer> positioningStore = this.getOrCreate(id);
            positioningStore.append(messages);
            positioningStore.flush();
            writeResult.setCode(JoyQueueCode.SUCCESS);
        }
        catch (Throwable t) {
            logger.warn("Write transaction file \"{}/{}\" exception: ", new Object[]{this.base.getAbsoluteFile(), id, t});
            writeResult.setCode(JoyQueueCode.CN_TRANSACTION_EXECUTE_ERROR);
        }
        return writeResult;
    }

    public int next() {
        return this.idSequence.getAndIncrement();
    }

    public int[] list() {
        File[] files = this.base.listFiles();
        if (files != null) {
            return Arrays.stream(files).map(File::getName).filter(fileName -> fileName.matches("\\d+")).mapToInt(Integer::parseInt).sorted().toArray();
        }
        return new int[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int id) {
        Map<Integer, PositioningStore<ByteBuffer>> map = this.storeMap;
        synchronized (map) {
            PositioningStore<ByteBuffer> store = this.storeMap.remove(id);
            if (null != store) {
                store.close();
            }
        }
        File txFile = new File(this.base, String.valueOf(id));
        try {
            return this.deleteFolder(txFile);
        }
        catch (IOException e) {
            logger.warn("Exception: ", (Throwable)e);
            return false;
        }
    }

    public Future<WriteResult> asyncWrite(int id, ByteBuffer ... messages) {
        return this.writeExecutor.submit(new WriteTask(id, Arrays.asList(messages)));
    }

    public Iterator<ByteBuffer> readIterator(int id) {
        PositioningStore<ByteBuffer> store = this.get(id);
        return store == null ? null : new ReadIterator(store);
    }

    @Override
    public void close() {
        long timeout = 5000L;
        long t0 = SystemClock.now();
        this.writeExecutor.shutdown();
        while (!this.writeExecutor.isTerminated() && SystemClock.now() - t0 < timeout) {
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(100L));
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.writeExecutor.isTerminated()) {
            logger.warn("Failed to shutdown executor!");
        }
        this.storeMap.values().forEach(PositioningStore::close);
    }

    private boolean deleteFolder(File folder) throws IOException {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteFolder(f);
                    continue;
                }
                if (f.delete()) continue;
                throw new IOException(String.format("Can not delete file: %s", f.getAbsolutePath()));
            }
        }
        return folder.delete();
    }

    private class ReadIterator
    implements Iterator<ByteBuffer> {
        private final PositioningStore<ByteBuffer> store;
        private final long right;
        private long position;

        private ReadIterator(PositioningStore<ByteBuffer> store) {
            this.store = store;
            this.right = store.right();
            this.position = 0L;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.right;
        }

        @Override
        public ByteBuffer next() {
            if (this.hasNext()) {
                try {
                    ByteBuffer buffer = this.store.read(this.position);
                    this.position += (long)buffer.remaining();
                    return buffer;
                }
                catch (Throwable t) {
                    throw new ReadException(t);
                }
            }
            throw new NoSuchElementException();
        }
    }

    private class WriteTask
    implements Callable<WriteResult> {
        private final int id;
        private final List<ByteBuffer> messages;

        WriteTask(int id, List<ByteBuffer> messages) {
            this.id = id;
            this.messages = messages;
        }

        @Override
        public WriteResult call() {
            return TransactionStoreManager.this.write(this.id, this.messages);
        }
    }
}

