/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store.utils;

import java.nio.ByteBuffer;

public class ByteBufferUtils {
    public static void copy(ByteBuffer from, ByteBuffer to) {
        if (from.remaining() <= to.remaining()) {
            to.put(from);
        } else {
            int toSize = to.remaining();
            if (from.hasArray()) {
                to.put(from.array(), from.arrayOffset() + from.position(), to.remaining());
                from.position(from.position() + toSize);
            } else {
                while (to.hasRemaining() && from.hasRemaining()) {
                    to.put(from.get());
                }
            }
        }
    }

    public static void concat(ByteBuffer dest, ByteBuffer ... srcs) {
        for (ByteBuffer src : srcs) {
            ByteBufferUtils.copy(src, dest);
            if (!dest.hasRemaining()) break;
        }
    }
}

