/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.CRC32;
import org.joyqueue.store.message.BatchMessageParser;
import org.joyqueue.store.message.MessageParser;

public class MessageUtils {
    static byte[] b1024;
    private static byte[] bid;
    private static byte[] prop;
    private static byte[] expand;
    private static byte[] app;

    public static List<ByteBuffer> build(int count, int bodyLength) {
        byte[] body = new byte[bodyLength];
        return IntStream.range(0, count).mapToObj(i -> {
            Arrays.fill(body, (byte)(i % 127));
            byte[][] varAtts = new byte[][]{body, bid, prop, expand, app};
            ByteBuffer byteBuffer = MessageParser.build((byte[][])varAtts);
            CRC32 crc32 = new CRC32();
            crc32.update(body);
            MessageParser.setLong((ByteBuffer)byteBuffer, (int)MessageParser.CRC, (long)crc32.getValue());
            return byteBuffer;
        }).collect(Collectors.toList());
    }

    public static ByteBuffer[] build1024(int count) {
        return (ByteBuffer[])IntStream.range(0, count).parallel().mapToObj(i -> ByteBuffer.wrap(Arrays.copyOf(b1024, b1024.length))).toArray(ByteBuffer[]::new);
    }

    public static ByteBuffer toBatchMessage(ByteBuffer msg, short batchSize) {
        BatchMessageParser.setBatch((ByteBuffer)msg, (boolean)true);
        BatchMessageParser.setBatchSize((ByteBuffer)msg, (short)batchSize);
        return msg;
    }

    public static ByteBuffer build1024() {
        return ByteBuffer.wrap(Arrays.copyOf(b1024, b1024.length));
    }

    public static void main(String[] args) {
        List<ByteBuffer> buffers = MessageUtils.build(1, 1024);
        System.out.println(MessageParser.getString((ByteBuffer)buffers.get(0)));
    }

    static {
        bid = new byte[]{0, 0, 0, 0};
        prop = new byte[]{0, 0, 0, 0};
        expand = new byte[]{0, 0, 0, 0};
        app = new byte[]{0, 0, 0, 0};
        byte[] body = new byte[1024];
        byte[][] varAtts = new byte[][]{body, bid, prop, expand, app};
        ByteBuffer byteBuffer = MessageParser.build((byte[][])varAtts);
        CRC32 crc32 = new CRC32();
        crc32.update(body);
        MessageParser.setLong((ByteBuffer)byteBuffer, (int)MessageParser.CRC, (long)crc32.getValue());
        b1024 = byteBuffer.array();
    }
}

