/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.converter.kafka.compressor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.joyqueue.client.internal.consumer.converter.kafka.compressor.KafkaCompressionCodec;
import org.joyqueue.client.internal.consumer.converter.kafka.compressor.lz4.KafkaLZ4BlockInputStream;
import org.joyqueue.client.internal.consumer.converter.kafka.compressor.lz4.KafkaLZ4BlockOutputStream;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public final class KafkaCompressionCodecFactory {
    public static OutputStream apply(KafkaCompressionCodec codec, OutputStream stream, byte messageVersion) throws IOException {
        switch (codec) {
            case GZIPCompressionCodec: {
                return new GZIPOutputStream(stream);
            }
            case SnappyCompressionCodec: {
                return new SnappyOutputStream(stream);
            }
            case LZ4CompressionCodec: {
                return new KafkaLZ4BlockOutputStream(stream);
            }
        }
        throw new RuntimeException(String.format("unknown codec: %s", new Object[]{codec}));
    }

    public static InputStream apply(KafkaCompressionCodec codec, InputStream stream, byte messageVersion) throws IOException {
        switch (codec) {
            case GZIPCompressionCodec: {
                return new GZIPInputStream(stream);
            }
            case SnappyCompressionCodec: {
                return new SnappyInputStream(stream);
            }
            case LZ4CompressionCodec: {
                return new KafkaLZ4BlockInputStream(stream, messageVersion == 0);
            }
        }
        throw new RuntimeException(String.format("unknown codec: %s", new Object[]{codec}));
    }
}

