/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.converter.kafka.compressor.stream;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() {
        if (this.buffer != null && this.buffer.hasRemaining()) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int off, int len) {
        if (this.buffer != null && this.buffer.hasRemaining()) {
            int realLen = Math.min(len, this.buffer.remaining());
            this.buffer.get(bytes, off, realLen);
            return realLen;
        }
        return -1;
    }
}

