/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx;

import com.jd.laf.extension.Prototype;
import com.jd.laf.extension.Type;

public interface Command<T>
extends Type<String>,
Cloneable,
Prototype {
    public static final String RESULT = "result";

    default public T execute() throws Exception {
        throw new UnsupportedOperationException();
    }

    default public String type() {
        String name = this.getClass().getSimpleName();
        int length = name.length();
        if (name.endsWith("Command")) {
            length -= 7;
        }
        char[] chars = new char[length];
        name.getChars(0, length, chars, 0);
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static enum ResultType {
        CONTINUE,
        END,
        HOLD;

    }

    public static class EmptyHold
    extends Result {
        public EmptyHold() {
            super(ResultType.HOLD, null, null);
        }
    }

    public static class EmptyContinue
    extends Result {
        public EmptyContinue() {
            super(ResultType.CONTINUE, null, null);
        }
    }

    public static class Result {
        ResultType type;
        Object result;
        String key;
        String template;

        public Result(Object result) {
            this(ResultType.CONTINUE, result, null, null);
        }

        public Result(Object result, String template) {
            this(ResultType.CONTINUE, result, null, template);
        }

        public Result(ResultType type, Object result) {
            this(type, result, null, null);
        }

        public Result(ResultType type, Object result, String key) {
            this(type, result, key, null);
        }

        public Result(ResultType type, Object result, String key, String template) {
            this.type = type == null ? ResultType.CONTINUE : type;
            this.result = result;
            this.key = key == null && result != null ? Command.RESULT : key;
            this.template = template;
        }

        public ResultType getType() {
            return this.type;
        }

        public Object getResult() {
            return this.result;
        }

        public String getKey() {
            return this.key;
        }

        public String getTemplate() {
            return this.template;
        }
    }
}

