/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface Environment {
    public static final String WEB_ROOT = "web.root";
    public static final String INDEX_PAGE = "web.indexPage";
    public static final String BODY_LIMIT = "web.bodyLimit";
    public static final String UPLOAD_DIR = "web.uploadDir";
    public static final String VALIDATOR = "validator";
    public static final String TEMPLATE = "template";
    public static final String COMMAND_POOL_CAPACITY = "command.pool.capacity";
    public static final String COMMAND_POOL_INITIALIZE_SIZE = "command.pool.initialize.size";
    public static final String SESSION_LOCAL = "session.local";
    public static final String SESSION_NAME = "session.name";
    public static final String SESSION_COOKIE_NAME = "session.cookie.name";
    public static final String SESSION_TIMEOUT = "session.timeout";
    public static final String USER_KEY = "userDetail";
    public static final String REMOTE_IP = "remoteIp";
    public static final String AUTH_PROVIDER = "auth.provider";
    public static final String AUTH_REDIRECT_URL = "auth.redirect.url";
    public static final String AUTH_RETURN_URL_PARAM = "auth.return.urlParam";
    public static final String AUTH_USER_PARAM = "auth.userParam";
    public static final String AUTH_PASSWORD_PARAM = "auth.passwordParam";
    public static final String TEMPLATE_ENGINE = "template.engine";
    public static final String TEMPLATE_TYPE = "template.type";
    public static final String TEMPLATE_DIRECTORY = "template.directory";
    public static final String TEMPLATE_CONTENT_TYPE = "template.contentType";
    public static final String TEMPLATE_EXTENSION = "template.extension";
    public static final String TEMPLATE_CACHE_SIZE = "template.cache.size";

    public <T> T getObject(String var1);

    default public <T> T getObject(String name, Class<T> clazz) {
        return this.getObject(name);
    }

    default public String getString(String name) {
        Object result = this.getObject(name);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    default public String getString(String name, String def) {
        String value = this.getString(name);
        return value == null || value.isEmpty() ? def : value;
    }

    default public Byte getByte(String name) {
        Object result = this.getObject(name);
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            return ((Number)result).byteValue();
        }
        if (result instanceof CharSequence || result instanceof Character) {
            String text = result.toString();
            if (text == null || text.isEmpty()) {
                return null;
            }
            try {
                return Byte.parseByte(text);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    default public Byte getByte(String name, Byte def) {
        Byte result = this.getByte(name);
        return result == null ? def : result;
    }

    default public Short getShort(String name) {
        Object result = this.getObject(name);
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            return ((Number)result).shortValue();
        }
        if (result instanceof CharSequence || result instanceof Character) {
            String text = result.toString();
            if (text == null || text.isEmpty()) {
                return null;
            }
            try {
                return Short.parseShort(text);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    default public Short getShort(String name, Short def) {
        Short result = this.getShort(name);
        return result == null ? def : result;
    }

    default public Integer getInteger(String name) {
        Object result = this.getObject(name);
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        if (result instanceof CharSequence || result instanceof Character) {
            String text = result.toString();
            if (text == null || text.isEmpty()) {
                return null;
            }
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    default public Integer getInteger(String name, Integer def) {
        Integer result = this.getInteger(name);
        return result == null ? def : result;
    }

    default public Long getLong(String name) {
        Object result = this.getObject(name);
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            return ((Number)result).longValue();
        }
        if (result instanceof CharSequence || result instanceof Character) {
            String text = result.toString();
            if (text == null || text.isEmpty()) {
                return null;
            }
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    default public Long getLong(String name, Long def) {
        Long result = this.getLong(name);
        return result == null ? def : result;
    }

    default public Float getFloat(String name) {
        Object result = this.getObject(name);
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            return Float.valueOf(((Number)result).floatValue());
        }
        if (result instanceof CharSequence || result instanceof Character) {
            String text = result.toString();
            if (text == null || text.isEmpty()) {
                return null;
            }
            try {
                return Float.valueOf(Float.parseFloat(text));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    default public Float getFloat(String name, Float def) {
        Float result = this.getFloat(name);
        return result == null ? def : result;
    }

    default public Double getDouble(String name) {
        Object result = this.getObject(name);
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        if (result instanceof CharSequence || result instanceof Character) {
            String text = result.toString();
            if (text == null || text.isEmpty()) {
                return null;
            }
            try {
                return Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    default public Double getDouble(String name, Double def) {
        Double result = this.getDouble(name);
        return result == null ? def : result;
    }

    default public Boolean getBoolean(String name) {
        Object result = this.getObject(name);
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            return ((Number)result).longValue() != 0L;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof Character) {
            return ((Character)result).charValue() != '0';
        }
        if (result instanceof CharSequence) {
            String value = result.toString();
            if ("true".equalsIgnoreCase(value)) {
                return true;
            }
            if ("false".equalsIgnoreCase(value)) {
                return false;
            }
            try {
                return Long.parseLong(value) != 0L;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    default public Boolean getBoolean(String name, Boolean def) {
        Boolean result = this.getBoolean(name);
        return result == null ? def : result;
    }

    default public Date getDate(String name) {
        Object result = this.getObject(name);
        if (result == null) {
            return null;
        }
        if (result instanceof Date) {
            return (Date)result;
        }
        if (result instanceof Number) {
            return new Date(((Number)result).longValue());
        }
        if (result instanceof CharSequence) {
            String value = result.toString();
            try {
                return new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    default public Date getDate(String name, Date def) {
        Date result = this.getDate(name);
        return result == null ? def : result;
    }

    default public Date getDate(String name, SimpleDateFormat format) {
        Object result = this.getObject(name);
        if (result == null) {
            return null;
        }
        if (result instanceof Date) {
            return (Date)result;
        }
        if (result instanceof Number) {
            return new Date(((Number)result).longValue());
        }
        if (format == null) {
            return null;
        }
        if (result instanceof CharSequence) {
            String value = result.toString();
            try {
                return format.parse(value);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    default public Date getDate(String name, SimpleDateFormat format, Date def) {
        Date result = this.getDate(name, format);
        return result == null ? def : result;
    }

    default public Date getDate(String name, String format, String def) {
        SimpleDateFormat sdf = format == null || format.isEmpty() ? null : new SimpleDateFormat(format);
        Date result = this.getDate(name, sdf);
        try {
            return result == null ? (sdf == null || def == null || def.isEmpty() ? null : sdf.parse(def)) : result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    default public Byte getPositive(String name, Byte def) {
        Byte result = this.getByte(name, def);
        return result != null && result <= 0 ? def : result;
    }

    default public Short getPositive(String name, Short def) {
        Short result = this.getShort(name, def);
        return result != null && result <= 0 ? def : result;
    }

    default public Integer getPositive(String name, Integer def) {
        Integer result = this.getInteger(name, def);
        return result != null && result <= 0 ? def : result;
    }

    default public Long getPositive(String name, Long def) {
        Long result = this.getLong(name, def);
        return result != null && result <= 0L ? def : result;
    }

    default public Short getNatural(String name, Short def) {
        Short result = this.getShort(name, def);
        return result != null && result < 0 ? def : result;
    }

    default public Byte getNatural(String name, Byte def) {
        Byte result = this.getByte(name, def);
        return result != null && result < 0 ? def : result;
    }

    default public Integer getNatural(String name, Integer def) {
        Integer result = this.getInteger(name, def);
        return result != null && result < 0 ? def : result;
    }

    default public Long getNatural(String name, Long def) {
        Long result = this.getLong(name, def);
        return result != null && result < 0L ? def : result;
    }

    public void put(String var1, Object var2);

    public static class MapEnvironment
    implements Environment {
        protected Map<String, Object> parameters;

        public MapEnvironment() {
            this(null);
        }

        public MapEnvironment(Map<String, Object> parameters) {
            this.parameters = parameters == null ? new ConcurrentHashMap<String, Object>() : new ConcurrentHashMap<String, Object>(parameters);
        }

        @Override
        public <T> T getObject(String name) {
            return (T)(this.parameters == null ? null : this.parameters.get(name));
        }

        @Override
        public void put(String name, Object obj) {
            if (this.parameters != null) {
                this.parameters.put(name, obj);
            }
        }
    }
}

