/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx;

import com.jd.laf.binding.Binding;
import com.jd.laf.binding.reflect.PropertySupplier;
import com.jd.laf.binding.reflect.exception.ReflectionException;
import com.jd.laf.extension.ExtensionMeta;
import com.jd.laf.web.vertx.Blocking;
import com.jd.laf.web.vertx.Command;
import com.jd.laf.web.vertx.ConnectionHandler;
import com.jd.laf.web.vertx.Environment;
import com.jd.laf.web.vertx.ErrorHandler;
import com.jd.laf.web.vertx.ExceptionHandler;
import com.jd.laf.web.vertx.Plugin;
import com.jd.laf.web.vertx.RouteAware;
import com.jd.laf.web.vertx.RouteProvider;
import com.jd.laf.web.vertx.Validates;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.config.RouteConfig;
import com.jd.laf.web.vertx.config.RouteType;
import com.jd.laf.web.vertx.config.VertxConfig;
import com.jd.laf.web.vertx.handler.RenderHandler;
import com.jd.laf.web.vertx.lifecycle.Registrar;
import com.jd.laf.web.vertx.message.RouteMessage;
import com.jd.laf.web.vertx.pool.Pool;
import com.jd.laf.web.vertx.pool.PoolFactory;
import com.jd.laf.web.vertx.pool.Poolable;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.MyRoute;
import io.vertx.ext.web.impl.MyRouter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class RoutingVerticle
extends AbstractVerticle {
    public static final String ROUTING_CONFIG_FILE = "vertx.file";
    public static final String DEFAULT_ROUTING_CONFIG_FILE = "routing.xml";
    public static final int DEFAULT_PORT = 8080;
    protected static final Logger logger = LoggerFactory.getLogger(RoutingVerticle.class);
    protected static final AtomicLong counter = new AtomicLong(0L);
    protected Environment env;
    protected HttpServerOptions httpOptions;
    protected String file;
    protected List<RouteProvider> providers;
    protected MessageConsumer consumer;
    protected VertxConfig config;
    protected HttpServer httpServer;
    protected Router router;
    protected long id;

    public RoutingVerticle() {
        this(new Environment.MapEnvironment(), new HttpServerOptions().setPort(8080), DEFAULT_ROUTING_CONFIG_FILE, null);
    }

    public RoutingVerticle(Environment env) {
        this(env, new HttpServerOptions().setPort(8080), DEFAULT_ROUTING_CONFIG_FILE, null);
    }

    public RoutingVerticle(Environment env, HttpServerOptions httpOptions) {
        this(env, httpOptions, DEFAULT_ROUTING_CONFIG_FILE, null);
    }

    public RoutingVerticle(Environment env, HttpServerOptions httpOptions, String file) {
        this(env, httpOptions, file, null);
    }

    public RoutingVerticle(Environment env, HttpServerOptions httpOptions, String file, List<RouteProvider> providers) {
        this.env = env != null ? env : new Environment.MapEnvironment();
        this.httpOptions = httpOptions == null ? new HttpServerOptions().setPort(8080) : httpOptions;
        this.file = file != null ? file : env.getString(ROUTING_CONFIG_FILE, DEFAULT_ROUTING_CONFIG_FILE);
        this.providers = providers;
        this.id = counter.incrementAndGet();
    }

    public RoutingVerticle(Map<String, Object> parameters) {
        this(new Environment.MapEnvironment(parameters), new HttpServerOptions().setPort(8080), DEFAULT_ROUTING_CONFIG_FILE, null);
    }

    public RoutingVerticle(Map<String, Object> parameters, HttpServerOptions httpOptions) {
        this(new Environment.MapEnvironment(parameters), httpOptions, DEFAULT_ROUTING_CONFIG_FILE, null);
    }

    public RoutingVerticle(Map<String, Object> parameters, HttpServerOptions httpOptions, String file) {
        this(new Environment.MapEnvironment(parameters), httpOptions, file, null);
    }

    public RoutingVerticle(Map<String, Object> parameters, HttpServerOptions httpOptions, String file, List<RouteProvider> providers) {
        this(new Environment.MapEnvironment(parameters), httpOptions, file, providers);
    }

    public void start() throws Exception {
        try {
            this.config = VertxConfig.Builder.inherit(VertxConfig.Builder.build(this.file));
            this.register(this.vertx, this.env, this.config);
            this.router = this.createRouter(this.env);
            this.addRoutes(this.router, this.config.getRoutes(), this.env);
            if (this.providers != null) {
                for (RouteProvider provider : this.providers) {
                    this.addRoutes(this.router, provider.getRoutes(), this.env);
                }
            }
            this.startHttpServer();
            this.dynamicRoute();
            logger.info((Object)String.format("success starting routing verticle %d at %s", this.id, this.deploymentID()));
        }
        catch (Exception e) {
            logger.error((Object)String.format("failed starting routing verticle %d at %s", this.id, this.deploymentID()), (Throwable)e);
            throw e;
        }
    }

    protected void dynamicRoute() {
        this.consumer = this.vertx.eventBus().consumer("system_routes", event -> {
            RouteMessage message = (RouteMessage)event.body();
            switch (message.getType()) {
                case ADD: {
                    this.addRoute(message.getConfig());
                    break;
                }
                case REMOVE: {
                    this.removeRoute(message.getConfig());
                }
            }
        });
    }

    protected void startHttpServer() {
        this.httpServer = this.vertx.createHttpServer(this.httpOptions);
        ExceptionHandler exceptionHandler = (ExceptionHandler)Plugin.EXCEPTION.get((Object)this.config.getException());
        ConnectionHandler connectionHandler = (ConnectionHandler)Plugin.CONNECTION.get((Object)this.config.getConnection());
        if (exceptionHandler != null) {
            this.httpServer.exceptionHandler((Handler)exceptionHandler);
        }
        if (connectionHandler != null) {
            this.httpServer.connectionHandler((Handler)connectionHandler);
        }
        this.httpServer.requestHandler((Handler)this.router);
        this.httpServer.listen(event -> {
            if (event.succeeded()) {
                logger.info((Object)String.format("success binding http listener %d on port %d", this.id, this.httpServer.actualPort()));
            } else {
                logger.error((Object)String.format("failed binding http listener %d on port %d", this.id, this.httpServer.actualPort()), event.cause());
            }
        });
    }

    public void register(Vertx vertx, Environment environment, VertxConfig config) throws Exception {
        if (Registrar.counter.incrementAndGet() == 1L) {
            for (Registrar registrar : Plugin.REGISTRAR.extensions()) {
                registrar.register(vertx, environment, config);
            }
            Registrar.latch.countDown();
        } else {
            Registrar.latch.await();
        }
    }

    public void deregister(Vertx vertx) {
        if (Registrar.counter.decrementAndGet() == 0L) {
            Plugin.REGISTRAR.reverse().forEach(o -> o.deregister(vertx));
        }
    }

    protected Router createRouter(Environment environment) {
        return new MyRouter(this.vertx, environment);
    }

    public void stop() {
        if (this.httpServer != null) {
            this.httpServer.close(event -> {
                if (event.succeeded()) {
                    logger.info((Object)String.format("success removing http listener %d on port %d", this.id, this.httpServer.actualPort()));
                } else {
                    logger.error((Object)String.format("failed removing http listener %d on port %d", this.id, this.httpServer.actualPort()), event.cause());
                }
            });
        }
        if (this.consumer != null) {
            this.consumer.unregister((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> event) {
                    if (event.succeeded()) {
                        logger.info((Object)String.format("success unregistering consumer %d of %s", RoutingVerticle.this.id, "system_routes"));
                    } else {
                        logger.error((Object)String.format("failed unregistering consumer %d of %s", RoutingVerticle.this.id, "system_routes"));
                    }
                }
            });
        }
        this.deregister(this.vertx);
        logger.info((Object)String.format("success stop routing verticle %d at %s ", this.id, this.deploymentID()));
    }

    protected void addRoutes(Router router, List<RouteConfig> routes, Environment environment) {
        if (routes != null) {
            for (RouteConfig info : routes) {
                this.addRoute(info, router, environment);
            }
        }
    }

    protected void addRoute(RouteConfig config, Router router, Environment environment) {
        if (config.isRoute()) {
            return;
        }
        Route route = this.getRoute(config, router);
        if (route == null) {
            return;
        }
        if (config.getOrder() != null) {
            route.order(config.getOrder().intValue());
        }
        if (route instanceof MyRoute) {
            ((MyRoute)route).setConfig(config);
        }
        this.buildProduces(route, config);
        this.buildConsumes(route, config);
        this.buildErrors(route, config);
        this.buildHandlers(route, config, environment);
    }

    protected Route getRoute(RouteConfig config, Router router) {
        if (config == null || router == null) {
            return null;
        }
        RouteType type = config.getType();
        String path = config.getPath();
        String string = path = path != null ? path.trim() : path;
        Route route = path == null || path.isEmpty() ? router.route() : (!config.isRegex() ? (type == null ? router.route(path) : router.route(type.getMethod(), path)) : (type == null ? router.routeWithRegex(path) : router.routeWithRegex(type.getMethod(), path)));
        return route;
    }

    protected void addRoute(RouteConfig config) {
        this.addRoute(config, this.router, this.env);
    }

    protected void removeRoute(RouteConfig config) {
        Route route = this.getRoute(config, this.router);
        if (route != null) {
            route.remove();
        }
    }

    protected void buildErrors(Route route, RouteConfig config) {
        if (config.getErrors() != null) {
            for (String error : config.getErrors()) {
                ErrorHandler handler = (ErrorHandler)Plugin.ERROR.get((Object)error);
                if (handler != null) {
                    route.failureHandler((Handler)handler);
                    continue;
                }
                logger.warn((Object)String.format("error handler %s is not found. ignore.", error));
            }
        }
    }

    protected void buildHandlers(Route route, RouteConfig config, Environment environment) {
        for (String name : config.getHandlers()) {
            HandlerName handlerName = new HandlerName(name);
            Object handler = (Handler<RoutingContext>)Plugin.ROUTING.get((Object)handlerName.getHandler());
            if (handler == null) {
                handler = this.buildCommand(handlerName, environment);
            }
            if (handler != null) {
                if (handler instanceof RouteAware) {
                    handler = ((RouteAware)handler).clone();
                    ((RouteAware)handler).setup(config);
                }
                if (handler instanceof Blocking) {
                    route.blockingHandler(handler);
                    continue;
                }
                route.handler(handler);
                continue;
            }
            logger.warn((Object)String.format("handler %s is not found. ignore.", name));
        }
    }

    protected Handler<RoutingContext> buildCommand(HandlerName name, Environment environment) {
        ExtensionMeta meta = Plugin.COMMAND.meta((Object)name.getHandler());
        if (meta == null) {
            return null;
        }
        Pool<Command> pool = null;
        Class clazz = meta.getExtension().getClazz();
        if (Poolable.class.isAssignableFrom(clazz)) {
            int capacity = environment.getInteger("command.pool.capacity", 500);
            int initializeSize = environment.getInteger("command.pool.initialize.size", 50);
            if (capacity > 0) {
                pool = ((PoolFactory)Plugin.POOL.get()).create(capacity);
                if (initializeSize > 0) {
                    int min = Math.min(initializeSize, capacity);
                    for (int i = 0; i < min; ++i) {
                        Command command = (Command)meta.getTarget();
                        if (command == null) continue;
                        pool.release(command);
                    }
                }
            }
        } else {
            pool = null;
        }
        if (name.getPath() != null && !name.getPath().isEmpty()) {
            Method method = this.getCandidate(clazz, name.getPath());
            if (method == null) {
                logger.error((Object)String.format("In this class %s, there is no way to match the path %s.", clazz, name.getPath()));
                return null;
            }
            name.setMethod(method);
            return new CommandHandler((ExtensionMeta<Command, String>)meta, pool, name);
        }
        return new CommandHandler((ExtensionMeta<Command, String>)meta, pool, name);
    }

    protected Method getCandidate(Class clazz, String pathName) {
        LinkedList queue = new LinkedList();
        queue.push(clazz);
        Method best = null;
        int priority = 0;
        while (!queue.isEmpty()) {
            Class cls = (Class)queue.pop();
            for (Method method : cls.getDeclaredMethods()) {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                Path path = method.getAnnotation(Path.class);
                int match = 0;
                if (path != null && path.value().equals(pathName)) {
                    match = 2;
                } else if (method.getName().equals(pathName)) {
                    match = 1;
                }
                if (match <= 0 || match <= priority && (match != priority || !Modifier.isVolatile(best.getModifiers()) || Modifier.isVolatile(method.getModifiers()))) continue;
                best = method;
                priority = match;
            }
            if (best != null || (cls = cls.getSuperclass()) == Object.class) break;
            queue.push(cls);
        }
        return best;
    }

    protected void buildConsumes(Route route, RouteConfig config) {
        switch (config.getType()) {
            case PUT: 
            case POST: 
            case PATCH: {
                if (config.getConsumes() == null) break;
                for (String type : config.getConsumes()) {
                    route.consumes(type);
                }
                break;
            }
        }
    }

    protected void buildProduces(Route route, RouteConfig config) {
        if (config.getProduces() != null) {
            for (String type : config.getProduces()) {
                route.produces(type);
            }
        }
    }

    protected static class HandlerName {
        protected String handler;
        protected String path;
        public Method method;

        public HandlerName(String handler) {
            int pos = handler.indexOf(35);
            if (pos > 0) {
                this.handler = handler.substring(0, pos);
                this.path = handler.substring(pos + 1);
            } else {
                this.handler = handler;
            }
        }

        public String getHandler() {
            return this.handler;
        }

        public String getPath() {
            return this.path;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }
    }

    protected static class CommandHandler
    implements Handler<RoutingContext> {
        protected ExtensionMeta<Command, String> meta;
        protected Pool<Command> pool;
        protected HandlerName handlerName;

        public CommandHandler(ExtensionMeta<Command, String> meta, Pool<Command> pool, HandlerName handlerName) {
            this.meta = meta;
            this.pool = pool;
            this.handlerName = handlerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(RoutingContext context) {
            Command clone = null;
            try {
                Command command = clone = this.pool == null ? null : this.pool.get();
                if (clone == null) {
                    clone = (Command)this.meta.getTarget();
                }
                Binding.bind((Object)context, (Object)clone);
                Validates.validate(clone);
                Object obj = this.handlerName.method != null ? this.handlerName.method.invoke((Object)clone, this.getArgs(clone, this.handlerName.method, context)) : clone.execute();
                Command.Result result = null;
                if (obj != null) {
                    result = obj instanceof Command.Result ? (Command.Result)obj : new Command.Result(obj);
                }
                if (result != null) {
                    if (result.getTemplate() != null && !result.getTemplate().isEmpty()) {
                        context.put("template", (Object)result.getTemplate());
                    }
                    if (result.getKey() != null) {
                        context.put(result.getKey(), result.getResult());
                    }
                    switch (result.getType()) {
                        case CONTINUE: {
                            context.next();
                            break;
                        }
                        case END: {
                            RenderHandler.render(context, true);
                            break;
                        }
                        case HOLD: {
                            break;
                        }
                        default: {
                            context.next();
                            break;
                        }
                    }
                } else {
                    context.next();
                }
            }
            catch (InvocationTargetException invocationException) {
                context.fail(invocationException.getTargetException());
            }
            catch (Exception e) {
                context.fail((Throwable)e);
            }
            finally {
                if (this.pool != null && clone != null) {
                    this.pool.release(clone);
                }
            }
        }

        protected Object[] getArgs(Object target, Method method, RoutingContext context) throws ReflectionException {
            return Binding.bind((Object)context, (Object)target, (Method)method, (PropertySupplier)new PropertySupplier.AbstractSupplier(){

                public Object get(Object target, String name) {
                    return ((RoutingContext)target).get(name);
                }
            });
        }
    }
}

