/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.binder;

import com.jd.laf.binding.Plugin;
import com.jd.laf.binding.binder.Binder;
import com.jd.laf.binding.converter.Scope;
import com.jd.laf.binding.marshaller.JsonProvider;
import com.jd.laf.binding.marshaller.TypeReference;
import com.jd.laf.binding.marshaller.XmlProvider;
import com.jd.laf.binding.reflect.exception.ReflectionException;
import com.jd.laf.web.vertx.annotation.Body;
import io.vertx.ext.web.RoutingContext;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Properties;

public class BodyBinder
implements Binder {
    public boolean bind(Binder.Context context) throws ReflectionException {
        Body annotation = (Body)context.getAnnotation();
        Object source = context.getSource();
        if (!(source instanceof RoutingContext)) {
            return false;
        }
        RoutingContext ctx = (RoutingContext)source;
        Body.BodyType type = annotation.type();
        if (type == Body.BodyType.DETECT) {
            String contentType = ctx.getAcceptableContentType();
            type = contentType != null ? ((contentType = contentType.toLowerCase()).indexOf("json") >= 0 ? Body.BodyType.JSON : (contentType.indexOf("xml") >= 0 ? Body.BodyType.XML : (contentType.indexOf("properties") >= 0 ? Body.BodyType.PROPERTIES : Body.BodyType.TEXT))) : Body.BodyType.JSON;
        }
        try {
            switch (type) {
                case JSON: {
                    Scope scope = context.getScope();
                    Class genericType = scope.getGenericType();
                    if (genericType == null) {
                        return context.bind(((JsonProvider)Plugin.JSON.get()).getUnmarshaller().unmarshall(ctx.getBodyAsString(), context.getType()));
                    }
                    return context.bind(((JsonProvider)Plugin.JSON.get()).getUnmarshaller().unmarshall(ctx.getBodyAsString(), new TypeReference(scope.getType(), new Type[]{scope.getGenericType()}){}));
                }
                case XML: {
                    return context.bind(((XmlProvider)Plugin.XML.get()).getUnmarshaller().unmarshall(ctx.getBodyAsString(), context.getType()));
                }
                case PROPERTIES: {
                    Properties properties = new Properties();
                    properties.load(new StringReader(ctx.getBody().toString()));
                    return context.bind((Object)properties);
                }
            }
            return context.bind((Object)ctx.getBody());
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReflectionException(e.getMessage(), (Throwable)e);
        }
    }

    public Class<?> annotation() {
        return Body.class;
    }
}

