/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.config;

import com.jd.laf.web.vertx.config.HandlerConfig;
import com.jd.laf.web.vertx.config.ListXmlAdapter;
import com.jd.laf.web.vertx.config.RouteType;
import com.jd.laf.web.vertx.config.SetXmlAdapter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(name="route")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RouteConfig
extends HandlerConfig {
    public static final String PLACE_HOLDER = "{}";
    @XmlAttribute
    private String name;
    @XmlAttribute
    private boolean route;
    @XmlAttribute
    private boolean regex;
    @XmlAttribute
    private String inherit;
    @XmlAttribute
    private String template;
    @XmlAttribute
    private RouteType type;
    @XmlAttribute
    private Long timeout;
    @XmlAttribute
    private Integer order;
    private Set<String> consumes;
    private Set<String> produces;
    private List<String> errors = new ArrayList<String>(3);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRoute() {
        return this.route;
    }

    public void setRoute(boolean route) {
        this.route = route;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public String getInherit() {
        return this.inherit;
    }

    public void setInherit(String inherit) {
        this.inherit = inherit;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public RouteType getType() {
        return this.type;
    }

    public void setType(RouteType type) {
        this.type = type;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=SetXmlAdapter.class)
    public Set<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=SetXmlAdapter.class)
    public Set<String> getProduces() {
        return this.produces;
    }

    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=ListXmlAdapter.class)
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public void addError(String error) {
        if (error != null && !error.isEmpty()) {
            this.errors.add(error);
        }
    }

    public void inherit(RouteConfig parent) {
        if (parent == null) {
            return;
        }
        if (this.type == null && parent.type != null) {
            this.type = parent.type;
        }
        if ((this.consumes == null || this.consumes.isEmpty()) && parent.consumes != null && !parent.consumes.isEmpty()) {
            this.consumes = parent.consumes;
        }
        if ((this.produces == null || this.produces.isEmpty()) && parent.produces != null && !parent.produces.isEmpty()) {
            this.produces = parent.produces;
        }
        this.handlers = this.merge(parent.handlers, this.handlers);
        this.errors = this.merge(parent.errors, this.errors);
    }

    protected List<String> merge(List<String> parent, List<String> child) {
        List<String> result = child;
        if (parent != null && !parent.isEmpty()) {
            result = new LinkedList<String>();
            boolean flag = false;
            for (String handler : parent) {
                if (!PLACE_HOLDER.equals(handler)) {
                    result.add(handler);
                    continue;
                }
                if (flag) continue;
                flag = true;
                if (child == null) continue;
                result.addAll(child);
            }
            if (!flag && child != null) {
                result.addAll(child);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RouteConfig{");
        sb.append("path='").append(this.path).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", route=").append(this.route);
        sb.append(", regex=").append(this.regex);
        sb.append(", inherit='").append(this.inherit).append('\'');
        sb.append(", template='").append(this.template).append('\'');
        sb.append(", type=").append((Object)this.type);
        sb.append(", timeout=").append(this.timeout);
        sb.append(", order=").append(this.order);
        sb.append(", consumes=").append(this.consumes);
        sb.append(", produces=").append(this.produces);
        sb.append(", errors=").append(this.errors);
        sb.append(", handlers=").append(this.handlers);
        sb.append('}');
        return sb.toString();
    }
}

