/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.config;

import com.jd.laf.web.vertx.config.MessageConfig;
import com.jd.laf.web.vertx.config.RouteConfig;
import com.jd.laf.web.vertx.config.RouteType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="vertx")
@XmlAccessorType(value=XmlAccessType.NONE)
public class VertxConfig {
    @XmlElementWrapper
    @XmlElement(name="route")
    List<RouteConfig> routes = new ArrayList<RouteConfig>(50);
    @XmlElementWrapper
    @XmlElement(name="message")
    List<MessageConfig> messages = new ArrayList<MessageConfig>(10);
    @XmlAttribute
    String connection;
    @XmlAttribute
    String exception;

    public List<RouteConfig> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteConfig> routes) {
        this.routes = routes;
    }

    public List<MessageConfig> getMessages() {
        return this.messages;
    }

    public void setMessages(List<MessageConfig> messages) {
        this.messages = messages;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public void add(RouteConfig config) {
        if (config != null) {
            this.routes.add(config);
        }
    }

    public void add(MessageConfig config) {
        if (config != null) {
            this.messages.add(config);
        }
    }

    public static class Builder {
        public static VertxConfig build(Reader reader) throws JAXBException {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RouteConfig.class, RouteType.class, VertxConfig.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (VertxConfig)unmarshaller.unmarshal(reader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static VertxConfig build(String file) throws IOException, JAXBException {
            if (file == null || file.isEmpty()) {
                throw new IllegalStateException("file can not be empty.");
            }
            try (BufferedReader reader = null;){
                InputStream in;
                File f = new File(file);
                if (f.exists()) {
                    in = new FileInputStream(f);
                } else {
                    in = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
                    if (in == null && (in = VertxConfig.class.getClassLoader().getResourceAsStream(file)) == null) {
                        throw new IOException("file is not found. " + file);
                    }
                }
                reader = new BufferedReader(new InputStreamReader(in));
                VertxConfig vertxConfig = Builder.build(reader);
                return vertxConfig;
            }
        }

        public static VertxConfig inherit(VertxConfig config) {
            if (config == null) {
                return null;
            }
            List<RouteConfig> routes = config.getRoutes();
            if (routes == null || routes.isEmpty()) {
                return config;
            }
            LinkedList inherits = config.getRoutes().stream().filter(a -> !a.isRoute() && a.getInherit() != null && !a.getInherit().isEmpty()).collect(Collectors.toCollection(LinkedList::new));
            if (inherits == null || inherits.isEmpty()) {
                return config;
            }
            Map<String, RouteConfig> map = config.getRoutes().stream().filter(a -> a.getName() != null).collect(Collectors.toMap(a -> a.getName(), a -> a));
            HashSet<RouteConfig> graph = new HashSet<RouteConfig>(map.size());
            for (RouteConfig cfg : inherits) {
                RouteConfig parent = map.get(cfg.getInherit());
                graph.clear();
                graph.add(cfg);
                while (parent != null && graph.add(parent)) {
                    cfg.inherit(parent);
                    parent = parent.getInherit() == null || parent.getInherit().isEmpty() ? null : map.get(parent.getInherit());
                }
            }
            return config;
        }
    }
}

