/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.handler;

import com.jd.laf.web.vertx.ErrorHandler;
import com.jd.laf.web.vertx.handler.RenderHandler;
import com.jd.laf.web.vertx.response.ErrorResponse;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;

public class ExceptionHandler
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);

    public String type() {
        return "error";
    }

    public void handle(RoutingContext context) {
        Throwable throwable = context.failure();
        Response response = Responses.error(throwable);
        context.put("result", (Object)response);
        if (response != null) {
            if (throwable != null && response instanceof ErrorResponse && ((ErrorResponse)response).isTrace()) {
                logger.error((Object)(context.request().path() + ": " + response.getMessage()), throwable);
            } else {
                logger.error((Object)(context.request().path() + ": " + response.getMessage()));
            }
        } else if (throwable != null) {
            logger.error((Object)(context.request().path() + ": " + throwable.getMessage()), throwable);
        } else {
            logger.error((Object)(context.request().path() + ": unknown error."));
        }
        RenderHandler.render(context, false);
    }
}

