/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.handler;

import com.jd.laf.web.vertx.RoutingHandler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;

public class RemoteIpHandler
implements RoutingHandler {
    public String type() {
        return "ip";
    }

    public void handle(RoutingContext context) {
        context.put("remoteIp", (Object)RemoteIpHandler.getRemoteIP(context.request()));
        context.next();
    }

    public static String getRemoteIP(HttpServerRequest request) {
        int pos;
        String ip = request.getHeader("J-Forwarded-For");
        if (ip != null && !ip.isEmpty() && !"unknown".equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.remoteAddress().host();
        }
        if (ip != null && (pos = ip.indexOf(44)) > 0) {
            ip = ip.substring(0, pos);
        }
        return ip;
    }
}

