/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.handler;

import com.jd.laf.web.vertx.Plugin;
import com.jd.laf.web.vertx.RoutingHandler;
import com.jd.laf.web.vertx.handler.ExceptionHandler;
import com.jd.laf.web.vertx.render.Render;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;

public class RenderHandler
implements RoutingHandler {
    public static final String RENDER_TYPE = "render";
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);

    public String type() {
        return RENDER_TYPE;
    }

    public void handle(RoutingContext context) {
        RenderHandler.render(context, true);
    }

    public static void render(RoutingContext context, boolean failOnException) {
        Render render;
        if (context == null || context.response().ended()) {
            return;
        }
        String contentType = context.getAcceptableContentType();
        if (contentType == null || contentType.isEmpty()) {
            contentType = context.request().getHeader(HttpHeaders.CONTENT_TYPE);
        }
        if ((render = (Render)Plugin.RENDER.get((Object)(contentType = contentType == null || contentType.isEmpty() ? "application/json" : contentType.toLowerCase()))) == null) {
            render = (Render)Plugin.RENDER.get((Object)"application/json");
        }
        try {
            render.render(context);
        }
        catch (Exception e) {
            if (failOnException) {
                context.fail((Throwable)e);
            }
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

