/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.handler;

import com.jd.laf.web.vertx.Environment;
import com.jd.laf.web.vertx.EnvironmentAware;
import com.jd.laf.web.vertx.RoutingHandler;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.sstore.ClusteredSessionStore;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;

public class SessionHandler
implements RoutingHandler,
EnvironmentAware {
    public static final String DEFAULT_SESSION_NAME = "vertx-web.sessions";
    protected Handler<RoutingContext> handler;

    public String type() {
        return "session";
    }

    @Override
    public void setup(Vertx vertx, Environment environment) {
        boolean localSession = environment.getBoolean("session.local", true);
        String sessionName = environment.getString("session.name", DEFAULT_SESSION_NAME);
        String sessionCookieName = environment.getString("session.cookie.name", "vertx-web.session");
        long sessionTimeout = environment.getPositive("session.timeout", 1800000L);
        LocalSessionStore store = localSession ? LocalSessionStore.create((Vertx)vertx, (String)sessionName) : ClusteredSessionStore.create((Vertx)vertx, (String)sessionName);
        this.handler = io.vertx.ext.web.handler.SessionHandler.create((SessionStore)store).setSessionCookieName(sessionCookieName).setSessionTimeout(sessionTimeout);
    }

    public void handle(RoutingContext context) {
        this.handler.handle((Object)context);
    }
}

