/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.handler;

import com.jd.laf.web.vertx.Environment;
import com.jd.laf.web.vertx.EnvironmentAware;
import com.jd.laf.web.vertx.Plugin;
import com.jd.laf.web.vertx.RoutingHandler;
import com.jd.laf.web.vertx.TemplateProvider;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.common.template.TemplateEngine;

public class TemplateHandler
implements RoutingHandler,
EnvironmentAware {
    protected Handler<RoutingContext> handler;

    public String type() {
        return "template";
    }

    @Override
    public void setup(Vertx vertx, Environment environment) throws Exception {
        TemplateEngine engine = environment.getObject("template.engine", TemplateEngine.class);
        if (engine == null) {
            String type = environment.getString("template.type", "beetl");
            TemplateProvider provider = (TemplateProvider)Plugin.TEMPLATE.get((Object)type);
            if (provider != null) {
                engine = provider.create(vertx, environment);
                environment.put("template.engine", engine);
            } else {
                throw new IllegalStateException("template engine is not found. " + type);
            }
        }
        String templateDirectory = environment.getString("template.directory", "templates");
        String contentType = environment.getString("template.contentType", "text/html");
        this.handler = io.vertx.ext.web.handler.TemplateHandler.create((TemplateEngine)engine, (String)templateDirectory, (String)contentType);
    }

    public void handle(RoutingContext context) {
        this.handler.handle((Object)context);
    }
}

