/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.lifecycle;

import com.jd.laf.web.vertx.Environment;
import com.jd.laf.web.vertx.EnvironmentAware;
import com.jd.laf.web.vertx.MessageHandler;
import com.jd.laf.web.vertx.Plugin;
import com.jd.laf.web.vertx.config.VertxConfig;
import com.jd.laf.web.vertx.lifecycle.Registrar;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

public class MessageRegistrar
implements Registrar {
    protected static final Logger logger = LoggerFactory.getLogger(MessageRegistrar.class);
    protected List<Consumer> consumers = new ArrayList<Consumer>(20);

    @Override
    public void register(Vertx vertx, Environment environment, VertxConfig config) throws Exception {
        EnvironmentAware.setup(vertx, environment, Plugin.MESSAGE.extensions());
        EnvironmentAware.setup(vertx, environment, Plugin.CODEC.extensions());
        EventBus eventBus = vertx.eventBus();
        Plugin.CODEC.extensions().forEach(o -> eventBus.registerDefaultCodec((Class)o.type(), (MessageCodec)o));
        config.getMessages().forEach(route -> route.getHandlers().forEach(name -> {
            MessageHandler handler = (MessageHandler)Plugin.MESSAGE.get(name);
            if (handler != null && route.getPath() != null && !route.getPath().isEmpty()) {
                MessageConsumer consumer = eventBus.consumer(route.getPath(), (Handler)handler);
                if (route.getBufferSize() != null && route.getBufferSize() > 0) {
                    consumer.setMaxBufferedMessages(route.getBufferSize().intValue());
                }
                this.consumers.add(new Consumer(route.getPath(), (String)name, consumer));
            }
        }));
        VertxInternal internal = (VertxInternal)vertx;
        internal.addCloseHook(completionHandler -> {
            for (int i = this.consumers.size() - 1; i >= 0; --i) {
                final Consumer consumer = this.consumers.get(i);
                consumer.getConsumer().unregister((Handler)new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> event) {
                        if (event.succeeded()) {
                            logger.info((Object)String.format("success unregistering consumer %s of %s", consumer.getHandler(), consumer.getPath()));
                        } else {
                            logger.info((Object)String.format("failed unregistering consumer %s of %s", consumer.getHandler(), consumer.getPath()));
                        }
                    }
                });
            }
            Plugin.CODEC.extensions().forEach(o -> vertx.eventBus().unregisterDefaultCodec((Class)o.type()));
            this.consumers.clear();
            completionHandler.handle((Object)Future.succeededFuture());
        });
    }

    @Override
    public int order() {
        return 32766;
    }

    protected static class Consumer {
        protected String path;
        protected String handler;
        protected MessageConsumer consumer;

        public Consumer(String path, String handler, MessageConsumer consumer) {
            this.path = path;
            this.handler = handler;
            this.consumer = consumer;
        }

        public String getPath() {
            return this.path;
        }

        public String getHandler() {
            return this.handler;
        }

        public MessageConsumer getConsumer() {
            return this.consumer;
        }
    }
}

