/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.marshaller;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.jd.laf.binding.marshaller.JsonProvider;
import com.jd.laf.binding.marshaller.Marshaller;
import com.jd.laf.binding.marshaller.TypeReference;
import com.jd.laf.binding.marshaller.Unmarshaller;
import io.vertx.core.json.Json;

public class JacksonProvider
implements JsonProvider {
    public Unmarshaller getUnmarshaller() {
        return JacksonUnmarshaller.INSTANCE;
    }

    public Marshaller getMarshaller() {
        return JacksonMarshaller.INSTANCE;
    }

    static {
        Json.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    protected static class JacksonMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new JacksonMarshaller();

        protected JacksonMarshaller() {
        }

        public String marshall(Object target) {
            if (target == null) {
                return null;
            }
            return Json.encode((Object)target);
        }
    }

    protected static class JacksonUnmarshaller
    implements Unmarshaller {
        public static final Unmarshaller INSTANCE = new JacksonUnmarshaller();

        protected JacksonUnmarshaller() {
        }

        public <T> T unmarshall(String value, Class<T> clazz, String format) {
            return (T)Json.decodeValue((String)value, clazz);
        }

        public <T> T unmarshall(String value, Class<T> clazz) {
            return (T)Json.decodeValue((String)value, clazz);
        }

        public <T> T unmarshall(String value, TypeReference<T> reference, String format) throws Exception {
            return (T)Json.mapper.readValue(value, Json.mapper.getTypeFactory().constructType(reference.getType()));
        }

        public <T> T unmarshall(String value, TypeReference<T> reference) throws Exception {
            return (T)Json.mapper.readValue(value, Json.mapper.getTypeFactory().constructType(reference.getType()));
        }
    }
}

