/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.message;

import com.jd.laf.binding.Plugin;
import com.jd.laf.binding.marshaller.JsonProvider;
import com.jd.laf.web.vertx.message.CustomCodec;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import java.nio.charset.StandardCharsets;

public class JsonMessageCodec<T>
implements CustomCodec<T> {
    protected Class<T> type;

    public JsonMessageCodec(Class<T> type) {
        this.type = type;
    }

    public void encodeToWire(Buffer buffer, T message) {
        if (message == null) {
            return;
        }
        try {
            String value = ((JsonProvider)Plugin.JSON.get()).getMarshaller().marshall(message);
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            buffer.appendInt(length);
            buffer.appendBytes(bytes);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public T decodeFromWire(int position, Buffer buffer) {
        int length = buffer.getInt(position);
        int start = position + 4;
        String value = buffer.getString(start, start + length);
        try {
            return (T)((JsonProvider)Plugin.JSON.get()).getUnmarshaller().unmarshall(value, this.type, null);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode: " + e.getMessage(), (Throwable)e);
        }
    }

    public T transform(T message) {
        return message;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }
}

