/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.parameter;

import com.jd.laf.web.vertx.parameter.ParameterSupplier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;

public final class Parameter {
    protected final ParameterSupplier supplier;

    public Parameter(ParameterSupplier supplier) {
        this.supplier = supplier;
    }

    public static Parameter valueOf(ParameterSupplier supplier) {
        return new Parameter(supplier);
    }

    public String getString(String key) {
        return this.supplier == null ? null : this.supplier.get(key);
    }

    public String[] getStrings(String key, char delimiter) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        int len = value.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (value.charAt(i) != delimiter) continue;
            if (i > start) {
                result.add(value.substring(start, i));
            }
            start = i + 1;
        }
        if (start < len) {
            result.add(value.substring(start, len));
        }
        return result.toArray(new String[result.size()]);
    }

    public String getString(String key, String def) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return def;
        }
        return value;
    }

    public Date getDate(String key, Date def) {
        Long value = this.getLong(key, null);
        if (value == null) {
            return def;
        }
        return new Date(value);
    }

    public Date getDate(String key, SimpleDateFormat format) {
        return this.getDate(key, format, null);
    }

    public Date getDate(String key, SimpleDateFormat format, Date def) {
        String value = this.getString(key);
        if (value == null || value.isEmpty() || format == null) {
            return def;
        }
        try {
            return format.parse(key);
        }
        catch (ParseException e) {
            return def;
        }
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Float getFloat(String key, Float def) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return def;
        }
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Double getDouble(String key, Double def) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return def;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long def) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer def) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Short getShort(String key) {
        return this.getShort(key, null);
    }

    public Short getShort(String key, Short def) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return def;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Byte getByte(String key) {
        return this.getByte(key, null);
    }

    public Byte getByte(String key, Byte def) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return def;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean def) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return def;
        }
        if ("true".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        try {
            return Integer.parseInt(value) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public Long getNatural(String key, Long def) {
        Long value = this.getLong(key, def);
        if (value != null && value < 0L) {
            return def;
        }
        return value;
    }

    public Integer getNatural(String key, Integer def) {
        Integer value = this.getInteger(key, def);
        if (value != null && value < 0) {
            return def;
        }
        return value;
    }

    public Short getNatural(String key, Short def) {
        Short value = this.getShort(key, def);
        if (value != null && value < 0) {
            return def;
        }
        return value;
    }

    public Byte getNatural(String key, Byte def) {
        Byte value = this.getByte(key, def);
        if (value != null && value < 0) {
            return def;
        }
        return value;
    }

    public Long getPositive(String key, Long def) {
        Long value = this.getLong(key, def);
        if (value != null && value <= 0L) {
            return def;
        }
        return value;
    }

    public Integer getPositive(String key, Integer def) {
        Integer value = this.getInteger(key, def);
        if (value != null && value <= 0) {
            return def;
        }
        return value;
    }

    public Short getPositive(String key, Short def) {
        Short value = this.getShort(key, def);
        if (value != null && value <= 0) {
            return def;
        }
        return value;
    }

    public Byte getPositive(String key, Byte def) {
        Byte value = this.getByte(key, def);
        if (value != null && value <= 0) {
            return def;
        }
        return value;
    }

    public boolean contains(String key) {
        String value = this.getString(key);
        return value != null && !value.isEmpty();
    }
}

