/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.render;

import com.jd.laf.web.vertx.Environment;
import com.jd.laf.web.vertx.EnvironmentAware;
import com.jd.laf.web.vertx.render.Render;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.common.template.TemplateEngine;
import java.io.File;
import java.io.FileNotFoundException;

public class TemplateRender
implements Render,
EnvironmentAware {
    protected TemplateEngine engine;
    protected String templateDirectory;

    @Override
    public void render(RoutingContext context) throws Exception {
        String template = (String)context.get("template");
        if (template == null || template.isEmpty()) {
            context.fail((Throwable)new FileNotFoundException("template is not found."));
        } else if (this.engine == null) {
            context.fail((Throwable)new IllegalStateException("template engine is not found."));
        } else {
            context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
            this.engine.render(context.data(), this.templateDirectory + template, rs -> {
                if (rs.succeeded()) {
                    context.response().end((Buffer)rs.result());
                } else {
                    Throwable e = rs.cause();
                    if (e instanceof FileSystemException) {
                        context.fail(e.getCause() != null ? e.getCause() : e);
                    } else {
                        context.fail(rs.cause());
                    }
                }
            });
        }
    }

    @Override
    public void setup(Vertx vertx, Environment environment) {
        this.engine = environment.getObject("template.engine", TemplateEngine.class);
        this.templateDirectory = environment.getString("template.directory", "templates");
        if (!this.templateDirectory.endsWith(File.separator)) {
            this.templateDirectory = this.templateDirectory + File.separator;
        }
    }

    public String type() {
        return "text/html";
    }
}

