/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.response;

import com.jd.laf.web.vertx.Plugin;
import com.jd.laf.web.vertx.response.ErrorResponse;
import com.jd.laf.web.vertx.response.ErrorSupplier;
import com.jd.laf.web.vertx.response.Response;
import java.util.List;

public abstract class Responses {
    public static Response success() {
        return new Response();
    }

    public static Response success(Object data) {
        return new Response(data);
    }

    public static Response success(int code, Object data) {
        return new Response(code, data);
    }

    public static Response success(int code, int status, Object data) {
        return new Response(code, status, data, null);
    }

    public static Response success(Object pagination, List<?> data) {
        return new Response(data, pagination);
    }

    public static Response success(int code, Object pagination, List<?> data) {
        return new Response(code, data, pagination);
    }

    public static Response success(int code, int status, Object pagination, List<?> data) {
        return new Response(code, status, data, pagination);
    }

    public static Response error(int code, String message) {
        return new Response(code, message);
    }

    public static Response error(int code, int status, String message) {
        return new Response(code, status, message);
    }

    public static Response error(Throwable throwable) {
        return Responses.error(throwable, null, 500, 500);
    }

    public static Response error(Throwable throwable, ErrorSupplier supplier) {
        return Responses.error(throwable, supplier, 500, 500);
    }

    public static Response error(Throwable throwable, ErrorSupplier supplier, int defaultCode, int defaultStatus) {
        if (throwable == null) {
            return Responses.error(defaultCode, defaultStatus, "unknown error.");
        }
        if (supplier != null) {
            return supplier.error(throwable);
        }
        supplier = (ErrorSupplier)Plugin.THROWABLE.select(throwable.getClass());
        if (supplier != null) {
            return supplier.error(throwable);
        }
        return new ErrorResponse(defaultCode, defaultStatus, throwable.getMessage(), true);
    }
}

