/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.web.vertx.service;

import com.jd.laf.web.vertx.Environment;
import com.jd.laf.web.vertx.service.Daemon;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class MessageDaemon<T>
implements Daemon {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int queueSize = 1000;
    protected long pollTimeout = 5000L;
    protected long checkInterval;
    protected String queueSizeKey = "message.queue.size";
    protected String pollTimeoutKey = "message.poll.timeout";
    protected String daemonKey;
    protected String threadName = this.getClass().getSimpleName();
    protected String daemonName = this.getClass().getSimpleName();
    protected BlockingQueue<T> events;
    protected Thread thread;
    protected AtomicBoolean started = new AtomicBoolean(false);

    @Override
    public synchronized void start(Environment context) throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.queueSize = context.getPositive(this.queueSizeKey, this.queueSize);
            this.pollTimeout = context.getPositive(this.pollTimeoutKey, this.pollTimeout);
            this.events = new LinkedBlockingQueue<T>(this.queueSize);
            this.doStart(context);
            this.thread = new Thread((Runnable)new TaskConsumer(this.events, this.pollTimeout, this.checkInterval), this.threadName);
            this.thread.setDaemon(true);
            this.thread.start();
            if (this.daemonKey != null && !this.daemonKey.isEmpty()) {
                context.put(this.daemonKey, this);
            }
            this.logger.info((Object)(this.daemonName + " is started!"));
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started.compareAndSet(true, false)) {
            T message;
            if (this.events != null && (message = this.stopMessage()) != null) {
                this.events.add(message);
            }
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
            this.doStop();
            this.logger.info((Object)(this.daemonName + " is stopped."));
        }
    }

    protected void doStart(Environment context) throws Exception {
    }

    protected void doStop() {
    }

    public void addMessage(T message) {
        if (message == null) {
            return;
        }
        try {
            this.events.add(message);
        }
        catch (IllegalStateException e) {
            this.logger.error((Object)e);
        }
    }

    public void putMessage(T message) {
        if (message == null) {
            return;
        }
        try {
            this.events.put(message);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    protected T stopMessage() {
        return null;
    }

    protected abstract void onMessage(T var1);

    protected void onEmpty() {
    }

    protected void onCheck() {
    }

    protected class TaskConsumer
    implements Runnable {
        protected BlockingQueue<T> events;
        protected long pollTimeout;
        protected long checkInterval;

        public TaskConsumer(BlockingQueue<T> events, long pollTimeout, long checkInterval) {
            this.events = events;
            this.pollTimeout = pollTimeout;
            this.checkInterval = checkInterval;
        }

        @Override
        public void run() {
            long last = System.currentTimeMillis();
            while (MessageDaemon.this.isStarted()) {
                try {
                    long now;
                    Object message = this.events.poll(this.pollTimeout, TimeUnit.MILLISECONDS);
                    if (!MessageDaemon.this.isStarted()) {
                        return;
                    }
                    if (message != null) {
                        MessageDaemon.this.onMessage(message);
                    } else {
                        MessageDaemon.this.onEmpty();
                    }
                    if (this.checkInterval <= 0L || (now = System.currentTimeMillis()) - last < this.checkInterval) continue;
                    last = now;
                    MessageDaemon.this.onCheck();
                    last = System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    MessageDaemon.this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

