/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import java.util.function.Consumer;

public final class HttpUtils {
    protected static final boolean VALIDATE_HEADER = Boolean.valueOf(System.getProperty("http.header.validate", "true"));
    static final StreamPriority DEFAULT_STREAM_PRIORITY = new StreamPriority(){

        public StreamPriority setWeight(short weight) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }

        public StreamPriority setDependency(int dependency) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }

        public StreamPriority setExclusive(boolean exclusive) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }
    };
    private static final CustomCompressor compressor = new CustomCompressor();
    private static final AsciiString TIMEOUT_EQ = AsciiString.of((CharSequence)"timeout=");
    private static final Consumer<CharSequence> HEADER_VALUE_VALIDATOR = HttpUtils::validateHeaderValue;
    private static final int HIGHEST_INVALID_VALUE_CHAR_MASK = -16;

    private HttpUtils() {
    }

    private static int indexOfSlash(CharSequence str, int start) {
        for (int i = start; i < str.length(); ++i) {
            if (str.charAt(i) != '/') continue;
            return i;
        }
        return -1;
    }

    private static boolean matches(CharSequence path, int start, String what) {
        return HttpUtils.matches(path, start, what, false);
    }

    private static boolean matches(CharSequence path, int start, String what, boolean exact) {
        if (exact && path.length() - start != what.length()) {
            return false;
        }
        if (path.length() - start >= what.length()) {
            for (int i = 0; i < what.length(); ++i) {
                if (path.charAt(start + i) == what.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String normalize(String pathname) {
        if (pathname == null) {
            return null;
        }
        if (pathname.length() == 0) {
            return "/";
        }
        StringBuilder ibuf = new StringBuilder(pathname.length() + 1);
        if (pathname.charAt(0) != '/') {
            ibuf.append('/');
        }
        ibuf.append(pathname);
        for (int i = 0; i < ibuf.length(); ++i) {
            if (ibuf.charAt(i) != '%') continue;
            HttpUtils.decodeUnreserved(ibuf, i);
        }
        return HttpUtils.removeDots(ibuf);
    }

    private static void decodeUnreserved(StringBuilder path, int start) {
        if (start + 3 <= path.length()) {
            int unescaped;
            String escapeSequence = path.substring(start + 1, start + 3);
            try {
                unescaped = Integer.parseInt(escapeSequence, 16);
                if (unescaped < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
            }
            if (unescaped >= 65 && unescaped <= 90 || unescaped >= 97 && unescaped <= 122 || unescaped >= 48 && unescaped <= 57 || unescaped == 45 || unescaped == 46 || unescaped == 95 || unescaped == 126) {
                path.setCharAt(start, (char)unescaped);
                path.delete(start + 1, start + 3);
            }
        } else {
            throw new IllegalArgumentException("Invalid position for escape character: " + start);
        }
    }

    public static String normalizePath(String pathname) {
        if (pathname == null) {
            return null;
        }
        if (pathname.isEmpty()) {
            return "/";
        }
        boolean flag = false;
        Slice root = null;
        if (pathname.charAt(0) != '/') {
            root = new Slice(-1, -1, '/', true, 1, null);
            flag = true;
        }
        int length = pathname.length();
        Slice slice = new Slice(0, -1, root);
        root = root == null ? slice : root;
        for (int i = 0; i < length; ++i) {
            char ch = pathname.charAt(i);
            boolean created = false;
            if (ch == '/') {
                if (i > 0) {
                    slice.end = i;
                    slice.partial = false;
                    flag = flag || slice.dots != -1;
                    slice = new Slice(i, -1, slice);
                }
            } else if (ch == '%' && (ch = HttpUtils.decodeUnreserved(pathname, i)) > '\u0000') {
                if (i > 0) {
                    slice.end = i;
                    slice.partial = true;
                    slice = new Slice(i, i + 3, slice);
                } else {
                    slice.end = i + 3;
                }
                slice.value = ch;
                if (slice.end < length) {
                    slice.partial = true;
                    created = true;
                }
                flag = true;
                i += 2;
            }
            if (slice.dots != -1) {
                slice.dots = ch == '/' && slice.dots == 0 || ch == '.' && (slice.dots == 1 || slice.dots == 2) ? ++slice.dots : -1;
            }
            if (!created) continue;
            slice = new Slice(slice.end, -1, slice);
        }
        if (slice != null && slice.end == -1) {
            slice.partial = false;
            slice.end = length;
            boolean bl = flag = flag || slice.dots != -1;
        }
        if (!flag) {
            return pathname;
        }
        flag = false;
        slice = root;
        while (slice != null) {
            if (!flag && slice.value > '\u0000') {
                flag = true;
            }
            if (!slice.partial) {
                switch (slice.dots) {
                    case 1: {
                        if (slice.prev == null || slice.prev.dots != 1) break;
                        slice.remove();
                        flag = true;
                        break;
                    }
                    case 2: {
                        Slice prev = slice.removePath();
                        if (prev != null) {
                            if (slice.next == null) {
                                prev.next = new Slice(-1, -1, '/');
                            }
                        } else {
                            root = slice.next;
                        }
                        flag = true;
                        break;
                    }
                    case 3: {
                        Slice prev = slice.removePath();
                        Slice slice2 = prev = prev == null ? null : prev.removePath();
                        if (prev != null) {
                            if (slice.next == null) {
                                prev.next = new Slice(-1, -1, '/');
                            }
                        } else {
                            root = slice.next;
                        }
                        flag = true;
                    }
                }
            }
            slice = slice.next;
        }
        if (!flag) {
            return pathname;
        }
        if (root == null) {
            return "/";
        }
        StringBuilder builder = new StringBuilder(length);
        while (root != null) {
            if (root.value > '\u0000') {
                builder.append(root.value);
            } else {
                builder.append(pathname, root.start, root.end);
            }
            root = root.next;
        }
        return builder.toString();
    }

    protected static char decodeUnreserved(CharSequence sequence, int start) {
        if (start + 3 <= sequence.length()) {
            int unescaped;
            CharSequence escapeSequence = sequence.subSequence(start + 1, start + 3);
            try {
                unescaped = Integer.parseInt(escapeSequence.toString(), 16);
                if (unescaped < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
            }
            if (unescaped >= 65 && unescaped <= 90 || unescaped >= 97 && unescaped <= 122 || unescaped >= 48 && unescaped <= 57 || unescaped == 45 || unescaped == 46 || unescaped == 95 || unescaped == 126) {
                return (char)unescaped;
            }
            return '\u0000';
        }
        throw new IllegalArgumentException("Invalid position for escape character: " + start);
    }

    public static String removeDots(CharSequence path) {
        if (path == null) {
            return null;
        }
        StringBuilder obuf = new StringBuilder(path.length());
        int i = 0;
        while (i < path.length()) {
            int pos;
            if (HttpUtils.matches(path, i, "./")) {
                i += 2;
                continue;
            }
            if (HttpUtils.matches(path, i, "../")) {
                i += 3;
                continue;
            }
            if (HttpUtils.matches(path, i, "/./")) {
                i += 2;
                continue;
            }
            if (HttpUtils.matches(path, i, "/.", true)) {
                path = "/";
                i = 0;
                continue;
            }
            if (HttpUtils.matches(path, i, "/../")) {
                i += 3;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path, i, "/..", true)) {
                path = "/";
                i = 0;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path, i, ".", true) || HttpUtils.matches(path, i, "..", true)) break;
            if (path.charAt(i) == '/') {
                ++i;
                if (obuf.length() == 0 || obuf.charAt(obuf.length() - 1) != '/') {
                    obuf.append('/');
                }
            }
            if ((pos = HttpUtils.indexOfSlash(path, i)) != -1) {
                obuf.append(path, i, pos);
                i = pos;
                continue;
            }
            obuf.append(path, i, path.length());
            break;
        }
        return obuf.toString();
    }

    public static URI resolveURIReference(String base, String ref) throws URISyntaxException {
        return HttpUtils.resolveURIReference(URI.create(base), ref);
    }

    public static URI resolveURIReference(URI base, String ref) throws URISyntaxException {
        String query;
        String path;
        String authority;
        String scheme;
        URI _ref = URI.create(ref);
        if (_ref.getScheme() != null) {
            scheme = _ref.getScheme();
            authority = _ref.getAuthority();
            path = HttpUtils.removeDots(_ref.getPath());
            query = _ref.getRawQuery();
        } else {
            if (_ref.getAuthority() != null) {
                authority = _ref.getAuthority();
                path = _ref.getPath();
                query = _ref.getRawQuery();
            } else {
                if (_ref.getPath().length() == 0) {
                    path = base.getPath();
                    query = _ref.getRawQuery() != null ? _ref.getRawQuery() : base.getRawQuery();
                } else {
                    if (_ref.getPath().startsWith("/")) {
                        path = HttpUtils.removeDots(_ref.getPath());
                    } else {
                        int index;
                        String basePath = base.getPath();
                        String mergedPath = base.getAuthority() != null && basePath.length() == 0 ? "/" + _ref.getPath() : ((index = basePath.lastIndexOf(47)) > -1 ? basePath.substring(0, index + 1) + _ref.getPath() : _ref.getPath());
                        path = HttpUtils.removeDots(mergedPath);
                    }
                    query = _ref.getRawQuery();
                }
                authority = base.getAuthority();
            }
            scheme = base.getScheme();
        }
        return new URI(scheme, authority, path, query, _ref.getFragment());
    }

    static String parsePath(String uri) {
        int i;
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i, queryStart);
    }

    static String parseQuery(String uri) {
        int i = uri.indexOf(63);
        if (i == -1) {
            return null;
        }
        return uri.substring(i + 1, uri.length());
    }

    static String absoluteURI(String serverOrigin, HttpServerRequest req) throws URISyntaxException {
        String host;
        URI uri = new URI(req.uri());
        String scheme = uri.getScheme();
        String absoluteURI = scheme != null && (scheme.equals("http") || scheme.equals("https")) ? uri.toString() : ((host = req.host()) != null ? req.scheme() + "://" + host + uri : serverOrigin + uri);
        return absoluteURI;
    }

    static MultiMap params(String uri) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        Map prms = queryStringDecoder.parameters();
        CaseInsensitiveHeaders params = new CaseInsensitiveHeaders();
        if (!prms.isEmpty()) {
            for (Map.Entry entry : prms.entrySet()) {
                params.add((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return params;
    }

    public static void fromVertxInitialSettings(boolean server, Http2Settings vertxSettings, io.netty.handler.codec.http2.Http2Settings nettySettings) {
        if (vertxSettings != null) {
            Map extraSettings;
            if (!server && !vertxSettings.isPushEnabled()) {
                nettySettings.pushEnabled(vertxSettings.isPushEnabled());
            }
            if (vertxSettings.getHeaderTableSize() != 4096L) {
                nettySettings.put('\u0001', Long.valueOf(vertxSettings.getHeaderTableSize()));
            }
            if (vertxSettings.getInitialWindowSize() != 65535) {
                nettySettings.initialWindowSize(vertxSettings.getInitialWindowSize());
            }
            if (vertxSettings.getMaxConcurrentStreams() != 0xFFFFFFFFL) {
                nettySettings.maxConcurrentStreams(vertxSettings.getMaxConcurrentStreams());
            }
            if (vertxSettings.getMaxFrameSize() != 16384) {
                nettySettings.maxFrameSize(vertxSettings.getMaxFrameSize());
            }
            if (vertxSettings.getMaxHeaderListSize() != Integer.MAX_VALUE) {
                nettySettings.maxHeaderListSize(vertxSettings.getMaxHeaderListSize());
            }
            if ((extraSettings = vertxSettings.getExtraSettings()) != null) {
                extraSettings.forEach((code, setting) -> nettySettings.put((char)code.intValue(), setting));
            }
        }
    }

    public static io.netty.handler.codec.http2.Http2Settings fromVertxSettings(Http2Settings settings) {
        io.netty.handler.codec.http2.Http2Settings converted = new io.netty.handler.codec.http2.Http2Settings();
        converted.pushEnabled(settings.isPushEnabled());
        converted.maxFrameSize(settings.getMaxFrameSize());
        converted.initialWindowSize(settings.getInitialWindowSize());
        converted.headerTableSize(settings.getHeaderTableSize());
        converted.maxConcurrentStreams(settings.getMaxConcurrentStreams());
        converted.maxHeaderListSize(settings.getMaxHeaderListSize());
        if (settings.getExtraSettings() != null) {
            settings.getExtraSettings().forEach((key, value) -> converted.put((char)key.intValue(), value));
        }
        return converted;
    }

    public static Http2Settings toVertxSettings(io.netty.handler.codec.http2.Http2Settings settings) {
        Long headerTableSize;
        Integer initialWindowSize;
        Integer maxFrameSize;
        Long maxHeaderListSize;
        Long maxConcurrentStreams;
        Http2Settings converted = new Http2Settings();
        Boolean pushEnabled = settings.pushEnabled();
        if (pushEnabled != null) {
            converted.setPushEnabled(pushEnabled.booleanValue());
        }
        if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
            converted.setMaxConcurrentStreams(maxConcurrentStreams.longValue());
        }
        if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
            converted.setMaxHeaderListSize(maxHeaderListSize.longValue());
        }
        if ((maxFrameSize = settings.maxFrameSize()) != null) {
            converted.setMaxFrameSize(maxFrameSize.intValue());
        }
        if ((initialWindowSize = settings.initialWindowSize()) != null) {
            converted.setInitialWindowSize(initialWindowSize.intValue());
        }
        if ((headerTableSize = settings.headerTableSize()) != null) {
            converted.setHeaderTableSize(headerTableSize.longValue());
        }
        settings.forEach((key, value) -> {
            if (key.charValue() > '\u0006') {
                converted.set((int)key.charValue(), value.longValue());
            }
        });
        return converted;
    }

    static io.netty.handler.codec.http2.Http2Settings decodeSettings(String base64Settings) {
        try {
            io.netty.handler.codec.http2.Http2Settings settings = new io.netty.handler.codec.http2.Http2Settings();
            Buffer buffer = Buffer.buffer((byte[])Base64.getUrlDecoder().decode(base64Settings));
            int len = buffer.length();
            for (int pos = 0; pos < len; pos += 4) {
                int i = buffer.getUnsignedShort(pos);
                long j = buffer.getUnsignedInt(pos += 2);
                settings.put((char)i, Long.valueOf(j));
            }
            return settings;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encodeSettings(Http2Settings settings) {
        Buffer buffer = Buffer.buffer();
        HttpUtils.fromVertxSettings(settings).forEach((c, l) -> {
            buffer.appendUnsignedShort((int)c.charValue());
            buffer.appendUnsignedInt(l.longValue());
        });
        return Base64.getUrlEncoder().encodeToString(buffer.getBytes());
    }

    public static ByteBuf generateWSCloseFrameByteBuf(short statusCode, String reason) {
        if (reason != null) {
            return Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.copyShort((int)statusCode), Unpooled.copiedBuffer((CharSequence)reason, (Charset)Charset.forName("UTF-8"))});
        }
        return Unpooled.copyShort((int)statusCode);
    }

    static void sendError(Channel ch, HttpResponseStatus status, CharSequence err) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, status);
        if (status.code() == HttpResponseStatus.METHOD_NOT_ALLOWED.code()) {
            resp.headers().set(HttpHeaders.ALLOW, (Object)HttpHeaders.GET);
        }
        if (err != null) {
            resp.content().writeBytes(err.toString().getBytes(CharsetUtil.UTF_8));
            HttpUtil.setContentLength((HttpMessage)resp, (long)err.length());
        } else {
            HttpUtil.setContentLength((HttpMessage)resp, (long)0L);
        }
        ch.writeAndFlush((Object)resp);
    }

    static String getWebSocketLocation(HttpRequest req, boolean ssl) throws Exception {
        String prefix = ssl ? "ws://" : "wss://";
        URI uri = new URI(req.uri());
        String path = uri.getRawPath();
        String loc = prefix + req.headers().get((CharSequence)HttpHeaderNames.HOST) + path;
        String query = uri.getRawQuery();
        if (query != null) {
            loc = loc + "?" + query;
        }
        return loc;
    }

    static String determineContentEncoding(Http2Headers headers) {
        ZlibWrapper wrapper;
        String acceptEncoding;
        String string = acceptEncoding = headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
        if (acceptEncoding != null && (wrapper = compressor.determineWrapper(acceptEncoding)) != null) {
            switch (wrapper) {
                case GZIP: {
                    return "gzip";
                }
                case ZLIB: {
                    return "deflate";
                }
            }
        }
        return null;
    }

    static io.netty.handler.codec.http.HttpMethod toNettyHttpMethod(HttpMethod method, String rawMethod) {
        switch (method) {
            case CONNECT: {
                return io.netty.handler.codec.http.HttpMethod.CONNECT;
            }
            case GET: {
                return io.netty.handler.codec.http.HttpMethod.GET;
            }
            case PUT: {
                return io.netty.handler.codec.http.HttpMethod.PUT;
            }
            case POST: {
                return io.netty.handler.codec.http.HttpMethod.POST;
            }
            case DELETE: {
                return io.netty.handler.codec.http.HttpMethod.DELETE;
            }
            case HEAD: {
                return io.netty.handler.codec.http.HttpMethod.HEAD;
            }
            case OPTIONS: {
                return io.netty.handler.codec.http.HttpMethod.OPTIONS;
            }
            case TRACE: {
                return io.netty.handler.codec.http.HttpMethod.TRACE;
            }
            case PATCH: {
                return io.netty.handler.codec.http.HttpMethod.PATCH;
            }
        }
        return io.netty.handler.codec.http.HttpMethod.valueOf((String)rawMethod);
    }

    static io.netty.handler.codec.http.HttpVersion toNettyHttpVersion(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_0;
            }
            case HTTP_1_1: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_1;
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP version: " + version);
    }

    static HttpMethod toVertxMethod(String method) {
        try {
            return HttpMethod.valueOf((String)method);
        }
        catch (IllegalArgumentException e) {
            return HttpMethod.OTHER;
        }
    }

    public static int parseKeepAliveHeaderTimeout(CharSequence value) {
        int len = value.length();
        int pos = 0;
        while (pos < len) {
            int to;
            int next;
            int idx = AsciiString.indexOf((CharSequence)value, (char)',', (int)pos);
            if (idx == -1) {
                idx = next = len;
            } else {
                next = idx + 1;
            }
            while (pos < idx && value.charAt(pos) == ' ') {
                ++pos;
            }
            for (to = idx; to > pos && value.charAt(to - 1) == ' '; --to) {
            }
            if (AsciiString.regionMatches((CharSequence)value, (boolean)true, (int)pos, (CharSequence)TIMEOUT_EQ, (int)0, (int)TIMEOUT_EQ.length()) && (pos += TIMEOUT_EQ.length()) < to) {
                int ret = 0;
                while (pos < to) {
                    char ch;
                    if ((ch = value.charAt(pos++)) >= '0' && ch < '9') {
                        ret = ret * 10 + (ch - 48);
                        continue;
                    }
                    ret = -1;
                    break;
                }
                if (ret > -1) {
                    return ret;
                }
            }
            pos = next;
        }
        return -1;
    }

    public static void validateHeader(CharSequence name, CharSequence value) {
        if (VALIDATE_HEADER) {
            HttpUtils.validateHeaderName(name);
            HttpUtils.validateHeaderValue(value);
        }
    }

    public static void validateHeader(CharSequence name, Iterable<? extends CharSequence> values) {
        if (VALIDATE_HEADER) {
            HttpUtils.validateHeaderName(name);
            values.forEach(HEADER_VALUE_VALIDATOR);
        }
    }

    public static void validateHeaderValue(CharSequence seq) {
        if (VALIDATE_HEADER) {
            int state = 0;
            for (int index = 0; index < seq.length(); ++index) {
                state = HttpUtils.validateValueChar(seq, state, seq.charAt(index));
            }
            if (state != 0) {
                throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + seq);
            }
        }
    }

    private static int validateValueChar(CharSequence seq, int state, char character) {
        if ((character & 0xFFFFFFF0) == 0) {
            switch (character) {
                case '\u0000': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\u0000': " + seq);
                }
                case '\u000b': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\\v': " + seq);
                }
                case '\f': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\\f': " + seq);
                }
            }
        }
        switch (state) {
            case 0: {
                switch (character) {
                    case '\r': {
                        return 1;
                    }
                    case '\n': {
                        return 2;
                    }
                }
                break;
            }
            case 1: {
                switch (character) {
                    case '\n': {
                        return 2;
                    }
                }
                throw new IllegalArgumentException("only '\\n' is allowed after '\\r': " + seq);
            }
            case 2: {
                switch (character) {
                    case '\t': 
                    case ' ': {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("only ' ' and '\\t' are allowed after '\\n': " + seq);
            }
        }
        return state;
    }

    public static void validateHeaderName(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("a header name cannot contain the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + value);
                }
            }
            if (c <= '\u007f') continue;
            throw new IllegalArgumentException("a header name cannot contain non-ASCII character: " + value);
        }
    }

    protected static class Slice {
        protected int start = -1;
        protected int end = -1;
        protected boolean partial;
        protected char value;
        protected Slice prev;
        protected Slice next;
        protected int dots;

        public Slice(int start, int end, Slice prev) {
            this(start, end, '\u0000', false, 0, prev);
        }

        public Slice(int start, int end, char value) {
            this(start, end, value, false, 0, null);
        }

        public Slice(int start, int end, char value, boolean partial) {
            this(start, end, value, partial, 0, null);
        }

        public Slice(int start, int end, char value, Slice prev) {
            this(start, end, value, false, 0, prev);
        }

        public Slice(int start, int end, char value, boolean partial, int dots, Slice prev) {
            this.start = start;
            this.end = end;
            this.value = value;
            this.partial = partial;
            this.dots = dots;
            this.prev = prev;
            if (prev != null) {
                prev.setNext(this);
                if (prev.partial) {
                    this.dots = prev.dots;
                }
            }
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public boolean isPartial() {
            return this.partial;
        }

        public void setPartial(boolean partial) {
            this.partial = partial;
        }

        public int length() {
            return this.end - this.start;
        }

        public char getValue() {
            return this.value;
        }

        public void setValue(char value) {
            this.value = value;
        }

        public int getDots() {
            return this.dots;
        }

        public Slice getPrev() {
            return this.prev;
        }

        public void setPrev(Slice prev) {
            this.prev = prev;
        }

        public Slice getNext() {
            return this.next;
        }

        public void setNext(Slice next) {
            this.next = next;
        }

        public Slice remove() {
            if (this.prev != null) {
                this.prev.setNext(this.next);
                if (this.next != null) {
                    this.next.setPrev(this.prev);
                }
            } else if (this.next != null) {
                this.next.setPrev(null);
            }
            return this.prev;
        }

        public Slice removePath() {
            Slice result = this;
            while ((result = result.remove()) != null && result.partial) {
            }
            return result;
        }
    }

    private static class CustomCompressor
    extends HttpContentCompressor {
        private CustomCompressor() {
        }

        public ZlibWrapper determineWrapper(String acceptEncoding) {
            return super.determineWrapper(acceptEncoding);
        }
    }
}

