/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import com.jd.laf.web.vertx.Environment;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.MyRoute;
import io.vertx.ext.web.impl.MyRoutingContext;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouterImpl;
import io.vertx.ext.web.impl.RoutingContextWrapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;

public class MyRouter
extends RouterImpl {
    private static final Logger log = LoggerFactory.getLogger(MyRouter.class);
    protected static final Comparator<RouteImpl> routeComparator = (o1, o2) -> {
        int compare = Integer.compare(o1.order(), o2.order());
        if (compare == 0) {
            if (o1.equals(o2)) {
                return 0;
            }
            return 1;
        }
        return compare;
    };
    protected final Set<RouteImpl> routes = new ConcurrentSkipListSet<RouteImpl>(routeComparator);
    protected final AtomicInteger orderSequence = new AtomicInteger();
    protected final Environment environment;
    protected Map<Integer, Handler<RoutingContext>> errorHandlers = new ConcurrentHashMap<Integer, Handler<RoutingContext>>();

    public MyRouter(Vertx vertx, Environment environment) {
        super(vertx);
        this.environment = environment;
    }

    public void handle(HttpServerRequest request) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Router: " + System.identityHashCode((Object)this) + " accepting request " + request.method() + " " + request.absoluteURI()));
        }
        new MyRoutingContext(null, this, request, this.routes, this.environment).next();
    }

    public MyRoute route() {
        return new MyRoute(this, this.orderSequence.getAndIncrement());
    }

    public MyRoute route(HttpMethod method, String path) {
        return new MyRoute((RouterImpl)this, this.orderSequence.getAndIncrement(), method, path);
    }

    public MyRoute route(String path) {
        return new MyRoute(this, this.orderSequence.getAndIncrement(), path);
    }

    public MyRoute routeWithRegex(HttpMethod method, String regex) {
        return new MyRoute(this, this.orderSequence.getAndIncrement(), method, regex, true);
    }

    public MyRoute routeWithRegex(String regex) {
        return new MyRoute((RouterImpl)this, this.orderSequence.getAndIncrement(), regex, true);
    }

    public List<Route> getRoutes() {
        return new ArrayList<RouteImpl>(this.routes);
    }

    public Router clear() {
        this.routes.clear();
        return this;
    }

    public void handleContext(RoutingContext ctx) {
        new RoutingContextWrapper(this.getAndCheckRoutePath(ctx), ctx.request(), this.routes, ctx).next();
    }

    public void handleFailure(RoutingContext ctx) {
        new RoutingContextWrapper(this.getAndCheckRoutePath(ctx), ctx.request(), this.routes, ctx).next();
    }

    protected Vertx vertx() {
        return super.vertx();
    }

    public Router errorHandler(int statusCode, Handler<RoutingContext> errorHandler) {
        Objects.requireNonNull(errorHandler);
        this.errorHandlers.put(statusCode, errorHandler);
        return this;
    }

    protected void add(RouteImpl route) {
        this.routes.add(route);
    }

    protected void remove(RouteImpl route) {
        this.routes.remove(route);
    }

    protected Iterator<RouteImpl> iterator() {
        return this.routes.iterator();
    }

    Handler<RoutingContext> getErrorHandlerByStatusCode(int statusCode) {
        return this.errorHandlers.get(statusCode);
    }

    protected String getAndCheckRoutePath(RoutingContext ctx) {
        Route currentRoute = ctx.currentRoute();
        String path = currentRoute.getPath();
        if (path == null) {
            throw new IllegalStateException("Sub routers must be mounted on constant paths (no regex or patterns)");
        }
        return path;
    }
}

