/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.extension;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

public abstract class Converts {
    public static String getString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof Collection) {
            StringBuilder builder = new StringBuilder();
            Collection collection = (Collection)value;
            int count = 0;
            for (Object item : collection) {
                if (count++ > 0) {
                    builder.append(',');
                }
                if (item == null) continue;
                builder.append(item.toString());
            }
            return builder.toString();
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                Object item;
                if (i > 0) {
                    builder.append(',');
                }
                if ((item = Array.get(value, i)) == null) continue;
                builder.append(item.toString());
            }
            return builder.toString();
        }
        return value.toString();
    }

    public static String getString(Object value, String def) {
        String text = Converts.getString(value);
        if (text == null || text.isEmpty()) {
            return def;
        }
        return text;
    }

    public static Date getDate(Object value, Date def) {
        if (value == null) {
            return def;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof CharSequence) {
            String text = value.toString();
            try {
                return new Date(Long.parseLong(text));
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static Date getDate(Object value, SimpleDateFormat format) {
        return Converts.getDate(value, format, null);
    }

    public static Date getDate(Object value, SimpleDateFormat format, Date def) {
        if (value == null) {
            return def;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (format == null) {
            return def;
        }
        if (value instanceof CharSequence) {
            String text = value.toString();
            try {
                return format.parse(text);
            }
            catch (ParseException e) {
                return def;
            }
        }
        return def;
    }

    public static Date getDate(Object value, String format, String def) {
        SimpleDateFormat sdf = format == null || format.isEmpty() ? null : new SimpleDateFormat(format);
        Date result = Converts.getDate(value, sdf);
        try {
            return result == null ? (sdf == null || def == null || def.isEmpty() ? null : sdf.parse(def)) : result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Float getFloat(Object value) {
        return Converts.getFloat(value, null);
    }

    public static Float getFloat(Object value, Float def) {
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof CharSequence || value instanceof Character) {
            String text = value.toString();
            if (text == null || text.isEmpty()) {
                return def;
            }
            try {
                return Float.valueOf(Float.parseFloat(text));
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static Double getDouble(Object value) {
        return Converts.getDouble(value, null);
    }

    public static Double getDouble(Object value, Double def) {
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof CharSequence || value instanceof Character) {
            String text = value.toString();
            if (text == null || text.isEmpty()) {
                return def;
            }
            try {
                return Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static Long getLong(Object value) {
        return Converts.getLong(value, null);
    }

    public static Long getLong(Object value, Long def) {
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof CharSequence || value instanceof Character) {
            String text = value.toString();
            if (text == null || text.isEmpty()) {
                return def;
            }
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static Integer getInteger(Object value) {
        return Converts.getInteger(value, null);
    }

    public static Integer getInteger(Object value, Integer def) {
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof CharSequence || value instanceof Character) {
            String text = value.toString();
            if (text == null || text.isEmpty()) {
                return def;
            }
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static Short getShort(Object value) {
        return Converts.getShort(value, null);
    }

    public static Short getShort(Object value, Short def) {
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof CharSequence || value instanceof Character) {
            String text = value.toString();
            if (text == null || text.isEmpty()) {
                return def;
            }
            try {
                return Short.parseShort(text);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static Byte getByte(Object value) {
        return Converts.getByte(value, null);
    }

    public static Byte getByte(Object value, Byte def) {
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof CharSequence || value instanceof Character) {
            String text = value.toString();
            if (text == null || text.isEmpty()) {
                return def;
            }
            try {
                return Byte.parseByte(text);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static Boolean getBoolean(Object value) {
        return Converts.getBoolean(value, null);
    }

    public static Boolean getBoolean(Object value, Boolean def) {
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue() != '0';
        }
        if (value instanceof CharSequence) {
            String text = value.toString();
            if ("true".equalsIgnoreCase(text)) {
                return true;
            }
            if ("false".equalsIgnoreCase(text)) {
                return false;
            }
            try {
                return Long.parseLong(text) != 0L;
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static Long getNatural(Object value, Long def) {
        Long result = Converts.getLong(value, null);
        return result == null || result < 0L ? def : result;
    }

    public static Integer getNatural(Object value, Integer def) {
        Integer result = Converts.getInteger(value, null);
        return result == null || result < 0 ? def : result;
    }

    public static Short getNatural(Object value, Short def) {
        Short result = Converts.getShort(value, null);
        return result == null || result < 0 ? def : result;
    }

    public static Byte getNatural(Object value, Byte def) {
        Byte result = Converts.getByte(value, null);
        return result == null || result < 0 ? def : result;
    }

    public static Long getPositive(Object value, Long def) {
        Long result = Converts.getLong(value, null);
        return result == null || result <= 0L ? def : result;
    }

    public static Integer getPositive(Object value, Integer def) {
        Integer result = Converts.getInteger(value, null);
        return result == null || result <= 0 ? def : result;
    }

    public static Short getPositive(Object value, Short def) {
        Short result = Converts.getShort(value, null);
        return result == null || result <= 0 ? def : result;
    }

    public static Byte getPositive(Object value, Byte def) {
        Byte result = Converts.getByte(value, null);
        return result == null || result <= 0 ? def : result;
    }
}

