/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.extension;

import com.jd.laf.extension.Plugin;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public interface ExtensionLoader {
    public <T> Collection<Plugin<T>> load(Class<T> var1);

    public static class Wrapper
    implements ExtensionLoader {
        protected Set<ExtensionLoader> loaders = new LinkedHashSet<ExtensionLoader>();

        public Wrapper(ExtensionLoader ... loaders) {
            if (loaders != null) {
                for (ExtensionLoader loader : loaders) {
                    this.add(loader);
                }
            }
        }

        public Wrapper(Collection<ExtensionLoader> loaders) {
            if (loaders != null) {
                for (ExtensionLoader loader : loaders) {
                    this.add(loader);
                }
            }
        }

        protected void add(ExtensionLoader loader) {
            if (loader == null) {
                return;
            }
            if (loader instanceof Wrapper) {
                for (ExtensionLoader l : ((Wrapper)loader).loaders) {
                    this.add(l);
                }
            } else {
                this.loaders.add(loader);
            }
        }

        @Override
        public <T> Collection<Plugin<T>> load(Class<T> extensible) {
            LinkedList<Plugin<T>> result = new LinkedList<Plugin<T>>();
            if (this.loaders != null) {
                for (ExtensionLoader loader : this.loaders) {
                    Collection<Plugin<T>> plugins = loader.load(extensible);
                    if (plugins == null) continue;
                    result.addAll(plugins);
                }
            }
            return result;
        }
    }
}

