/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.extension;

import com.jd.laf.extension.Classify;
import com.jd.laf.extension.Extensible;
import com.jd.laf.extension.Extension;
import com.jd.laf.extension.ExtensionLoader;
import com.jd.laf.extension.ExtensionMeta;
import com.jd.laf.extension.ExtensionPoint;
import com.jd.laf.extension.ExtensionScanner;
import com.jd.laf.extension.ExtensionSpi;
import com.jd.laf.extension.Instantiation;
import com.jd.laf.extension.Name;
import com.jd.laf.extension.Ordered;
import com.jd.laf.extension.Plugin;
import com.jd.laf.extension.Prototype;
import com.jd.laf.extension.SpiLoader;
import com.jd.laf.extension.Type;
import com.jd.laf.extension.listener.ExtensionListener;
import com.jd.laf.extension.listener.LoaderEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class ExtensionManager {
    protected static volatile Snapshot SNAPSHOT = new Snapshot(SpiLoader.INSTANCE);
    protected static List<ExtensionListener> LISTENERS = new CopyOnWriteArrayList<ExtensionListener>();

    public static <T, M> T getExtension(String type, M name) {
        return SNAPSHOT.getExtension(type, name);
    }

    public static <T, M> T getExtension(Class<T> extensible, M name) {
        ExtensionPoint spi = SNAPSHOT.getExtensionPoint(extensible);
        return spi == null ? null : (T)spi.get(name);
    }

    public static <T, M> T getOrLoadExtension(Class<T> extensible, M name) {
        ExtensionPoint spi = SNAPSHOT.getOrLoadExtensionPoint(extensible, null, ExtensionMeta.AscendingComparator.INSTANCE, null);
        return spi == null ? null : (T)spi.get(name);
    }

    public static <T> T getOrLoadExtension(Class<T> extensible) {
        ExtensionPoint spi = SNAPSHOT.getOrLoadExtensionPoint(extensible, null, ExtensionMeta.AscendingComparator.INSTANCE, null);
        return spi == null ? null : (T)spi.get();
    }

    public static <T> Iterable<T> getExtensions(Class<T> extensible) {
        ExtensionPoint spi = SNAPSHOT.getExtensionPoint(extensible);
        return spi == null ? null : spi.extensions();
    }

    public static <T> Iterable<T> getOrLoadExtensions(Class<T> extensible) {
        ExtensionPoint spi = SNAPSHOT.getOrLoadExtensionPoint(extensible, null, ExtensionMeta.AscendingComparator.INSTANCE, null);
        return spi == null ? null : spi.extensions();
    }

    public static <T> Iterable<T> get(String type) {
        return SNAPSHOT.getExtensions(type);
    }

    public static <T, M> ExtensionPoint<T, M> getOrLoadExtensionPoint(Class<T> extensible) {
        return SNAPSHOT.getOrLoadExtensionPoint(extensible, null, ExtensionMeta.AscendingComparator.INSTANCE, null);
    }

    public static <T, M> ExtensionPoint<T, M> getOrLoadExtensionPoint(Class<T> extensible, ExtensionLoader loader) {
        return SNAPSHOT.getOrLoadExtensionPoint(extensible, loader, ExtensionMeta.AscendingComparator.INSTANCE, null);
    }

    public static <T, M> ExtensionPoint<T, M> getOrLoadExtensionPoint(Class<T> extensible, Comparator<ExtensionMeta<T, M>> comparator) {
        return SNAPSHOT.getOrLoadExtensionPoint(extensible, null, comparator, null);
    }

    public static <T, M> ExtensionPoint<T, M> getOrLoadExtensionPoint(Class<T> extensible, ExtensionLoader loader, Comparator<ExtensionMeta<T, M>> comparator) {
        return SNAPSHOT.getOrLoadExtensionPoint(extensible, loader, comparator, null);
    }

    public static <T, M> ExtensionPoint<T, M> getOrLoadExtensionPoint(Class<T> extensible, ExtensionLoader loader, Comparator<ExtensionMeta<T, M>> comparator, Classify<T, M> classify) {
        return SNAPSHOT.getOrLoadExtensionPoint(extensible, loader, comparator, classify);
    }

    public static void loadExtension(Collection<Class<?>> extensibles) {
        SNAPSHOT.loadExtension(extensibles);
    }

    public static void loadExtension(Collection<Class<?>> extensibles, ExtensionLoader loader) {
        SNAPSHOT.loadExtension(extensibles, loader);
    }

    public static void loadExtension(ExtensionScanner scanner) {
        if (scanner != null) {
            SNAPSHOT.loadExtension(scanner.scan());
        }
    }

    public static void loadExtension(ExtensionScanner scanner, ExtensionLoader loader) {
        if (scanner != null) {
            SNAPSHOT.loadExtension(scanner.scan(), loader);
        }
    }

    public static synchronized void register(ExtensionLoader loader) {
        ExtensionManager.apply(SNAPSHOT.register(loader));
    }

    protected static void apply(Snapshot snapshot) {
        boolean flag;
        boolean bl = flag = SNAPSHOT == snapshot;
        if (!flag) {
            SNAPSHOT = snapshot;
            for (ExtensionListener listener : LISTENERS) {
                listener.onEvent(new LoaderEvent(SNAPSHOT));
            }
        }
    }

    public static synchronized void deregister(ExtensionLoader loader) {
        ExtensionManager.apply(SNAPSHOT.deregister(loader));
    }

    public static boolean addListener(ExtensionListener listener) {
        if (listener == null) {
            return false;
        }
        return LISTENERS.add(listener);
    }

    protected static class Snapshot {
        protected ConcurrentMap<String, ExtensionSpi> names = new ConcurrentHashMap<String, ExtensionSpi>();
        protected ConcurrentMap<Class, ExtensionSpi> extensions = new ConcurrentHashMap<Class, ExtensionSpi>();
        protected ExtensionLoader loader;

        public Snapshot() {
            this(SpiLoader.INSTANCE);
        }

        public Snapshot(ExtensionLoader loader) {
            this.loader = loader == null ? SpiLoader.INSTANCE : loader;
        }

        protected void addTo(Set<ExtensionLoader> loaders, ExtensionLoader loader) {
            if (loader == null) {
                return;
            }
            if (loader instanceof ExtensionLoader.Wrapper) {
                for (ExtensionLoader l : ((ExtensionLoader.Wrapper)loader).loaders) {
                    this.addTo(loaders, l);
                }
            } else {
                loaders.add(loader);
            }
        }

        public <T, M> Snapshot register(ExtensionLoader loader) {
            if (loader == null) {
                return this;
            }
            if (loader == this.loader) {
                return this;
            }
            LinkedHashSet<ExtensionLoader> loaders = new LinkedHashSet<ExtensionLoader>();
            this.addTo(loaders, this.loader);
            LinkedHashSet<ExtensionLoader> newLoaders = new LinkedHashSet<ExtensionLoader>();
            this.addTo(newLoaders, loader);
            if (!loaders.addAll(newLoaders)) {
                return this;
            }
            ExtensionLoader.Wrapper wrapper = new ExtensionLoader.Wrapper(newLoaders);
            Snapshot result = new Snapshot(new ExtensionLoader.Wrapper(loaders));
            for (Map.Entry entry : this.extensions.entrySet()) {
                ExtensionSpi spi = (ExtensionSpi)entry.getValue();
                Name name = spi.name;
                LinkedList<ExtensionMeta<T, M>> metas = new LinkedList<ExtensionMeta<T, M>>();
                metas.addAll(spi.metas);
                this.load(name.getClazz(), name, wrapper, spi.classify, metas);
                Collections.sort(metas, spi.comparator);
                result.add(new ExtensionSpi(name, metas, spi.comparator, spi.classify));
            }
            return result;
        }

        public <T, M> Snapshot deregister(ExtensionLoader loader) {
            if (loader == null) {
                return this;
            }
            if (loader == this.loader) {
                return new Snapshot();
            }
            LinkedHashSet<ExtensionLoader> loaders = new LinkedHashSet<ExtensionLoader>();
            this.addTo(loaders, this.loader);
            LinkedHashSet<ExtensionLoader> excludes = new LinkedHashSet<ExtensionLoader>();
            this.addTo(excludes, loader);
            if (!loaders.removeAll(excludes)) {
                return this;
            }
            if (loaders.isEmpty()) {
                return new Snapshot();
            }
            Snapshot result = new Snapshot(loaders.size() == 1 ? (ExtensionLoader)loaders.iterator().next() : new ExtensionLoader.Wrapper(loaders));
            for (Map.Entry entry : this.extensions.entrySet()) {
                ExtensionSpi spi = (ExtensionSpi)entry.getValue();
                Name name = spi.name;
                LinkedList metas = new LinkedList();
                for (ExtensionMeta meta : spi.metas) {
                    if (excludes.contains(meta.loader)) continue;
                    metas.add(meta);
                }
                result.add(new ExtensionSpi(name, metas, spi.comparator, spi.classify));
            }
            return result;
        }

        protected <T, M> ExtensionSpi<T, M> add(ExtensionSpi<T, M> ExtensionPoint2) {
            if (ExtensionPoint2 != null) {
                Name<T, String> name = ExtensionPoint2.getName();
                ExtensionSpi<T, M> exists = this.extensions.putIfAbsent(name.getClazz(), ExtensionPoint2);
                if (exists == null) {
                    if (name.getName() != null) {
                        this.names.put(name.getName(), ExtensionPoint2);
                    }
                    return ExtensionPoint2;
                }
                return exists;
            }
            return null;
        }

        public <T, M> Iterable<T> getExtensions(String type) {
            ExtensionPoint spi = (ExtensionPoint)this.names.get(type);
            return spi == null ? null : spi.extensions();
        }

        public <T, M> T getExtension(String type, M name) {
            ExtensionPoint spi = (ExtensionPoint)this.names.get(type);
            return spi == null ? null : (T)spi.get(name);
        }

        public <T, M> ExtensionPoint<T, M> getExtensionPoint(Class<T> extensible) {
            return (ExtensionPoint)this.extensions.get(extensible);
        }

        public <T, M> ExtensionPoint getOrLoadExtensionPoint(Class<T> extensible, ExtensionLoader loader, Comparator<ExtensionMeta<T, M>> comparator, Classify<T, M> classify) {
            if (extensible == null) {
                return null;
            }
            ExtensionPoint<T, M> result = this.getExtensionPoint(extensible);
            if (result == null) {
                Extensible annotation = extensible.getAnnotation(Extensible.class);
                Name<T, String> extensibleName = new Name<T, String>(extensible, annotation != null && annotation.value() != null && !annotation.value().isEmpty() ? annotation.value() : extensible.getName());
                LinkedList<ExtensionMeta<T, M>> metas = new LinkedList<ExtensionMeta<T, M>>();
                this.load(extensible, extensibleName, loader, classify, metas);
                Comparator<ExtensionMeta<T, M>> c = comparator == null ? ExtensionMeta.AscendingComparator.INSTANCE : comparator;
                Collections.sort(metas, c);
                result = this.add(new ExtensionSpi<T, M>(extensibleName, metas, c, classify));
            }
            return result;
        }

        protected <T, M> void load(Class<T> extensible, Name extensibleName, ExtensionLoader loader, Classify<T, M> classify, List<ExtensionMeta<T, M>> metas) {
            Collection<Plugin<T>> plugins = loader == null ? this.loader.load(extensible) : loader.load(extensible);
            for (Plugin<T> plugin : plugins) {
                Class pluginClass = plugin.name.getClazz();
                Extension extension = pluginClass.getAnnotation(Extension.class);
                ExtensionMeta<Object, M> meta = new ExtensionMeta<Object, M>();
                meta.setLoader(plugin.loader);
                meta.setExtensible(extensibleName);
                meta.setName(plugin.name);
                meta.setProvider(extension != null && !extension.provider().isEmpty() ? extension.provider() : pluginClass.getName());
                meta.setInstantiation(plugin.instantiation == null ? Instantiation.ClazzInstance.INSTANCE : plugin.instantiation);
                meta.setTarget(plugin.target);
                meta.setSingleton(plugin.isSingleton() != null ? plugin.isSingleton() : (Prototype.class.isAssignableFrom(pluginClass) ? false : (extension == null ? true : extension.singleton())));
                Object target = meta.getTarget();
                meta.setExtension(new Name(pluginClass, classify != null ? classify.type(target) : (Type.class.isAssignableFrom(pluginClass) ? ((Type)target).type() : (extension != null && extension.value() != null && !extension.value().isEmpty() ? extension.value() : pluginClass.getName()))));
                meta.setOrder(Ordered.class.isAssignableFrom(pluginClass) ? ((Ordered)target).order() : (extension == null ? Short.MAX_VALUE : extension.order()));
                metas.add(meta);
            }
        }

        public void loadExtension(Collection<Class<?>> extensibles) {
            this.loadExtension(extensibles, this.loader);
        }

        public void loadExtension(Collection<Class<?>> extensibles, ExtensionLoader loader) {
            if (extensibles != null) {
                ExtensionLoader extensionLoader = loader == null ? this.loader : loader;
                for (Class<?> extensible : extensibles) {
                    this.getOrLoadExtensionPoint(extensible, extensionLoader, null, null);
                }
            }
        }
    }
}

