/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.extension;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

public interface ExtensionScanner {
    public Set<Class<?>> scan();

    public static class DefaultScanner
    implements ExtensionScanner {
        @Override
        public Set<Class<?>> scan() {
            LinkedHashSet classes = new LinkedHashSet();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Enumeration<URL> urls = classLoader.getResources("META-INF/com.jd.laf.extension");
                while (urls.hasMoreElements()) {
                    this.scan(classLoader, urls.nextElement(), classes);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return classes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void scan(ClassLoader classLoader, URL url, Set<Class<?>> classes) {
            BufferedReader input = null;
            try {
                String line;
                input = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((line = input.readLine()) != null) {
                    classes.add(classLoader.loadClass(line));
                }
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

