/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.extension;

import com.jd.laf.extension.Classify;
import com.jd.laf.extension.ExtensionMeta;
import com.jd.laf.extension.ExtensionPoint;
import com.jd.laf.extension.Maps;
import com.jd.laf.extension.Name;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ExtensionSpi<T, M>
implements ExtensionPoint<T, M> {
    protected ConcurrentMap<M, List<ExtensionMeta<T, M>>> multiNames;
    protected ConcurrentMap<String, ExtensionMeta<T, M>> providers;
    protected ConcurrentMap<M, ExtensionMeta<T, M>> names;
    protected List<ExtensionMeta<T, M>> metas;
    protected Name<T, String> name;
    protected T target;
    protected Comparator<ExtensionMeta<T, M>> comparator;
    protected Classify<T, M> classify;
    protected boolean singleton = true;
    protected volatile List<T> extensions;
    protected volatile List<T> reverses;

    public ExtensionSpi(Name<T, String> name, List<ExtensionMeta<T, M>> metas, Comparator<ExtensionMeta<T, M>> comparator, Classify<T, M> classify) {
        this.name = name;
        this.metas = new LinkedList<ExtensionMeta<T, M>>();
        this.names = new ConcurrentHashMap<M, ExtensionMeta<T, M>>(metas.size());
        this.multiNames = new ConcurrentHashMap<M, List<ExtensionMeta<T, M>>>(metas.size());
        this.providers = new ConcurrentHashMap<String, ExtensionMeta<T, M>>(metas.size());
        this.comparator = comparator;
        this.classify = classify;
        for (ExtensionMeta<T, M> meta : metas) {
            this.add(meta);
        }
    }

    protected void add(ExtensionMeta<T, M> meta) {
        M name;
        if (meta == null) {
            return;
        }
        if (!meta.isSingleton()) {
            this.singleton = false;
        }
        if ((name = meta.getExtension().getName()) != null) {
            this.names.putIfAbsent(name, meta);
            List<ExtensionMeta<T, M>> metas = Maps.computeIfAbsent(this.multiNames, name, new Maps.Function<M, List<ExtensionMeta<T, M>>>(){

                @Override
                public List<ExtensionMeta<T, M>> apply(M t) {
                    return new CopyOnWriteArrayList();
                }
            });
            metas.add(meta);
            if (name instanceof String && meta.getProvider() != null && !meta.getProvider().isEmpty()) {
                this.providers.putIfAbsent(name + "@" + meta.getProvider(), meta);
            }
        }
        this.metas.add(meta);
    }

    protected T getObject(ExtensionMeta<T, M> extension) {
        return extension == null ? null : (T)extension.getTarget();
    }

    @Override
    public T get(M name) {
        return name == null ? null : (T)this.getObject(this.meta(name));
    }

    @Override
    public T get(M name, M option) {
        T result = this.get(name);
        return result != null ? result : this.get(option);
    }

    @Override
    public T getOrDefault(M name) {
        T result = this.get(name);
        return result != null ? result : this.get();
    }

    @Override
    public T get() {
        ExtensionMeta<T, M> meta;
        if (this.target == null && !this.metas.isEmpty() && (meta = this.metas.get(0)) != null) {
            if (meta.isSingleton()) {
                this.target = meta.getTarget();
            } else {
                return meta.getTarget();
            }
        }
        return this.target;
    }

    @Override
    public Iterable<ExtensionMeta<T, M>> metas() {
        return this.metas;
    }

    @Override
    public Iterable<ExtensionMeta<T, M>> metas(M name) {
        return name == null ? null : (List)this.multiNames.get(name);
    }

    @Override
    public ExtensionMeta<T, M> meta(M name) {
        String v;
        int pos;
        ExtensionMeta result = null;
        if (name != null && (result = (ExtensionMeta)this.names.get(name)) == null && name instanceof String && (result = (ExtensionMeta)this.providers.get(name)) == null && (pos = (v = (String)name).indexOf(64)) > 0) {
            result = (ExtensionMeta)this.names.get(name);
        }
        return result;
    }

    @Override
    public int size() {
        return this.metas.size();
    }

    protected List<T> doExtensions() {
        LinkedList<T> result = new LinkedList<T>();
        for (ExtensionMeta<T, M> extension : this.metas) {
            T object = this.getObject(extension);
            if (object == null) continue;
            result.add(object);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<T> extensions() {
        if (this.singleton) {
            if (this.extensions == null) {
                ExtensionSpi extensionSpi = this;
                synchronized (extensionSpi) {
                    if (this.extensions == null) {
                        this.extensions = this.doExtensions();
                    }
                }
            }
            return this.extensions;
        }
        return this.doExtensions();
    }

    protected List<T> doReverses() {
        LinkedList<T> result = new LinkedList<T>();
        for (ExtensionMeta<T, M> extension : this.metas) {
            T object = this.getObject(extension);
            if (object == null) continue;
            result.addFirst(object);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<T> reverse() {
        if (this.singleton) {
            if (this.reverses == null) {
                ExtensionSpi extensionSpi = this;
                synchronized (extensionSpi) {
                    if (this.reverses == null) {
                        this.reverses = this.doReverses();
                    }
                }
            }
            return this.reverses;
        }
        return this.doReverses();
    }

    @Override
    public Name<T, String> getName() {
        return this.name;
    }
}

