/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.extension;

import com.jd.laf.extension.ExtensionMeta;
import com.jd.laf.extension.ExtensionPoint;
import com.jd.laf.extension.Option;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public interface Selector<T, M, C, K> {
    public K select(ExtensionPoint<T, M> var1, C var2);

    public static class CacheSelector<T, M, C, K>
    implements Selector<T, M, C, K> {
        protected ConcurrentMap<C, Option<K>> cache = new ConcurrentHashMap<C, Option<K>>();
        protected Selector<T, M, C, K> delegate;

        public CacheSelector(Selector<T, M, C, K> delegate) {
            this.delegate = delegate;
        }

        @Override
        public K select(ExtensionPoint<T, M> extensions, C condition) {
            if (condition == null) {
                return null;
            }
            K result = this.before(condition);
            if (result != null) {
                return result;
            }
            Option<K> option = (Option<K>)this.cache.get(condition);
            if (option == null) {
                Option<K> exists;
                result = this.delegate.select(extensions, condition);
                if (result == null) {
                    result = this.fail(condition);
                }
                if ((exists = this.cache.putIfAbsent(condition, option = new Option<K>(result))) != null) {
                    option = exists;
                }
            }
            return (K)option.get();
        }

        protected K before(C condition) {
            return null;
        }

        protected K fail(C condition) {
            return null;
        }
    }

    public static abstract class ConverterSelector<T, M, C, K>
    implements Selector<T, M, C, K> {
        @Override
        public K select(ExtensionPoint<T, M> extensions, C condition) {
            for (ExtensionMeta<T, M> meta : extensions.metas()) {
                K result;
                T target = meta.getTarget();
                if (target == null || (result = this.convert(target, condition)) == null) continue;
                return result;
            }
            return null;
        }

        protected abstract K convert(T var1, C var2);
    }

    public static abstract class ListSelector<T, M, C>
    implements Selector<T, M, C, List<T>> {
        @Override
        public List<T> select(ExtensionPoint<T, M> extensions, C condition) {
            LinkedList<T> result = new LinkedList<T>();
            for (ExtensionMeta<T, M> meta : extensions.metas()) {
                T target = meta.getTarget();
                if (target == null || !this.match(target, condition)) continue;
                result.add(target);
            }
            return result;
        }

        protected abstract boolean match(T var1, C var2);
    }

    public static abstract class MatchSelector<T, M, C>
    implements Selector<T, M, C, T> {
        @Override
        public T select(ExtensionPoint<T, M> extensions, C condition) {
            for (ExtensionMeta<T, M> meta : extensions.metas()) {
                T target = meta.getTarget();
                if (target == null || !this.match(target, condition)) continue;
                return target;
            }
            return null;
        }

        protected abstract boolean match(T var1, C var2);
    }
}

