/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.extension;

import com.jd.laf.extension.Converts;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public final class URL
implements Serializable {
    private static final long serialVersionUID = -1985165475234910535L;
    public static final String FILE = "file";
    public static final String UTF_8 = "UTF-8";
    protected final String protocol;
    protected final String user;
    protected final String password;
    protected final String host;
    protected final int port;
    protected final String path;
    protected final Map<String, String> parameters;

    protected URL() {
        this.protocol = null;
        this.user = null;
        this.password = null;
        this.host = null;
        this.port = 0;
        this.path = null;
        this.parameters = null;
    }

    public URL(String protocol, String host, int port) {
        this(protocol, null, null, host, port, null, null);
    }

    public URL(String protocol, String host, int port, Map<String, String> parameters) {
        this(protocol, null, null, host, port, null, parameters);
    }

    public URL(String protocol, String host, int port, String path) {
        this(protocol, null, null, host, port, path, null);
    }

    public URL(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, null, null, host, port, path, parameters);
    }

    public URL(String protocol, String user, String password, String host, int port, String path) {
        this(protocol, user, password, host, port, path, null);
    }

    public URL(String protocol, String user, String password, String host, int port, String path, Map<String, String> parameters) {
        this.protocol = protocol;
        this.user = user;
        this.password = password;
        this.host = host;
        this.port = port < 0 ? 0 : port;
        this.path = path;
        this.parameters = Collections.unmodifiableMap(parameters == null ? new HashMap(0) : new HashMap<String, String>(parameters));
    }

    public static URL valueOf(String url) {
        if (url == null) {
            return null;
        }
        if ((url = url.trim()).isEmpty()) {
            return null;
        }
        String protocol = null;
        String user = null;
        String password = null;
        String host = null;
        int port = 0;
        String path = null;
        HashMap<String, String> parameters = null;
        int j = 0;
        int i = url.indexOf(41);
        i = i >= 0 ? url.indexOf(63, i) : url.indexOf("?");
        if (i >= 0) {
            if (i < url.length() - 1) {
                String[] parts = url.substring(i + 1).split("&");
                parameters = new HashMap<String, String>();
                for (String part : parts) {
                    if ((part = part.trim()).isEmpty()) continue;
                    j = part.indexOf(61);
                    if (j > 0) {
                        if (j == part.length() - 1) {
                            parameters.put(part.substring(0, j), "");
                            continue;
                        }
                        parameters.put(part.substring(0, j), part.substring(j + 1));
                        continue;
                    }
                    if (j != -1) continue;
                    parameters.put(part, part);
                }
            }
            url = url.substring(0, i);
        }
        if ((i = url.indexOf("://")) > 0) {
            protocol = url.substring(0, i);
            url = url.substring(i + 3);
        } else if (i < 0 && (i = url.indexOf(":/")) > 0) {
            protocol = url.substring(0, i);
            url = url.substring(i + 2);
        }
        if (protocol == null || protocol.isEmpty()) {
            throw new IllegalStateException("url missing protocol: " + url);
        }
        if (protocol.equals(FILE)) {
            path = url;
            url = "";
        } else {
            i = url.lastIndexOf(41);
            i = i >= 0 ? url.indexOf(47, i) : url.indexOf("/");
            if (i >= 0) {
                path = url.substring(i + 1);
                url = url.substring(0, i);
            }
        }
        i = url.indexOf(40);
        if (i >= 0) {
            j = url.lastIndexOf(41);
            url = j >= 0 ? url.substring(i + 1, j) : url.substring(i + 1);
        } else {
            String[] values;
            i = url.indexOf("@");
            if (i >= 0) {
                user = url.substring(0, i);
                j = user.indexOf(":");
                if (j >= 0) {
                    password = user.substring(j + 1);
                    user = user.substring(0, j);
                }
                url = url.substring(i + 1);
            }
            if ((values = url.split(":")).length == 2) {
                port = Integer.parseInt(values[1]);
                url = values[0];
            }
        }
        if (!url.isEmpty()) {
            host = url;
        }
        return new URL(protocol, user, password, host, port, path, parameters);
    }

    public static String encode(String value) throws UnsupportedEncodingException {
        return URL.encode(value, UTF_8);
    }

    public static String encode(String value, String charset) throws UnsupportedEncodingException {
        if (value == null || value.isEmpty()) {
            return "";
        }
        return URLEncoder.encode(value, charset);
    }

    public static String decode(String value) throws UnsupportedEncodingException {
        return URL.decode(value, UTF_8);
    }

    public static String decode(String value, String charset) throws UnsupportedEncodingException {
        if (value == null || value.isEmpty()) {
            return "";
        }
        return URLDecoder.decode(value, charset == null || charset.isEmpty() ? UTF_8 : charset);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public URL setProtocol(String protocol) {
        return new URL(protocol, this.user, this.password, this.host, this.port, this.path, this.parameters);
    }

    public String getUser() {
        return this.user;
    }

    public URL setUser(String user) {
        return new URL(this.protocol, user, this.password, this.host, this.port, this.path, this.parameters);
    }

    public String getPassword() {
        return this.password;
    }

    public URL setPassword(String password) {
        return new URL(this.protocol, this.user, password, this.host, this.port, this.path, this.parameters);
    }

    public String getHost() {
        return this.host;
    }

    public URL setHost(String host) {
        return new URL(this.protocol, this.user, this.password, host, this.port, this.path, this.parameters);
    }

    public int getPort() {
        return this.port;
    }

    public URL setPort(int port) {
        return new URL(this.protocol, this.user, this.password, this.host, port, this.path, this.parameters);
    }

    public String getAddress() {
        return this.port <= 0 ? this.host : this.host + ":" + this.port;
    }

    public URL setAddress(String address) {
        String host;
        int i = address.lastIndexOf(58);
        int port = this.port;
        if (i >= 0) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
        }
        return new URL(this.protocol, this.user, this.password, host, port, this.path, this.parameters);
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String getPath() {
        return this.path;
    }

    public URL setPath(String path) {
        return new URL(this.protocol, this.user, this.password, this.host, this.port, path, this.parameters);
    }

    public String getAbsolutePath() {
        if (this.path == null) {
            return null;
        }
        char first = this.path.charAt(0);
        if (first == '/') {
            return this.path;
        }
        if ((first > 'a' && first < 'z' || first > 'A' && first < 'Z') && this.path.length() >= 3) {
            char second = this.path.charAt(1);
            char third = this.path.charAt(2);
            if (second == ':' && (third == '/' || third == '\\')) {
                return this.path;
            }
        }
        return "/" + this.path;
    }

    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this.parameters);
    }

    public Object getObject(String key) {
        return this.getString(key);
    }

    public String getString(String key) {
        return this.parameters.get(key);
    }

    public String getString(String key, String def) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return def;
        }
        return value;
    }

    public String getDecoded(String key) throws UnsupportedEncodingException {
        return URL.decode(this.getString(key));
    }

    public String getDecoded(String key, String charset) throws UnsupportedEncodingException {
        return URL.decode(this.getString(key), charset);
    }

    public String getDecoded(String key, String def, String charset) throws UnsupportedEncodingException {
        return this.getDecoded(this.getString(key, def), charset);
    }

    public Date getDate(String key, Date def) {
        return Converts.getDate((Object)this.getString(key), def);
    }

    public Date getDate(String key, SimpleDateFormat format) {
        return Converts.getDate((Object)this.getString(key), format, null);
    }

    public Date getDate(String key, SimpleDateFormat format, Date def) {
        return Converts.getDate((Object)this.getString(key), format, def);
    }

    public Float getFloat(String key) {
        return Converts.getFloat(this.getString(key), null);
    }

    public Float getFloat(String key, Float def) {
        return Converts.getFloat(this.getString(key), def);
    }

    public Double getDouble(String key) {
        return Converts.getDouble(this.getString(key), null);
    }

    public Double getDouble(String key, Double def) {
        return Converts.getDouble(this.getString(key), def);
    }

    public Long getLong(String key) {
        return Converts.getLong(this.getString(key), null);
    }

    public Long getLong(String key, Long def) {
        return Converts.getLong(this.getString(key), def);
    }

    public Integer getInteger(String key) {
        return Converts.getInteger(this.getString(key), null);
    }

    public Integer getInteger(String key, Integer def) {
        return Converts.getInteger(this.getString(key), def);
    }

    public Short getShort(String key) {
        return Converts.getShort(this.getString(key), null);
    }

    public Short getShort(String key, Short def) {
        return Converts.getShort(this.getString(key), def);
    }

    public Byte getByte(String key) {
        return Converts.getByte(this.getString(key), null);
    }

    public Byte getByte(String key, Byte def) {
        return Converts.getByte(this.getString(key), def);
    }

    public Boolean getBoolean(String key) {
        return Converts.getBoolean(this.getString(key), null);
    }

    public Boolean getBoolean(String key, Boolean def) {
        return Converts.getBoolean(this.getString(key), def);
    }

    public Long getNatural(String key, Long def) {
        return Converts.getNatural((Object)this.getString(key), def);
    }

    public Integer getNatural(String key, Integer def) {
        return Converts.getNatural((Object)this.getString(key), def);
    }

    public Short getNatural(String key, Short def) {
        return Converts.getNatural((Object)this.getString(key), def);
    }

    public Byte getNatural(String key, Byte def) {
        return Converts.getNatural((Object)this.getString(key), def);
    }

    public Long getPositive(String key, Long def) {
        return Converts.getPositive((Object)this.getString(key), def);
    }

    public Integer getPositive(String key, Integer def) {
        return Converts.getPositive((Object)this.getString(key), def);
    }

    public Short getPositive(String key, Short def) {
        return Converts.getPositive((Object)this.getString(key), def);
    }

    public Byte getPositive(String key, Byte def) {
        return Converts.getPositive((Object)this.getString(key), def);
    }

    public boolean contains(String key) {
        String value = this.getString(key);
        return value != null && !value.isEmpty();
    }

    public URL add(String key, boolean value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, char value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, byte value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, short value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, int value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, long value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, float value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, double value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, Number value) {
        return this.add(key, value == null ? (String)null : String.valueOf(value));
    }

    public URL add(String key, CharSequence value) {
        return this.add(key, value == null ? (String)null : value.toString());
    }

    public URL add(String key, String value) {
        if (key == null || key.isEmpty()) {
            return this;
        }
        Map<String, String> map = this.getParameters();
        map.put(key, value);
        return new URL(this.protocol, this.user, this.password, this.host, this.port, this.path, map);
    }

    public URL add(URL url) {
        if (url == null || url.parameters.isEmpty()) {
            return this;
        }
        Map<String, String> map = this.getParameters();
        map.putAll(url.parameters);
        return new URL(this.protocol, this.user, this.password, this.host, this.port, this.path, map);
    }

    public URL add(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return this;
        }
        Map<String, String> map = this.getParameters();
        map.putAll(parameters);
        return new URL(this.protocol, this.user, this.password, this.host, this.port, this.path, map);
    }

    public URL addEncoded(String key, String value) throws UnsupportedEncodingException {
        return this.add(key, URL.encode(value));
    }

    public URL addEncoded(String key, String value, String charset) throws UnsupportedEncodingException {
        return this.add(key, URL.encode(value, charset));
    }

    public URL addEncoded(String key, CharSequence value) throws UnsupportedEncodingException {
        return this.add(key, URL.encode(value == null ? null : value.toString()));
    }

    public URL addEncoded(String key, CharSequence value, String charset) throws UnsupportedEncodingException {
        return this.add(key, URL.encode(value == null ? null : value.toString(), charset));
    }

    public URL addIfAbsent(String key, boolean value) {
        return this.addIfAbsent(key, String.valueOf(value));
    }

    public URL addIfAbsent(String key, char value) {
        return this.addIfAbsent(key, String.valueOf(value));
    }

    public URL addIfAbsent(String key, byte value) {
        return this.addIfAbsent(key, String.valueOf(value));
    }

    public URL addIfAbsent(String key, short value) {
        return this.addIfAbsent(key, String.valueOf(value));
    }

    public URL addIfAbsent(String key, int value) {
        return this.addIfAbsent(key, String.valueOf(value));
    }

    public URL addIfAbsent(String key, long value) {
        return this.addIfAbsent(key, String.valueOf(value));
    }

    public URL addIfAbsent(String key, float value) {
        return this.addIfAbsent(key, String.valueOf(value));
    }

    public URL addIfAbsent(String key, double value) {
        return this.addIfAbsent(key, String.valueOf(value));
    }

    public URL addIfAbsent(String key, Number value) {
        return this.addIfAbsent(key, value == null ? (String)null : String.valueOf(value));
    }

    public URL addIfAbsent(String key, CharSequence value) {
        return this.addIfAbsent(key, value == null ? (String)null : value.toString());
    }

    public URL addIfAbsent(String key, String value) {
        if (key == null || key.isEmpty() || value == null || value.isEmpty() || this.contains(key)) {
            return this;
        }
        Map<String, String> map = this.getParameters();
        map.put(key, value);
        return new URL(this.protocol, this.user, this.password, this.host, this.port, this.path, map);
    }

    public URL addIfAbsent(URL url) {
        if (url == null || url.parameters.isEmpty()) {
            return this;
        }
        Map<String, String> map = url.getParameters();
        map.putAll(this.parameters);
        return new URL(this.protocol, this.user, this.password, this.host, this.port, this.path, map);
    }

    public URL addIfAbsent(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(parameters);
        map.putAll(this.parameters);
        return new URL(this.protocol, this.user, this.password, this.host, this.port, this.path, map);
    }

    public URL remove(String key) {
        if (key == null || key.isEmpty()) {
            return this;
        }
        return this.remove(key);
    }

    public URL remove(Collection<String> keys) {
        if (keys == null || keys.size() == 0) {
            return this;
        }
        return this.remove(keys.toArray(new String[keys.size()]));
    }

    public URL remove(String ... keys) {
        if (keys == null || keys.length == 0) {
            return this;
        }
        Map<String, String> map = this.getParameters();
        for (String key : keys) {
            map.remove(key);
        }
        if (this.parameters.size() == map.size()) {
            return this;
        }
        return new URL(this.protocol, this.user, this.password, this.host, this.port, this.path, map);
    }

    public URL remove() {
        return new URL(this.protocol, this.user, this.password, this.host, this.port, this.path, new HashMap<String, String>());
    }

    public String toString() {
        return this.toString(false, true, new String[0]);
    }

    public String toString(boolean user, boolean parameter, String ... parameters) {
        StringBuilder buf = new StringBuilder();
        if (this.protocol != null && !this.protocol.isEmpty()) {
            buf.append(this.protocol).append("://");
        }
        if (user && this.user != null && !this.user.isEmpty()) {
            buf.append(this.user);
            if (this.password != null && !this.password.isEmpty()) {
                buf.append(':').append(this.password);
            }
            buf.append('@');
        }
        boolean address = false;
        if (this.host != null && !this.host.isEmpty()) {
            address = true;
            buf.append(this.host);
            if (this.port > 0) {
                buf.append(':').append(this.port);
            }
        }
        if (this.path != null && !this.path.isEmpty()) {
            if (address) {
                buf.append('/');
            }
            buf.append(this.path);
        }
        if (parameter) {
            this.append(buf, true, parameters);
        }
        return buf.toString();
    }

    protected void append(StringBuilder buf, boolean concat, String[] parameters) {
        Map<String, String> map = this.parameters;
        if (map != null && !map.isEmpty()) {
            HashSet<String> includes = parameters == null || parameters.length == 0 ? null : new HashSet<String>(Arrays.asList(parameters));
            boolean first = true;
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(map).entrySet()) {
                String key = entry.getKey();
                if (key == null || key.length() <= 0 || includes != null && !includes.contains(key)) continue;
                if (first) {
                    if (concat) {
                        buf.append('?');
                    }
                    first = false;
                } else {
                    buf.append('&');
                }
                buf.append(key).append('=');
                if (entry.getValue() == null) continue;
                buf.append(entry.getValue().trim());
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URL other = (URL)obj;
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

