/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BannerPrinter {
    protected static final Logger logger = LoggerFactory.getLogger(BannerPrinter.class);
    private static final String BANNER_RESOURCE = "joyqueue/banner";
    private static final String VERSION_RESOURCE = "joyqueue/version.properties";
    private static final String PLACEHOLDER_PREFIX = "{";
    private static final String PLACEHOLDER_SUFFIX = "}";

    public static void print() {
        InputStream inputStream = BannerPrinter.class.getClassLoader().getResourceAsStream(BANNER_RESOURCE);
        if (inputStream == null) {
            logger.warn("banner not exist, resource: {}", (Object)BANNER_RESOURCE);
            return;
        }
        try {
            String banner = IOUtils.toString((InputStream)inputStream);
            Properties params = BannerPrinter.buildParams();
            banner = BannerPrinter.render(banner, params);
            BannerPrinter.print(System.out, banner);
        }
        catch (IOException e) {
            logger.warn("print banner exception", (Throwable)e);
        }
    }

    protected static Properties buildParams() {
        InputStream versionStream = BannerPrinter.class.getClassLoader().getResourceAsStream(VERSION_RESOURCE);
        Properties params = new Properties();
        try {
            if (versionStream != null) {
                params.load(versionStream);
            }
        }
        catch (IOException e) {
            logger.warn("load version exception", (Throwable)e);
        }
        return params;
    }

    protected static String render(String banner, Properties params) {
        for (String key : params.stringPropertyNames()) {
            banner = banner.replace(PLACEHOLDER_PREFIX + key + PLACEHOLDER_SUFFIX, params.getProperty(key));
        }
        return banner;
    }

    protected static void print(PrintStream stream, String banner) throws IOException {
        stream.write(banner.getBytes());
    }
}

