/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.Plugins;
import org.joyqueue.broker.archive.ArchiveManager;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.cluster.ClusterNameService;
import org.joyqueue.broker.config.BrokerConfig;
import org.joyqueue.broker.config.BrokerStoreConfig;
import org.joyqueue.broker.config.Configuration;
import org.joyqueue.broker.config.ConfigurationManager;
import org.joyqueue.broker.config.scan.ClassScanner;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.MessageConvertSupport;
import org.joyqueue.broker.coordinator.CoordinatorService;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.event.BrokerEventBus;
import org.joyqueue.broker.extension.ExtensionManager;
import org.joyqueue.broker.helper.AwareHelper;
import org.joyqueue.broker.manage.BrokerManageService;
import org.joyqueue.broker.manage.config.BrokerManageConfig;
import org.joyqueue.broker.monitor.BrokerMonitorService;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.monitor.config.BrokerMonitorConfig;
import org.joyqueue.broker.network.BrokerServer;
import org.joyqueue.broker.network.protocol.ProtocolManager;
import org.joyqueue.broker.producer.Produce;
import org.joyqueue.broker.retry.BrokerRetryManager;
import org.joyqueue.broker.store.StoreInitializer;
import org.joyqueue.broker.store.StoreManager;
import org.joyqueue.domain.Config;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.Producer;
import org.joyqueue.helper.PortHelper;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.nameservice.CompensatedNameService;
import org.joyqueue.security.Authentication;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerService
extends Service {
    private static final Logger logger = LoggerFactory.getLogger(BrokerService.class);
    private static final String NAMESERVICE_NAME = "nameserver.nsr.name";
    private static final String DEFAULT_NAMESERVICE_NAME = "server";
    private BrokerConfig brokerConfig;
    private SessionManager sessionManager;
    private BrokerMonitorService brokerMonitorService;
    private BrokerManageService brokerManageService;
    private Authentication authentication;
    private ProtocolManager protocolManager;
    private BrokerServer brokerServer;
    private ClusterNameService clusterNameService;
    private ClusterManager clusterManager;
    private Produce produce;
    private Consume consume;
    private StoreService storeService;
    private StoreInitializer storeInitializer;
    private ElectionService electionService;
    private MessageRetry retryManager;
    private BrokerContext brokerContext;
    private ConfigurationManager configurationManager;
    private StoreManager storeManager;
    private NameService nameService;
    private CoordinatorService coordinatorService;
    private ArchiveManager archiveManager;
    private MessageConvertSupport messageConvertSupport;
    private ExtensionManager extensionManager;
    private BrokerEventBus brokerEventBus;
    private String[] args;

    public BrokerService() {
    }

    public BrokerService(String[] args) {
        this.args = args;
    }

    protected void validate() throws Exception {
        this.brokerContext = new BrokerContext();
        this.configurationManager = new ConfigurationManager(this.args);
        this.configurationManager.start();
        Configuration configuration = this.configurationManager.getConfiguration();
        this.enrichServicePorts(configuration);
        this.brokerContext.propertySupplier(configuration);
        this.brokerEventBus = new BrokerEventBus(this.brokerContext);
        this.brokerContext.eventBus(this.brokerEventBus);
        this.brokerConfig = new BrokerConfig(configuration);
        String dataPath = this.brokerConfig.getAndCreateDataPath();
        logger.info("Broker data path: {}.", (Object)dataPath);
        this.brokerContext.brokerConfig(this.brokerConfig);
        this.extensionManager = new ExtensionManager(this.brokerContext);
        this.extensionManager.before();
        this.nameService = this.getNameService(this.brokerContext, configuration);
        this.brokerContext.nameService(this.nameService);
        this.nameService.addListener((EventListener)this.configurationManager);
        this.configurationManager.setConfigProvider(new ConfigProviderImpl(this.nameService));
        this.clusterNameService = new ClusterNameService(this.nameService, this.brokerEventBus, configuration);
        this.clusterNameService.start();
        this.brokerContext.clusterNameService(this.clusterNameService);
        this.clusterManager = new ClusterManager(this.brokerConfig, this.nameService, this.clusterNameService, this.brokerContext);
        this.clusterManager.start();
        this.brokerContext.clusterManager(this.clusterManager);
        this.storeService = this.getStoreService(this.brokerContext);
        this.brokerContext.storeService(this.storeService);
        this.sessionManager = new SessionManager();
        this.brokerContext.sessionManager(this.sessionManager);
        this.authentication = this.getAuthentication(this.brokerContext);
        this.brokerContext.authentication(this.authentication);
        this.brokerMonitorService = new BrokerMonitorService(this.clusterManager.getBrokerId(), new BrokerMonitorConfig(configuration, this.brokerConfig), this.sessionManager, this.clusterManager);
        this.brokerContext.brokerMonitorService(this.brokerMonitorService);
        this.coordinatorService = new CoordinatorService(configuration, this.clusterManager, this.nameService);
        this.brokerContext.coordinnatorService(this.coordinatorService);
        this.messageConvertSupport = new MessageConvertSupport();
        this.brokerContext.messageConvertSupport(this.messageConvertSupport);
        this.produce = this.getProduce(this.brokerContext);
        this.brokerContext.produce(this.produce);
        this.retryManager = this.getMessageRetry(this.brokerContext);
        if (null != this.retryManager) {
            this.retryManager.setSupplier((PropertySupplier)configuration);
        }
        this.brokerContext.retryManager(this.retryManager);
        this.archiveManager = new ArchiveManager(this.brokerContext);
        this.brokerContext.archiveManager(this.archiveManager);
        this.consume = this.getConsume(this.brokerContext);
        this.brokerContext.consume(this.consume);
        this.electionService = this.getElectionService(this.brokerContext);
        this.brokerContext.electionService(this.electionService);
        this.storeInitializer = new StoreInitializer(new BrokerStoreConfig(configuration), this.nameService, this.clusterManager, this.storeService, this.electionService);
        this.brokerManageService = new BrokerManageService(new BrokerManageConfig(configuration, this.brokerConfig), this.brokerMonitorService, this.clusterManager, this.clusterNameService, this.storeService.getManageService(), this.storeService, this.consume, this.retryManager, this.coordinatorService, this.archiveManager, this.nameService, this.electionService, this.messageConvertSupport);
        this.brokerContext.brokerManageService(this.brokerManageService);
        this.storeManager = new StoreManager(this.storeService, this.nameService, this.clusterManager, this.electionService);
        this.enrichIfNecessary(this.storeManager, this.brokerContext);
        this.protocolManager = new ProtocolManager(this.brokerContext);
        this.brokerServer = new BrokerServer(this.brokerContext, this.protocolManager);
        this.brokerContext.producerPolicy(this.buildGlobalProducePolicy(configuration));
        this.brokerContext.consumerPolicy(this.buildGlobalConsumePolicy(configuration));
        this.extensionManager.after();
        this.enrichConfiguration(configuration);
    }

    private void enrichServicePorts(Configuration configuration) {
        String key = "broker.frontend-server.transport.server.port";
        Property basePortProperty = configuration.getOrCreateProperty(key);
        int port = 50088;
        try {
            port = basePortProperty.getInteger();
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        configuration.addProperty(key, String.valueOf(port));
        key = "broker.backend-server.transport.server.port";
        configuration.addProperty(key, String.valueOf(PortHelper.getBackendPort((int)port)));
    }

    private void enrichConfiguration(Configuration configuration) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, IOException {
        Map<String, String> configMap = this.getEnumConstantsConfig();
        for (Map.Entry<String, String> entry : configMap.entrySet()) {
            if (configuration.contains(entry.getKey()) || entry.getKey().endsWith(".")) continue;
            configuration.addProperty(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> getEnumConstantsConfig() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, IOException {
        HashMap<String, String> configMap = new HashMap<String, String>(10);
        Set<Class<?>> classes = ClassScanner.defaultSearch();
        for (Class<?> clazz : classes) {
            Object[] values;
            Method method;
            List<Class<?>> impls = Arrays.asList(clazz.getInterfaces());
            if (!impls.contains(PropertyDef.class) || !clazz.isEnum() || !(method = clazz.getMethod("values", new Class[0])).getReturnType().isArray()) continue;
            for (Object obj : values = (Object[])method.invoke(null, new Object[0])) {
                if (!(obj instanceof PropertyDef)) continue;
                PropertyDef propertyDef = (PropertyDef)obj;
                configMap.put(propertyDef.getName(), String.valueOf(propertyDef.getValue()));
            }
        }
        return configMap;
    }

    private NameService getNameService(BrokerContext brokerContext, Configuration configuration) {
        Property property = configuration.getProperty(NAMESERVICE_NAME);
        NameService nameService = (NameService)Plugins.NAMESERVICE.get((Object)(property == null ? DEFAULT_NAMESERVICE_NAME : property.getString().trim()));
        Preconditions.checkArgument((nameService != null ? 1 : 0) != 0, (Object)"nameService not found!");
        CompensatedNameService compensatedNameService = new CompensatedNameService(nameService);
        this.enrichIfNecessary(nameService, brokerContext);
        this.enrichIfNecessary(compensatedNameService, brokerContext);
        return compensatedNameService;
    }

    private StoreService getStoreService(BrokerContext brokerContext) {
        StoreService storeService = (StoreService)Plugins.STORE.get();
        Preconditions.checkArgument((storeService != null ? 1 : 0) != 0, (Object)"store service not found!");
        this.enrichIfNecessary(storeService, brokerContext);
        return storeService;
    }

    private Authentication getAuthentication(BrokerContext brokerContext) {
        Authentication authentication = (Authentication)Plugins.AUTHENTICATION.get();
        Preconditions.checkArgument((authentication != null ? 1 : 0) != 0, (Object)"authentication can  not be null");
        this.enrichIfNecessary(authentication, brokerContext);
        return authentication;
    }

    private Produce getProduce(BrokerContext brokerContext) {
        Produce produce = (Produce)Plugins.PRODUCE.get();
        Preconditions.checkArgument((produce != null ? 1 : 0) != 0, (Object)"produce can not be null");
        this.enrichIfNecessary(produce, brokerContext);
        return produce;
    }

    private MessageRetry getMessageRetry(BrokerContext brokerContext) {
        BrokerRetryManager messageRetry = new BrokerRetryManager(brokerContext);
        return messageRetry;
    }

    private Consume getConsume(BrokerContext brokerContext) {
        Consume consume = (Consume)Plugins.CONSUME.get();
        Preconditions.checkArgument((consume != null ? 1 : 0) != 0, (Object)"consume can not be null");
        this.enrichIfNecessary(consume, brokerContext);
        return consume;
    }

    private ElectionService getElectionService(BrokerContext brokerContext) {
        ElectionService electionService = (ElectionService)Plugins.ELECTION.get();
        Preconditions.checkArgument((electionService != null ? 1 : 0) != 0, (Object)"election service can not be null");
        this.enrichIfNecessary(electionService, brokerContext);
        return electionService;
    }

    private Consumer.ConsumerPolicy buildGlobalConsumePolicy(PropertySupplier propertySupplier) {
        return new Consumer.ConsumerPolicy.Builder().create();
    }

    private Producer.ProducerPolicy buildGlobalProducePolicy(PropertySupplier propertySupplier) {
        return new Producer.ProducerPolicy.Builder().create();
    }

    protected void doStart() throws Exception {
        this.startIfNecessary((Object)this.brokerEventBus);
        this.startIfNecessary((Object)this.clusterNameService);
        this.startIfNecessary((Object)this.clusterManager);
        this.startIfNecessary(this.storeService);
        this.startIfNecessary((Object)this.storeInitializer);
        this.startIfNecessary((Object)this.sessionManager);
        this.startIfNecessary(this.retryManager);
        this.startIfNecessary((Object)this.brokerMonitorService);
        this.startIfNecessary(this.produce);
        this.startIfNecessary(this.consume);
        this.startIfNecessary(this.storeManager);
        this.startIfNecessary(this.electionService);
        this.startIfNecessary((Object)this.extensionManager);
        this.startIfNecessary((Object)this.protocolManager);
        this.startIfNecessary(this.nameService);
        this.startIfNecessary((Object)this.archiveManager);
        this.startIfNecessary((Object)this.brokerServer);
        this.startIfNecessary((Object)this.coordinatorService);
        this.startIfNecessary((Object)this.brokerManageService);
        this.printConfig();
    }

    private void printConfig() {
        StringBuilder buffer = new StringBuilder("broker start with configuration:").append('\n');
        if (this.configurationManager != null && this.configurationManager.getConfiguration() != null) {
            ArrayList<Property> properties = new ArrayList<Property>(this.configurationManager.getConfiguration().getProperties());
            Collections.sort(properties, Comparator.comparing(Property::getKey));
            for (Property property : properties) {
                String value = property.getValue() == null ? "null" : property.getValue().toString();
                buffer.append('\t').append(property.getKey()).append(": ").append(value).append('\n');
            }
        }
        logger.info(buffer.toString());
        logger.info("broker.id[{}],ip[{}],frontPort[{}],backendPort[{}],monitorPort[{}],nameServerManager port[{}],nameServer port[{}],messenger port[{}],journalkeeper port[{}]", new Object[]{this.brokerConfig.getBrokerId(), this.clusterManager.getBroker().getIp(), this.brokerConfig.getFrontendConfig().getPort(), this.brokerConfig.getBackendConfig().getPort(), this.brokerConfig.getBroker().getMonitorPort(), this.brokerConfig.getBroker().getNameServerManagerPort(), this.brokerConfig.getBroker().getNameServerPort(), this.brokerConfig.getBroker().getMessengerPort(), this.brokerConfig.getBroker().getJournalkeeperPort()});
    }

    protected void doStop() {
        this.destroy((Object)this.brokerServer);
        this.destroy((Object)this.protocolManager);
        this.destroy((Object)this.extensionManager);
        this.destroy(this.electionService);
        this.destroy(this.produce);
        this.destroy(this.consume);
        this.destroy((Object)this.coordinatorService);
        this.destroy((Object)this.sessionManager);
        this.destroy((Object)this.clusterManager);
        this.destroy((Object)this.clusterNameService);
        this.destroy(this.storeManager);
        this.destroy((Object)this.storeInitializer);
        this.destroy(this.storeService);
        this.destroy((Object)this.configurationManager);
        this.destroy(this.retryManager);
        this.destroy((Object)this.archiveManager);
        this.destroy((Object)this.brokerMonitorService);
        this.destroy((Object)this.brokerManageService);
        this.destroy(this.nameService);
        this.destroy((Object)this.brokerEventBus);
        logger.info("Broker stopped!!!!");
    }

    public void enrichIfNecessary(Object obj, BrokerContext brokerContext) {
        AwareHelper.enrichIfNecessary(obj, brokerContext);
    }

    private void startIfNecessary(Object object) throws Exception {
        if (object instanceof LifeCycle && !((LifeCycle)object).isStarted()) {
            ((LifeCycle)object).start();
        }
    }

    private void destroy(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof LifeCycle) {
            Close.close((LifeCycle)((LifeCycle)object));
        }
        if (object instanceof Closeable) {
            Close.close((Closeable)((Closeable)object));
        }
    }

    public BrokerContext getBrokerContext() {
        return this.brokerContext;
    }

    private class ConfigProviderImpl
    implements ConfigurationManager.ConfigProvider {
        private NameService nameService;

        ConfigProviderImpl(NameService nameService) {
            this.nameService = nameService;
        }

        @Override
        public List<Config> getConfigs() {
            return this.nameService.getAllConfigs();
        }

        @Override
        public String getConfig(String group, String key) {
            return this.nameService.getConfig(group, key);
        }
    }
}

