/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.archive;

import org.joyqueue.broker.archive.ArchiveConfigKey;
import org.joyqueue.config.BrokerConfigKey;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;

public class ArchiveConfig {
    private static final String ARCHIVE_PATH = "/archive/";
    private PropertySupplier propertySupplier;
    private String archivePath;

    public ArchiveConfig() {
    }

    public ArchiveConfig(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArchivePath() {
        if (this.archivePath == null || this.archivePath.isEmpty()) {
            ArchiveConfig archiveConfig = this;
            synchronized (archiveConfig) {
                if (this.archivePath == null) {
                    String prefix = "";
                    if (this.propertySupplier != null) {
                        Property property = this.propertySupplier.getProperty("application.data.path");
                        prefix = property == null ? prefix : property.getString();
                    }
                    this.archivePath = prefix + ARCHIVE_PATH;
                }
            }
        }
        return this.archivePath;
    }

    public void setPath(String path) {
        if (path != null && !path.isEmpty()) {
            this.archivePath = path;
        }
    }

    public int getConsumeBatchNum() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ArchiveConfigKey.CONSUME_BATCH_NUM);
    }

    public int getConsumeWriteDelay() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ArchiveConfigKey.CONSUME_WRITE_DELAY);
    }

    public int getProduceBatchNum() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ArchiveConfigKey.PRODUCE_BATCH_NUM);
    }

    public int getLogQueueSize() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ArchiveConfigKey.LOG_QUEUE_SIZE);
    }

    public int getWriteThreadNum() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ArchiveConfigKey.WRITE_THREAD_NUM);
    }

    public boolean isStartArchive() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ArchiveConfigKey.ARCHIVE_SWITCH);
    }

    public int getThreadPoolQueueSize() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ArchiveConfigKey.ARCHIVE_THREAD_POOL_QUEUE_SIZE);
    }

    public String getNamespace() {
        return (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ArchiveConfigKey.ARCHIVE_STORE_NAMESPACE);
    }

    public String getTracerType() {
        return (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerConfigKey.TRACER_TYPE);
    }

    public boolean isReamingEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ArchiveConfigKey.ARCHIVE_REAMING_ENABLE);
    }

    public boolean isBacklogEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ArchiveConfigKey.ARCHIVE_BACKLOG_ENABLE);
    }
}

