/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.archive;

import java.util.Map;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.archive.ArchiveConfig;
import org.joyqueue.broker.archive.ConsumeArchiveService;
import org.joyqueue.broker.archive.ProduceArchiveService;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveManager
extends Service {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveManager.class);
    private BrokerContext context;
    private ProduceArchiveService sendArchiveService;
    private ConsumeArchiveService consumeArchiveService;
    private ArchiveConfig archiveConfig;

    public ArchiveManager(BrokerContext context) {
        this.context = context;
    }

    public ArchiveManager(ProduceArchiveService sendArchiveService, ConsumeArchiveService consumeArchiveService) {
        this.sendArchiveService = sendArchiveService;
        this.consumeArchiveService = consumeArchiveService;
    }

    public ProduceArchiveService getSendArchiveService() {
        return this.sendArchiveService;
    }

    public void setSendArchiveService(ProduceArchiveService sendArchiveService) {
        this.sendArchiveService = sendArchiveService;
    }

    public ConsumeArchiveService getConsumeArchiveService() {
        return this.consumeArchiveService;
    }

    public void setConsumeArchiveService(ConsumeArchiveService consumeArchiveService) {
        this.consumeArchiveService = consumeArchiveService;
    }

    protected void validate() throws Exception {
        super.validate();
        if (this.archiveConfig == null) {
            this.archiveConfig = new ArchiveConfig(this.context == null ? null : this.context.getPropertySupplier());
        }
        if (this.sendArchiveService == null) {
            this.sendArchiveService = new ProduceArchiveService(this.archiveConfig, this.context.getClusterManager(), this.context.getConsume(), this.context.getMessageConvertSupport());
        }
        if (this.consumeArchiveService == null) {
            this.consumeArchiveService = new ConsumeArchiveService(this.archiveConfig, this.context.getClusterManager());
        }
    }

    protected void doStart() throws Exception {
        if (this.archiveConfig.isStartArchive()) {
            super.doStart();
            this.sendArchiveService.start();
            this.consumeArchiveService.start();
            logger.info("archive manager started.");
        }
    }

    protected void doStop() {
        super.doStop();
        Close.close((LifeCycle)this.sendArchiveService);
        Close.close((LifeCycle)this.consumeArchiveService);
        logger.info("archive manager stopped.");
    }

    public long getSendBacklogNum() {
        return this.sendArchiveService.remainMessagesSum();
    }

    public long getConsumeBacklogNum() {
        return this.consumeArchiveService.getRemainConsumeLogFileNum();
    }

    public Map<String, Long> getSendBacklogNumByTopic() {
        return this.sendArchiveService.getArchivePosition();
    }
}

