/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.archive;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.server.archive.store.model.ConsumeLog;

public class ArchiveSerializer {
    private static ByteBufferPool byteBufferPool = new ByteBufferPool();

    public static void release(ByteBuffer byteBuffer) {
        byteBufferPool.release(byteBuffer);
    }

    public static ByteBuffer write(ConsumeLog consumeLog) {
        int size = ArchiveSerializer.consumeLogSize(consumeLog);
        ByteBuffer buffer = byteBufferPool.acquire(4 + size, false);
        buffer.putInt(size);
        buffer.put(consumeLog.getBytesMessageId());
        buffer.putInt(consumeLog.getBrokerId());
        byte[] clientIpBytes16 = new byte[16];
        byte[] clientIpBytes = consumeLog.getClientIp();
        System.arraycopy(clientIpBytes, 0, clientIpBytes16, 0, Math.min(clientIpBytes.length, clientIpBytes16.length));
        buffer.put(clientIpBytes16);
        buffer.putLong(consumeLog.getConsumeTime());
        byte[] appBytes = consumeLog.getApp().getBytes(Charset.forName("utf-8"));
        buffer.putShort((short)appBytes.length);
        buffer.put(appBytes);
        buffer.flip();
        return buffer;
    }

    private static int consumeLogSize(ConsumeLog consumeLog) {
        int size = 0;
        size += consumeLog.getBytesMessageId().length;
        size += 4;
        size += 16;
        size += 8;
        size += 2;
        return size += consumeLog.getApp().getBytes(Charset.forName("utf-8")).length;
    }

    public static ConsumeLog read(ByteBuffer buffer) {
        ConsumeLog log = new ConsumeLog();
        byte[] byteMessageId = new byte[16];
        buffer.get(byteMessageId);
        log.setBytesMessageId(byteMessageId);
        log.setBrokerId(buffer.getInt());
        byte[] clientIp = new byte[16];
        buffer.get(clientIp);
        log.setClientIp(clientIp);
        log.setConsumeTime(buffer.getLong());
        short appLen = buffer.getShort();
        byte[] appBytes = new byte[appLen];
        buffer.get(appBytes);
        log.setApp(new String(appBytes, Charset.forName("utf-8")));
        return log;
    }

    static class ByteBufferPool {
        private final ConcurrentMap<Integer, Queue<ByteBuffer>> directBuffers = new ConcurrentHashMap<Integer, Queue<ByteBuffer>>();
        private final ConcurrentMap<Integer, Queue<ByteBuffer>> heapBuffers = new ConcurrentHashMap<Integer, Queue<ByteBuffer>>();
        private final int factor;

        ByteBufferPool() {
            this(1024);
        }

        ByteBufferPool(int factor) {
            this.factor = factor;
        }

        public ByteBuffer acquire(int size, boolean direct) {
            int bucket = this.bucketFor(size);
            ConcurrentMap<Integer, Queue<ByteBuffer>> buffers = this.buffersFor(direct);
            ByteBuffer result = null;
            Queue byteBuffers = (Queue)buffers.get(bucket);
            if (byteBuffers != null) {
                result = (ByteBuffer)byteBuffers.poll();
            }
            if (result == null) {
                int capacity = bucket * this.factor;
                result = this.newByteBuffer(capacity, direct);
            }
            result.clear();
            return result;
        }

        protected ByteBuffer newByteBuffer(int capacity, boolean direct) {
            return direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        }

        public void release(ByteBuffer buffer) {
            if (buffer == null) {
                return;
            }
            int bucket = this.bucketFor(buffer.capacity());
            ConcurrentMap<Integer, Queue<ByteBuffer>> buffers = this.buffersFor(buffer.isDirect());
            Queue<ByteBuffer> byteBuffers = (ConcurrentLinkedQueue<ByteBuffer>)buffers.get(bucket);
            if (byteBuffers == null) {
                byteBuffers = new ConcurrentLinkedQueue<ByteBuffer>();
                Queue existing = buffers.putIfAbsent(bucket, byteBuffers);
                if (existing != null) {
                    byteBuffers = existing;
                }
            }
            buffer.clear();
            byteBuffers.offer(buffer);
        }

        public void clear() {
            this.directBuffers.clear();
            this.heapBuffers.clear();
        }

        private int bucketFor(int size) {
            int bucket = size / this.factor;
            if (size % this.factor > 0) {
                ++bucket;
            }
            return bucket;
        }

        ConcurrentMap<Integer, Queue<ByteBuffer>> buffersFor(boolean direct) {
            return direct ? this.directBuffers : this.heapBuffers;
        }
    }
}

