/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.archive;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.Plugins;
import org.joyqueue.broker.archive.ArchiveConfig;
import org.joyqueue.broker.archive.ArchiveUtils;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.MessageConvertSupport;
import org.joyqueue.broker.consumer.model.PullResult;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.SourceType;
import org.joyqueue.monitor.PointTracer;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.server.archive.store.api.ArchiveStore;
import org.joyqueue.server.archive.store.model.AchivePosition;
import org.joyqueue.server.archive.store.model.SendLog;
import org.joyqueue.store.PositionOverflowException;
import org.joyqueue.store.PositionUnderflowException;
import org.joyqueue.toolkit.concurrent.LoopThread;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProduceArchiveService
extends Service {
    private static final Logger logger = LoggerFactory.getLogger(ProduceArchiveService.class);
    private int batchNum = 1000;
    private ClusterManager clusterManager;
    private Consume consume;
    private ItemList itemList = new ItemList();
    private ArchiveStore archiveStore;
    private BlockingQueue<SendLog> archiveQueue;
    private ConcurrentMap<String, AtomicInteger> storeCounter = new ConcurrentHashMap<String, AtomicInteger>();
    private String separator = ":";
    private ExecutorService executorService;
    AtomicBoolean hasStoreError = new AtomicBoolean(false);
    private final Map<String, Long> pauseMap = new HashMap<String, Long>();
    private PointTracer tracer;
    private AtomicLong updateArchiveMetadataCounter = new AtomicLong(0L);
    private long ARCHIVE_METADATA_MOD = 60L;
    private LoopThread updateItemThread;
    private LoopThread readMsgThread;
    private LoopThread writeMsgThread;
    private ArchiveConfig archiveConfig;
    private MessageConvertSupport messageConvertSupport;

    public ProduceArchiveService(ArchiveConfig archiveConfig, ClusterManager clusterManager, Consume consume, MessageConvertSupport messageConvertSupport) {
        this.clusterManager = clusterManager;
        this.consume = consume;
        this.archiveConfig = archiveConfig;
        this.messageConvertSupport = messageConvertSupport;
    }

    protected void validate() throws Exception {
        super.validate();
        this.archiveStore = this.archiveStore != null ? this.archiveStore : (ArchiveStore)Plugins.ARCHIVESTORE.get();
        this.archiveStore.setNameSpace(this.archiveConfig.getNamespace());
        logger.info("Get archive store namespace [{}] by archive config.", (Object)this.archiveConfig.getNamespace());
        Preconditions.checkArgument((this.archiveStore != null ? 1 : 0) != 0, (Object)"archive store can not be null.");
        Preconditions.checkArgument((this.archiveConfig != null ? 1 : 0) != 0, (Object)"archive config can not be null.");
        this.tracer = (PointTracer)Plugins.TRACERERVICE.get((Object)this.archiveConfig.getTracerType());
        this.batchNum = this.archiveConfig.getProduceBatchNum();
        this.archiveQueue = new LinkedBlockingDeque<SendLog>(this.archiveConfig.getLogQueueSize());
        this.executorService = new ThreadPoolExecutor(this.archiveConfig.getWriteThreadNum(), this.archiveConfig.getWriteThreadNum(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.archiveConfig.getThreadPoolQueueSize()), (ThreadFactory)new NamedThreadFactory("sendLog-archive"), new ThreadPoolExecutor.CallerRunsPolicy());
        this.updateItemThread = LoopThread.builder().sleepTime(10000L, 10000L).name("UpdateArchiveItem-Thread").onException(e -> logger.warn("Exception:", e)).doWork(() -> {
            this.updateArchiveItem();
            this.syncArchivePosition();
        }).build();
        this.readMsgThread = LoopThread.builder().sleepTime(0L, 10L).name("ReadArchiveMsg-Thread").onException(e -> logger.warn("Exception:", e)).doWork(() -> this.readArchiveMsg()).build();
        this.writeMsgThread = LoopThread.builder().sleepTime(10L, 10L).name("WriteArchiveMsg-Thread").onException(e -> logger.warn("Exception:", e)).doWork(() -> this.write2Store()).build();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.archiveStore.start();
        this.updateArchiveItem();
        this.updateItemThread.start();
        this.readMsgThread.start();
        this.writeMsgThread.start();
        logger.info("produce archive archiveService started.");
    }

    protected void doStop() {
        super.doStop();
        Close.close((LifeCycle)this.updateItemThread);
        Close.close((LifeCycle)this.readMsgThread);
        Close.close((LifeCycle)this.writeMsgThread);
        Close.close((ExecutorService)this.executorService);
        Close.close((LifeCycle)this.archiveStore);
        logger.info("produce archive archiveService stopped.");
    }

    private void updateArchiveItem() throws JoyQueueException {
        ArrayList<SendArchiveItem> list = new ArrayList<SendArchiveItem>();
        List<TopicConfig> topics = this.clusterManager.getTopics();
        topics.stream().forEach(topicConfig -> {
            TopicName name = topicConfig.getName();
            if (this.clusterManager.checkArchiveable(name)) {
                logger.info("Topic:{} send archive is enable.", (Object)name.getFullName());
                List<Short> partitionSet = this.clusterManager.getLocalPartitions((TopicConfig)topicConfig);
                partitionSet.stream().forEach(partition -> list.add(new SendArchiveItem(name.getFullName(), (Short)partition)));
            }
        });
        this.itemList.addAndUpdate(list);
        long count = this.updateArchiveMetadataCounter.getAndIncrement();
        if (count % this.ARCHIVE_METADATA_MOD == 0L) {
            logger.info("Add or Update archive item ping,size {}", (Object)list.size());
        }
    }

    private void readArchiveMsg() throws Exception {
        int counter = 0;
        List<SendArchiveItem> all = this.itemList.getAll();
        for (SendArchiveItem item : all) {
            PullResult pullResult;
            if (this.isPause(item.getTopic(), item.getPartition())) continue;
            long readIndex = item.getReadIndex();
            try {
                pullResult = this.consume.getMessage(item.topic, (short)item.partition, readIndex, this.batchNum);
            }
            catch (Throwable th) {
                if (logger.isDebugEnabled()) {
                    logger.debug("read message from topic:" + item.topic + " partition:" + item.partition + " index:" + item.getReadIndex() + " error.", th);
                }
                if (th.getCause() instanceof PositionUnderflowException) {
                    long minIndex = this.consume.getMinIndex(new Consumer(item.topic, ""), item.partition);
                    item.setReadIndex(minIndex);
                    logger.debug("repair read message position SendArchiveItem info:[{}], currentIndex:[{}]", (Object)item, (Object)minIndex);
                }
                if (th.getCause() instanceof PositionOverflowException) {
                    long maxIndex = this.consume.getMaxIndex(new Consumer(item.topic, ""), item.partition);
                    item.setReadIndex(maxIndex);
                    logger.debug("repair read message position SendArchiveItem info:[{}], currentIndex:[{}]", (Object)item, (Object)maxIndex);
                }
                this.put2PauseMap(item.getTopic(), item.getPartition());
                continue;
            }
            int messageSize = pullResult.getBuffers().size();
            if (messageSize == 0) {
                this.put2PauseMap(item.getTopic(), item.getPartition());
                continue;
            }
            int size = this.putSendLog2Queue(pullResult);
            if (size > 0) {
                this.writeMsgThread.wakeup();
            }
            item.setReadIndex(readIndex + (long)size, readIndex);
            counter += messageSize;
            if (!logger.isDebugEnabled()) continue;
            logger.debug("produce archive: {} messages put into the archive queue.", (Object)size);
        }
        if (counter == 0) {
            Thread.sleep(1L);
        }
    }

    private void put2PauseMap(String topic, Short partition) {
        int pauseTime = 2000;
        this.pauseMap.put(topic + this.separator + partition, SystemClock.now() + (long)pauseTime);
    }

    private boolean isPause(String topic, Short partition) {
        Long expireTime = this.pauseMap.get(topic + this.separator + partition);
        if (expireTime == null) {
            return false;
        }
        return expireTime > SystemClock.now();
    }

    private int putSendLog2Queue(PullResult pullResult) throws Exception {
        int readCount = 0;
        List<ByteBuffer> buffers = pullResult.getBuffers();
        for (ByteBuffer buffer : buffers) {
            List<BrokerMessage> brokerMessageList = this.parseMessage(buffer);
            for (BrokerMessage brokerMessage : brokerMessageList) {
                brokerMessage.setTopic(pullResult.getTopic());
                brokerMessage.setPartition(pullResult.getPartition());
                SendLog sendLog = this.convert(brokerMessage, buffer);
                this.archiveQueue.put(sendLog);
            }
            readCount += brokerMessageList.size();
        }
        return readCount;
    }

    private List<BrokerMessage> parseMessage(ByteBuffer buffer) throws Exception {
        BrokerMessage brokerMessage = Serializer.readBrokerMessage(buffer);
        return this.messageConvertSupport.convert(brokerMessage, SourceType.INTERNAL.getValue());
    }

    private SendLog convert(BrokerMessage brokerMessage, ByteBuffer buffer) {
        SendLog sendLog = new SendLog();
        sendLog.setTopic(brokerMessage.getTopic());
        sendLog.setSendTime(brokerMessage.getStartTime());
        sendLog.setBusinessId(brokerMessage.getBusinessId() == null ? "" : brokerMessage.getBusinessId());
        sendLog.setMessageId(ArchiveUtils.messageId(brokerMessage.getTopic(), brokerMessage.getPartition(), brokerMessage.getMsgIndexNo()));
        sendLog.setBrokerId(this.clusterManager.getBrokerId().intValue());
        sendLog.setApp(brokerMessage.getApp());
        sendLog.setClientIp(brokerMessage.getClientIp());
        sendLog.setCompressType((short)-1);
        sendLog.setMessageBody(buffer.array());
        sendLog.setPartition(brokerMessage.getPartition());
        sendLog.setIndex(brokerMessage.getMsgIndexNo());
        return sendLog;
    }

    private void write2Store() throws InterruptedException {
        int readBatchSize;
        do {
            SendLog sendLog;
            ArrayList<SendLog> sendLogs = new ArrayList<SendLog>(this.batchNum);
            for (int i = 0; i < this.batchNum && (sendLog = (SendLog)this.archiveQueue.poll()) != null; ++i) {
                sendLogs.add(sendLog);
            }
            readBatchSize = sendLogs.size();
            if (readBatchSize > 0) {
                this.executorService.submit(() -> {
                    try {
                        this.archiveStore.putSendLog(sendLogs, this.tracer);
                        logger.debug("Write sendLogs size:{} to archive store.", (Object)sendLogs.size());
                        this.writeCounter(sendLogs);
                    }
                    catch (JoyQueueException e) {
                        this.hasStoreError.set(true);
                        this.rollBackReadIndex(sendLogs);
                    }
                });
            }
            if (!this.hasStoreError.getAndSet(false)) continue;
            Thread.sleep(1000L);
        } while (readBatchSize == this.batchNum);
    }

    private void writeCounter(List<SendLog> sendLogs) {
        sendLogs.stream().forEach(sendLog -> {
            AtomicInteger counter = (AtomicInteger)this.storeCounter.get(sendLog.getTopic() + this.separator + sendLog.getPartition());
            if (counter == null && null == this.storeCounter.putIfAbsent(sendLog.getTopic() + this.separator + sendLog.getPartition(), new AtomicInteger())) {
                counter = (AtomicInteger)this.storeCounter.get(sendLog.getTopic() + this.separator + sendLog.getPartition());
            }
            counter.incrementAndGet();
        });
    }

    private void rollBackReadIndex(List<SendLog> sendLogs) {
        SendLog first = sendLogs.get(0);
        String topic = first.getTopic();
        short partition = first.getPartition();
        long index = first.getIndex();
        for (SendLog sendLog : sendLogs) {
            if (topic.equals(sendLog.getTopic()) && partition == sendLog.getPartition()) {
                index = Math.min(index, sendLog.getIndex());
                continue;
            }
            this.itemList.updateReadIndex(topic, partition, index);
            topic = sendLog.getTopic();
            partition = sendLog.getPartition();
            index = sendLog.getIndex();
        }
        this.itemList.updateReadIndex(topic, partition, index);
    }

    private void syncArchivePosition() {
        for (String key : this.storeCounter.keySet()) {
            int num;
            String[] split = key.split(this.separator);
            String topic = split[0];
            short partition = Short.parseShort(split[1]);
            AtomicInteger counter = (AtomicInteger)this.storeCounter.get(key);
            while (!counter.compareAndSet(num = counter.get(), 0)) {
            }
            try {
                Long position = this.archiveStore.getPosition(topic, partition);
                position = position == null ? 0L : position;
                this.archiveStore.putPosition(new AchivePosition(topic, partition, position + (long)num));
            }
            catch (Throwable th) {
                int rollbackNum;
                while (!counter.compareAndSet(rollbackNum = counter.get(), rollbackNum + num)) {
                }
            }
        }
    }

    public Map<String, Long> getArchivePosition() {
        if (!this.archiveConfig.isBacklogEnable()) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> result = new HashMap<String, Long>();
        List<SendArchiveItem> allList = this.itemList.getAll();
        for (SendArchiveItem sai : allList) {
            result.put(sai.getTopic(), this.remainMessagesSum(sai.getTopic()));
        }
        return result;
    }

    public long remainMessagesSum() {
        if (!this.archiveConfig.isReamingEnable()) {
            return 0L;
        }
        List<TopicConfig> topics = this.clusterManager.getTopics();
        long sum = topics.stream().mapToLong(topic -> this.remainMessagesSum(topic.getName().getFullName())).sum();
        return sum;
    }

    public long remainMessagesSum(String topic) {
        return this.getCurrentIndexSum(topic) - this.getArchiveIndexSum(topic);
    }

    public long getCurrentIndexSum(String topic) {
        List<Short> partitionList = this.clusterManager.getLocalPartitions(TopicName.parse((String)topic));
        long sum = partitionList.stream().mapToLong(partition -> Math.max(0L, this.consume.getMaxIndex(new Consumer(topic, ""), (short)partition) - 1L)).sum();
        return sum;
    }

    public long getArchiveIndexSum(String topic) {
        List<SendArchiveItem> all = this.itemList.getAll();
        long sum = all.stream().filter(task -> ((SendArchiveItem)task).topic.equals(topic)).mapToLong(task -> task.getReadIndex()).sum();
        return sum;
    }

    class ItemList {
        private CopyOnWriteArrayList<SendArchiveItem> cpList = new CopyOnWriteArrayList();

        ItemList() {
        }

        public List<SendArchiveItem> getAll() {
            return this.cpList;
        }

        public void remove(SendArchiveItem item) throws JoyQueueException {
            this.cpList.remove(item);
            ProduceArchiveService.this.archiveStore.cleanPosition(item.getTopic(), item.getPartition().shortValue());
        }

        public void addAndUpdate(List<SendArchiveItem> newItemList) throws JoyQueueException {
            this.cpList.stream().forEach(item -> {
                if (!newItemList.contains(item)) {
                    try {
                        this.remove((SendArchiveItem)item);
                        logger.info("Clean up archive item,topic {},partition {}", (Object)item.getTopic(), (Object)item.getPartition());
                    }
                    catch (JoyQueueException e) {
                        logger.info("remove archive item exception", (Throwable)e);
                    }
                }
            });
            for (SendArchiveItem item2 : newItemList) {
                if (this.cpList.contains(item2)) continue;
                Long index = ProduceArchiveService.this.archiveStore.getPosition(item2.topic, item2.partition.shortValue());
                if (index == null) {
                    Consumer consumer = new Consumer();
                    consumer.setTopic(item2.getTopic());
                    index = ProduceArchiveService.this.consume.getMaxIndex(consumer, item2.getPartition());
                    logger.info("New archive item,topic {},partition {},init from local store max index {}", new Object[]{item2.getTopic(), item2.getPartition(), item2.getReadIndex()});
                } else {
                    logger.info("New archive item,topic {},partition {},recover from archive store,index {}", new Object[]{item2.getTopic(), item2.getPartition(), index});
                }
                item2.setReadIndex(index);
                this.cpList.add(item2);
            }
        }

        public void updateReadIndex(String topic, short partition, long newReadIndex) {
            SendArchiveItem sendArchiveItem;
            long index;
            Optional<SendArchiveItem> any = this.cpList.stream().filter(item -> topic.equals(item.getTopic()) && item.getPartition().equals(partition)).findAny();
            if (any.isPresent() && (index = (sendArchiveItem = any.get()).getReadIndex()) > newReadIndex) {
                sendArchiveItem.setReadIndex(newReadIndex);
            }
        }
    }

    static class SendArchiveItem {
        private final String topic;
        private final Short partition;
        private AtomicLong readIndex = new AtomicLong(0L);

        SendArchiveItem(String topic, Short partition) {
            this.topic = topic;
            this.partition = partition;
        }

        public long getReadIndex() {
            if (this.readIndex == null) {
                this.readIndex = new AtomicLong(0L);
            }
            return this.readIndex.get();
        }

        public synchronized void setReadIndex(long index) {
            this.readIndex.set(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setReadIndex(long expectIndex, long previousIndex) {
            if (this.readIndex.get() < previousIndex) {
                return;
            }
            SendArchiveItem sendArchiveItem = this;
            synchronized (sendArchiveItem) {
                if (this.readIndex.get() < previousIndex) {
                    return;
                }
                this.setReadIndex(expectIndex);
            }
        }

        public String getTopic() {
            return this.topic;
        }

        public Short getPartition() {
            return this.partition;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            SendArchiveItem that = (SendArchiveItem)obj;
            if (!StringUtils.equals((CharSequence)this.topic, (CharSequence)that.topic)) {
                return false;
            }
            return this.partition == that.partition;
        }

        public String toString() {
            return "SendArchiveItem{topic='" + this.topic + '\'' + ", partition=" + this.partition + ", readIndex=" + this.readIndex + '}';
        }
    }
}

