/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

public class ByteBufPool {
    private ArrayBlockingQueue<ByteBuf> byteBufs;
    private int bufferSize;
    private AtomicLong created = new AtomicLong(0L);

    public ByteBufPool(int capacity, int bufferSize) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity must be greater than 0");
        }
        if (bufferSize < 0) {
            throw new IllegalArgumentException("bufferSize must be greater than 0");
        }
        this.byteBufs = new ArrayBlockingQueue(capacity);
        this.bufferSize = bufferSize;
        for (int i = 0; i < capacity; ++i) {
            this.byteBufs.add(this.newByteBuf());
            this.created.incrementAndGet();
        }
    }

    protected ByteBuf newByteBuf() {
        return UnpooledByteBufAllocator.DEFAULT.heapBuffer(this.bufferSize);
    }

    public ByteBuf get() {
        ByteBuf buf = this.byteBufs.poll();
        if (buf == null) {
            buf = this.newByteBuf();
            this.created.incrementAndGet();
        }
        return buf;
    }

    public void release(ByteBuf buf) {
        if (buf != null) {
            this.byteBufs.offer(buf);
        }
    }

    public long getCreated() {
        return this.created.get();
    }
}

