/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.buffer;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.BrokerPrepare;
import org.joyqueue.message.JoyQueueLog;
import org.joyqueue.message.Message;
import org.joyqueue.toolkit.io.Compressor;
import org.joyqueue.toolkit.io.Compressors;
import org.joyqueue.toolkit.io.Zip;
import org.joyqueue.toolkit.io.ZipUtil;
import org.joyqueue.toolkit.serialize.AbstractSerializer;
import org.joyqueue.toolkit.time.SystemClock;

public class Serializer
extends AbstractSerializer {
    private static final byte BYTE_SIZE = 1;
    private static final byte SHORT_SIZE = 2;
    private static final byte INT_SIZE = 4;
    private static final int fixBodyLength = 73;
    private static final byte MESSAGE_VERSION_V0 = 0;
    private static final byte MESSAGE_VERSION_V1 = 1;
    private static final byte CURRENT_MESSAGE_VERSION = 1;

    public static short readPartition(ByteBuffer byteBuffer) {
        ByteBuffer slice = byteBuffer.slice();
        slice.position(4);
        short partition = slice.getShort();
        return partition;
    }

    public static long readIndex(ByteBuffer byteBuffer) {
        ByteBuffer slice = byteBuffer.slice();
        slice.position(6);
        long index = slice.getLong();
        return index;
    }

    public static short readFlag(ByteBuffer byteBuffer) {
        ByteBuffer slice = byteBuffer.slice();
        slice.position(59);
        short flag = slice.getShort();
        return flag;
    }

    public static long readSendTime(ByteBuffer byteBuffer) {
        ByteBuffer slice = byteBuffer.slice();
        slice.position(39);
        long sendTime = slice.getLong();
        return sendTime;
    }

    public static void setPartition(ByteBuffer byteBuffer, short partition) {
        ByteBuffer slice = byteBuffer.slice();
        slice.position(4);
        slice.putShort(partition);
    }

    public static void setIndex(ByteBuffer byteBuffer, long index) {
        ByteBuffer slice = byteBuffer.slice();
        slice.position(6);
        slice.putLong(index);
    }

    public static BrokerPrepare readBrokerPrepare(ByteBuffer in) throws Exception {
        BrokerPrepare prepare = new BrokerPrepare();
        prepare.setSize(in.getInt());
        in.getShort();
        in.get();
        prepare.setStartTime(in.getLong());
        prepare.setTopic(Serializer.readString((ByteBuffer)in));
        prepare.setApp(Serializer.readString((ByteBuffer)in));
        prepare.setTxId(Serializer.readString((ByteBuffer)in, (int)2));
        prepare.setQueryId(Serializer.readString((ByteBuffer)in, (int)2));
        prepare.setSource(in.get());
        return prepare;
    }

    public static ByteBuffer writeBrokerPrepare(BrokerPrepare prepare, ByteBuffer out) throws Exception {
        int begin = out.position();
        out.putInt(0);
        out.putShort((short)13398);
        out.put(prepare.getType());
        out.putLong(prepare.getStartTime());
        Serializer.write(prepare.getTopic(), out);
        Serializer.write(prepare.getApp(), out);
        Serializer.write(prepare.getTxId(), out, 2);
        Serializer.write(prepare.getQueryId(), out, 2);
        out.put(prepare.getSource());
        int end = out.position();
        int size = end - begin;
        prepare.setSize(size);
        out.putInt(begin, size);
        return out;
    }

    public static int sizeOfBrokerPrepare(BrokerPrepare prepare) throws Exception {
        int length = 22;
        length += Serializer.getBytes((String)prepare.getTopic(), (Charset)Charsets.UTF_8).length;
        length += Serializer.getBytes((String)prepare.getApp(), (Charset)Charsets.UTF_8).length;
        length += Serializer.getBytes((String)prepare.getTxId(), (Charset)Charsets.UTF_8).length;
        return length += Serializer.getBytes((String)prepare.getQueryId(), (Charset)Charsets.UTF_8).length;
    }

    @Deprecated
    public static ByteBuf serialize(JoyQueueLog log, ByteBuf out) throws Exception {
        BrokerMessage message = (BrokerMessage)log;
        Serializer.write(message, out);
        return out;
    }

    public static ByteBuffer serialize(JoyQueueLog log, ByteBuffer out, int size) throws Exception {
        BrokerMessage message = (BrokerMessage)log;
        Serializer.write(message, out, size);
        return out;
    }

    public static int sizeOf(BrokerMessage msg) {
        int bodyLength = 73;
        ByteBuffer buffer = msg.getBody();
        int length = buffer == null ? 0 : buffer.remaining();
        bodyLength += length;
        byte[] bytes = Serializer.getBytes((String)msg.getApp(), (Charset)Charsets.UTF_8);
        bodyLength += bytes == null ? 0 : bytes.length;
        bytes = Serializer.getBytes((String)msg.getBusinessId(), (Charset)Charsets.UTF_8);
        bodyLength += bytes == null ? 0 : bytes.length;
        bytes = Serializer.getBytes((String)Serializer.toProperties((Map)msg.getAttributes()), (Charset)Charsets.UTF_8);
        bodyLength += bytes == null ? 0 : bytes.length;
        bytes = msg.getExtension();
        return bodyLength += bytes == null ? 0 : bytes.length;
    }

    public static void write(BrokerMessage message, ByteBuffer out, int size) throws Exception {
        if (out == null || message == null) {
            return;
        }
        int begin = out.position();
        out.putInt(size);
        out.putShort(message.getPartition());
        out.putLong(message.getMsgIndexNo());
        out.putInt(message.getTerm());
        out.putShort((short)4660);
        short sysCode = (byte)(message.isCompressed() ? 1 : 0);
        sysCode = (short)(sysCode | (message.isOrdered() ? 1 : 0) << 1 & 3);
        sysCode = (short)(sysCode | message.getSource() << 2 & 0xC);
        if (message.isCompressed()) {
            sysCode = (short)(sysCode | message.getCompressionType().getType() << 4 & 0x70);
        }
        if (message.getClientIp().length < 7) {
            sysCode = (short)(sysCode | 0x80);
        }
        sysCode = (short)(sysCode | 0x100);
        sysCode = (short)(sysCode | (message.isBatch() ? 1 : 0) << 12);
        out.putShort(sysCode);
        out.put(message.getPriority());
        byte[] clientIp = new byte[16];
        if (message.getClientIp() != null) {
            System.arraycopy(message.getClientIp(), 0, clientIp, 0, Math.min(message.getClientIp().length, clientIp.length));
        }
        out.put(clientIp);
        out.putLong(message.getStartTime());
        out.putInt((int)(SystemClock.now() - message.getStartTime()));
        out.putLong(message.getBodyCRC());
        out.putShort(message.getFlag());
        if (message.getByteBody() != null) {
            Serializer.write(message.getBody(), out, true);
        } else {
            out.putInt(0);
        }
        Serializer.write(message.getBusinessId(), out);
        Serializer.write(Serializer.toProperties((Map)message.getAttributes()), out, 2);
        Serializer.write(message.getExtension(), out, true);
        Serializer.write(message.getApp(), out);
        message.setSize(size);
        out.flip();
    }

    public static void write(BrokerMessage[] messages, ByteBuf out) throws Exception {
        if (out == null) {
            return;
        }
        int count = messages == null ? 0 : messages.length;
        out.writeShort(count);
        for (int i = 0; i < count; ++i) {
            Serializer.write(messages[i], out);
        }
    }

    @Deprecated
    public static void write(BrokerMessage message, ByteBuf out) throws Exception {
        if (out == null || message == null) {
            return;
        }
        int begin = out.writerIndex();
        out.writeInt(0);
        out.writeShort((int)message.getPartition());
        out.writeLong(message.getMsgIndexNo());
        out.writeInt(message.getTerm());
        out.writeShort(4660);
        byte sysCode = (byte)(message.isCompressed() ? 1 : 0);
        sysCode = (byte)(sysCode | (message.isOrdered() ? 1 : 0) << 1 & 3);
        sysCode = (byte)(sysCode | message.getSource() << 2 & 0xC);
        if (message.isCompressed()) {
            sysCode = (byte)(sysCode | message.getCompressionType().getType() << 4 & 0x30);
        }
        out.writeByte((int)sysCode);
        out.writeByte((int)message.getPriority());
        byte[] clientIp = message.getClientIp();
        if (clientIp != null) {
            out.writeBytes(message.getClientIp());
            if (message.getClientIp().length == 6) {
                out.writeBytes(new byte[10]);
            }
        } else {
            out.writeBytes(new byte[16]);
        }
        out.writeLong(message.getStartTime());
        out.writeInt(0);
        out.writeLong(message.getBodyCRC());
        if (message.getByteBody() != null) {
            Serializer.write(message.getBody(), out);
        } else {
            out.writeInt(0);
        }
        Serializer.write(message.getTopic(), out);
        Serializer.write(message.getApp(), out);
        Serializer.write(message.getBusinessId(), out);
        Serializer.write(message.getTxId(), out, 2);
        Serializer.write(Serializer.toProperties((Map)message.getAttributes()), out, 2);
        Serializer.write(message.getExtension(), out);
        int end = out.writerIndex();
        int size = end - begin;
        message.setSize(size);
        out.writerIndex(begin);
        out.writeInt(size);
        out.writerIndex(end);
    }

    public static BrokerMessage readBrokerMessage(ByteBuf in) throws Exception {
        if (in == null) {
            return null;
        }
        BrokerMessage message = new BrokerMessage();
        int totalLength = in.readInt();
        message.setPartition(in.readShort());
        message.setMsgIndexNo(in.readLong());
        message.setTerm(in.readInt());
        in.readShort();
        byte sysCode = in.readByte();
        message.setCompressed((sysCode & 1) > 0);
        message.setOrdered((sysCode & 2) > 0);
        message.setSource((byte)(sysCode >> 2 & 3));
        message.setCompressionType(Message.CompressionType.valueOf((int)(sysCode >> 4 & 3)));
        message.setPriority(in.readByte());
        if ((sysCode | 0x20) > 0) {
            message.setClientIp(Serializer.readBytes(in, 6));
            Serializer.readBytes(in, 10);
        } else {
            message.setClientIp(Serializer.readBytes(in, 16));
        }
        message.setStartTime(in.readLong());
        message.setStoreTime(in.readInt());
        message.setBodyCRC(in.readLong());
        int bodyLength = in.readInt();
        message.setBody(Serializer.readBytes(in, bodyLength));
        message.setTopic(Serializer.readString(in));
        message.setApp(Serializer.readString(in));
        message.setBusinessId(Serializer.readString(in));
        message.setTxId(Serializer.readString(in, 2));
        message.setAttributes(Serializer.toStringMap((String)Serializer.readString(in, 2)));
        int extensionLength = in.readInt();
        message.setExtension(Serializer.readBytes(in, extensionLength));
        return message;
    }

    public static BrokerMessage readBrokerMessageHeader(ByteBuffer in) {
        if (in == null) {
            return null;
        }
        in = in.slice();
        int startPosition = in.position();
        BrokerMessage message = new BrokerMessage();
        int totalLength = in.getInt();
        message.setPartition(in.getShort());
        message.setMsgIndexNo(in.getLong());
        message.setTerm(in.getInt());
        in.getShort();
        short sysCode = in.getShort();
        byte version = (byte)(sysCode >> 8 & 0xF);
        boolean isIpv4 = (sysCode & 0x80) > 1;
        message.setCompressed((sysCode & 1) > 0);
        message.setOrdered((sysCode & 2) > 0);
        message.setSource((byte)(sysCode >> 2 & 3));
        message.setBatch(sysCode >> 12 == 1);
        if (version == 0) {
            message.setCompressionType(Message.CompressionType.valueOf((int)(sysCode >> 4 & 3)));
            isIpv4 = true;
        } else {
            message.setCompressionType(Message.CompressionType.valueOf((int)(sysCode >> 4 & 7)));
        }
        message.setPriority(in.get());
        if (isIpv4) {
            message.setClientIp(Serializer.readBytes((ByteBuffer)in, (int)6));
            Serializer.readBytes((ByteBuffer)in, (int)10);
        } else {
            message.setClientIp(Serializer.readBytes((ByteBuffer)in, (int)16));
        }
        message.setStartTime(in.getLong());
        message.setStoreTime(in.getInt());
        message.setBodyCRC(in.getLong());
        message.setFlag(in.getShort());
        return message;
    }

    public static BrokerMessage readBrokerMessage(ByteBuffer in) throws Exception {
        if (in == null) {
            return null;
        }
        int startPosition = in.position();
        BrokerMessage message = new BrokerMessage();
        int totalLength = in.getInt();
        message.setPartition(in.getShort());
        message.setMsgIndexNo(in.getLong());
        message.setTerm(in.getInt());
        in.getShort();
        short sysCode = in.getShort();
        byte version = (byte)(sysCode >> 8 & 0xF);
        boolean isIpv4 = (sysCode & 0x80) > 1;
        message.setCompressed((sysCode & 1) > 0);
        message.setOrdered((sysCode & 2) > 0);
        message.setSource((byte)(sysCode >> 2 & 3));
        message.setBatch(sysCode >> 12 == 1);
        if (version == 0) {
            message.setCompressionType(Message.CompressionType.valueOf((int)(sysCode >> 4 & 3)));
            isIpv4 = true;
        } else {
            message.setCompressionType(Message.CompressionType.valueOf((int)(sysCode >> 4 & 7)));
        }
        message.setPriority(in.get());
        if (isIpv4) {
            message.setClientIp(Serializer.readBytes((ByteBuffer)in, (int)6));
            Serializer.readBytes((ByteBuffer)in, (int)10);
        } else {
            message.setClientIp(Serializer.readBytes((ByteBuffer)in, (int)16));
        }
        message.setStartTime(in.getLong());
        message.setStoreTime(in.getInt());
        message.setBodyCRC(in.getLong());
        message.setFlag(in.getShort());
        int bodyLength = in.getInt();
        message.setBody(Serializer.readBytes((ByteBuffer)in, (int)bodyLength));
        message.setBusinessId(Serializer.readString((ByteBuffer)in));
        message.setAttributes(Serializer.toStringMap((String)Serializer.readString((ByteBuffer)in, (int)2)));
        int extensionLength = in.getInt();
        message.setExtension(Serializer.readBytes((ByteBuffer)in, (int)extensionLength));
        message.setApp(Serializer.readString((ByteBuffer)in));
        message.setSize(in.position() - startPosition);
        return message;
    }

    public static void write(String value, ByteBuffer out, int lengthSize) throws Exception {
        Serializer.write(value, out, lengthSize, false);
    }

    @Deprecated
    public static void write(String value, ByteBuf out, int lengthSize) throws Exception {
        Serializer.write(value, out, lengthSize, false);
    }

    @Deprecated
    public static void write(String value, ByteBuf out) throws Exception {
        Serializer.write(value, out, 1, false);
    }

    public static void write(String value, ByteBuffer out) throws Exception {
        Serializer.write(value, out, 1, false);
    }

    @Deprecated
    public static void write(String value, ByteBuf out, int lengthSize, boolean compressed) throws Exception {
        if (out == null) {
            return;
        }
        if (value != null && !value.isEmpty()) {
            byte[] bytes = Serializer.getBytes((String)value, (Charset)Charsets.UTF_8);
            if (compressed) {
                bytes = Compressors.compress((byte[])bytes, (int)0, (int)bytes.length, (Compressor)Zip.INSTANCE);
            }
            Serializer.write(bytes.length, out, lengthSize);
            out.writeBytes(bytes);
        } else {
            Serializer.write(0, out, lengthSize);
        }
    }

    public static void write(String value, ByteBuffer out, int lengthSize, boolean compressed) throws Exception {
        if (out == null) {
            return;
        }
        if (value != null && !value.isEmpty()) {
            byte[] bytes = Serializer.getBytes((String)value, (Charset)Charsets.UTF_8);
            if (compressed) {
                bytes = Compressors.compress((byte[])bytes, (int)0, (int)bytes.length, (Compressor)Zip.INSTANCE);
            }
            Serializer.write(bytes.length, out, lengthSize);
            out.put(bytes);
        } else {
            Serializer.write(0, out, lengthSize);
        }
    }

    @Deprecated
    public static void write(int value, ByteBuf out, int lengthSize) {
        if (out == null) {
            return;
        }
        switch (lengthSize) {
            case 1: {
                out.writeByte(value);
                break;
            }
            case 2: {
                out.writeShort(value);
                break;
            }
            case 4: {
                out.writeInt(value);
            }
        }
    }

    public static void write(int value, ByteBuffer out, int lengthSize) {
        if (out == null) {
            return;
        }
        switch (lengthSize) {
            case 1: {
                out.put((byte)value);
                break;
            }
            case 2: {
                out.putShort((short)value);
                break;
            }
            case 4: {
                out.putInt(value);
            }
        }
    }

    public static void write(byte[] value, ByteBuf out) {
        ByteBuffer wrap = ByteBuffer.wrap(value);
        Serializer.write(wrap, out, true);
    }

    public static void write(ByteBuffer value, ByteBuf out) {
        Serializer.write(value, out, true);
    }

    public static void write(ByteBuffer value, ByteBuf out, boolean writeLength) {
        int length;
        int n = length = value == null ? 0 : value.remaining();
        if (writeLength) {
            out.writeInt(length);
        }
        if (length > 0) {
            if (value.hasArray()) {
                out.writeBytes(value.array(), value.arrayOffset() + value.position(), value.remaining());
            } else {
                out.writeBytes(value.slice());
            }
        }
    }

    public static void write(byte[] value, ByteBuffer out, boolean writeLength) {
        ByteBuffer wrap = null;
        if (value != null) {
            wrap = ByteBuffer.wrap(value);
        }
        Serializer.write(wrap, out, writeLength);
    }

    public static void write(ByteBuffer value, ByteBuffer out, boolean writeLength) {
        int length;
        int n = length = value == null ? 0 : value.remaining();
        if (writeLength) {
            out.putInt(length);
        }
        if (length > 0) {
            if (value.hasArray()) {
                out.put(value.array(), value.arrayOffset() + value.position(), value.remaining());
            } else {
                out.put(value.slice());
            }
        }
    }

    @Deprecated
    public static String readString(ByteBuf in) throws Exception {
        return Serializer.readString(in, 1, false);
    }

    @Deprecated
    public static String readString(ByteBuf in, int lengthSize, boolean compressed) throws Exception {
        int length = lengthSize == 1 ? in.readUnsignedByte() : (lengthSize == 2 ? in.readUnsignedShort() : in.readInt());
        return Serializer.read(in, length, compressed, "UTF-8");
    }

    @Deprecated
    public static String read(ByteBuf in, int length, boolean compressed, String charset) throws Exception {
        if (length <= 0) {
            return null;
        }
        byte[] bytes = Serializer.readBytes(in, length);
        try {
            if (compressed) {
                bytes = ZipUtil.decompressByZlib((byte[])bytes, (int)0, (int)bytes.length);
            }
            if (charset == null || charset.isEmpty()) {
                charset = "UTF-8";
            }
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    @Deprecated
    private static byte[] readBytes(ByteBuf in, int length) {
        if (in == null || length <= 0) {
            return new byte[0];
        }
        int len = in.readableBytes();
        if (len == 0) {
            return new byte[0];
        }
        if (length < len) {
            len = length;
        }
        byte[] bytes = new byte[len];
        in.readBytes(bytes);
        return bytes;
    }

    @Deprecated
    public static String readString(ByteBuf in, int lengthSize) throws Exception {
        return Serializer.readString(in, lengthSize, false);
    }
}

