/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.cluster;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.cluster.ClusterNameService;
import org.joyqueue.broker.cluster.config.ClusterConfig;
import org.joyqueue.broker.cluster.entry.ClusterNode;
import org.joyqueue.broker.cluster.event.CompensateEvent;
import org.joyqueue.broker.config.BrokerConfig;
import org.joyqueue.broker.consumer.ConsumeConfigKey;
import org.joyqueue.domain.AppToken;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.ConsumerEvent;
import org.joyqueue.event.EventType;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.event.ProducerEvent;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.event.AddConsumerEvent;
import org.joyqueue.nsr.event.AddPartitionGroupEvent;
import org.joyqueue.nsr.event.AddProducerEvent;
import org.joyqueue.nsr.event.AddTopicEvent;
import org.joyqueue.nsr.event.RemoveConsumerEvent;
import org.joyqueue.nsr.event.RemovePartitionGroupEvent;
import org.joyqueue.nsr.event.RemoveProducerEvent;
import org.joyqueue.nsr.event.RemoveTopicEvent;
import org.joyqueue.nsr.event.UpdateBrokerEvent;
import org.joyqueue.nsr.event.UpdateConsumerEvent;
import org.joyqueue.nsr.event.UpdatePartitionGroupEvent;
import org.joyqueue.nsr.event.UpdateProducerEvent;
import org.joyqueue.nsr.event.UpdateTopicEvent;
import org.joyqueue.response.BooleanResponse;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManager
extends Service {
    private final Logger logger = LoggerFactory.getLogger(ClusterManager.class);
    private File brokerIdFile;
    private volatile BrokerConfig brokerConfig;
    private volatile Broker broker;
    private NameService nameService;
    private MetaDataLocalCache localCache;
    private EventBus<MetaEvent> eventBus = new EventBus("joyqueue-cluster-eventBus");
    private BrokerContext brokerContext;
    private ClusterNameService clusterNameService;
    private ClusterConfig config;

    public ClusterManager(BrokerConfig brokerConfig, NameService nameService, ClusterNameService clusterNameService, BrokerContext brokerContext) {
        this.brokerConfig = brokerConfig;
        this.nameService = nameService;
        this.clusterNameService = clusterNameService;
        this.brokerContext = brokerContext;
        this.config = new ClusterConfig(brokerContext.getPropertySupplier());
    }

    protected void validate() throws Exception {
        String path;
        super.validate();
        Preconditions.checkArgument((this.brokerConfig != null ? 1 : 0) != 0, (Object)"brokerConfig can not be null.");
        Preconditions.checkArgument((this.nameService != null ? 1 : 0) != 0, (Object)"nameService can not be null.");
        if (this.brokerIdFile == null && (path = this.brokerConfig.getBrokerIdFilePath()) != null) {
            this.brokerIdFile = new File(path);
        }
        Preconditions.checkArgument((this.brokerIdFile != null ? 1 : 0) != 0, (Object)"broker ID file can not be null.");
        if (!this.brokerIdFile.exists()) {
            this.brokerIdFile.createNewFile();
        }
        if (this.localCache == null) {
            this.localCache = new MetaDataLocalCache(this.nameService);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.localCache.start();
        this.eventBus.start();
        this.register();
        this.clusterNameService.setBroker(this.broker);
        this.localCache.initCache();
        this.logger.info("clusterManager is started");
    }

    private void register() throws Exception {
        String localIp = this.brokerConfig.getFrontendConfig().getHost();
        long port = this.brokerConfig.getFrontendConfig().getPort();
        Integer brokerId = this.readBroker();
        this.broker = this.nameService.register(brokerId, localIp, Integer.valueOf((int)port));
        if (this.broker == null) {
            this.logger.error("brokerId[{}] [{}:{}] \u6ce8\u518c\u5931\u8d25", new Object[]{brokerId, localIp, port});
            throw new JoyQueueException(JoyQueueCode.CN_SERVICE_NOT_AVAILABLE, new Object[0]);
        }
        this.brokerConfig.setBroker(this.broker);
        this.writeBroker(this.broker.getId());
    }

    public void addListener(EventListener<MetaEvent> listener) {
        this.eventBus.addListener(listener);
    }

    public DataCenter getDataCenterByIP(String ipAddr) {
        DataCenter ipInfo = this.nameService.getDataCenter(ipAddr);
        return ipInfo;
    }

    public Integer getBrokerId() {
        return this.broker.getId();
    }

    public BrokerConfig getConfig() {
        return this.brokerConfig;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public Broker getBrokerById(Integer brokerId) {
        if (brokerId.equals(this.getBrokerId())) {
            return this.broker;
        }
        return this.nameService.getBroker(brokerId.intValue());
    }

    public PartitionGroup getPartitionGroupByGroup(TopicName topic, int group) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig == null) {
            return null;
        }
        return topicConfig.fetchPartitionGroupByGroup(group);
    }

    public TopicConfig getTopicConfig(TopicName topic) {
        return this.localCache.getTopicConfig(topic);
    }

    public List<TopicConfig> getTopics() {
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry entry : this.localCache.getTopicConfigCache().entrySet()) {
            if (!((TopicConfig)entry.getValue()).isReplica(this.getBrokerId().intValue())) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public List<PartitionGroup> getLocalPartitionGroups(TopicName topic) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (null == topicConfig) {
            return null;
        }
        return this.getLocalPartitionGroups(topicConfig);
    }

    public List<PartitionGroup> getLocalPartitionGroups(TopicConfig topicConfig) {
        ArrayList result = Lists.newArrayListWithCapacity((int)topicConfig.getPartitionGroups().size());
        for (Map.Entry entry : topicConfig.getPartitionGroups().entrySet()) {
            if (!this.isLeader((PartitionGroup)entry.getValue())) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public List<Short> getLocalPartitions(TopicName topic) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (null == topicConfig) {
            return null;
        }
        return this.getLocalPartitions(topicConfig);
    }

    public List<Short> getLocalPartitions(TopicConfig topicConfig) {
        try {
            return (List)this.localCache.getPartitionCache().get((Object)topicConfig, () -> {
                ArrayList result = Lists.newArrayListWithCapacity((int)topicConfig.getPartitions());
                for (Map.Entry entry : topicConfig.getPartitionGroups().entrySet()) {
                    if (!this.isLeader((PartitionGroup)entry.getValue())) continue;
                    result.addAll(((PartitionGroup)entry.getValue()).getPartitions());
                }
                return result;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PartitionGroup> getTopicPartitionGroups(TopicName topic) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (null == topicConfig) {
            return null;
        }
        return topicConfig.fetchTopicPartitionGroupsByBrokerId(this.broker.getId().intValue());
    }

    public PartitionGroup getPartitionGroup(TopicName topic, short partition) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig != null) {
            return topicConfig.fetchPartitionGroupByPartition(partition);
        }
        return null;
    }

    public Integer getPartitionGroupId(TopicName topic, short partition) {
        PartitionGroup partitionGroup = this.getPartitionGroup(topic, partition);
        Integer group = null;
        if (partitionGroup != null) {
            group = partitionGroup.getGroup();
        }
        return group;
    }

    public List<Integer> getReplicaGroups(TopicName topic) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<PartitionGroup> partitionGroup = this.getLocalPartitionGroups(topic);
        if (partitionGroup != null) {
            partitionGroup.stream().forEach(item -> result.addAll(item.getReplicas()));
        }
        return result;
    }

    public List<Short> getReplicaPartitions(TopicName topic) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)topicConfig.getPartitions());
        for (Map.Entry entry : topicConfig.getPartitionGroups().entrySet()) {
            if (!((PartitionGroup)entry.getValue()).getReplicas().contains(this.getBrokerId())) continue;
            result.addAll(((PartitionGroup)entry.getValue()).getPartitions());
        }
        return result;
    }

    public List<Short> getPartitionList(TopicName topic) {
        TopicConfig config = this.getTopicConfig(topic);
        if (config != null) {
            return new ArrayList<Short>(config.fetchAllPartitions());
        }
        return Collections.emptyList();
    }

    public List<Short> getPriorityPartitionList(TopicName topic) {
        Set priorityPartitions;
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig != null && (priorityPartitions = topicConfig.getPriorityPartitions()) != null) {
            return new ArrayList<Short>(priorityPartitions);
        }
        return Collections.emptyList();
    }

    public Consumer.ConsumerPolicy getConsumerPolicy(TopicName topic, String app) throws JoyQueueException {
        Consumer consumer = this.localCache.getConsumerByTopicAndApp(topic, app);
        if (null == consumer) {
            if (StringUtils.equals((CharSequence)this.brokerConfig.getAdminUser(), (CharSequence)app)) {
                return this.brokerContext.getConsumerPolicy();
            }
            throw new JoyQueueException(JoyQueueCode.FW_CONSUMER_NOT_EXISTS, new Object[0]);
        }
        return this.getConsumerPolicyOrDefault(consumer);
    }

    public PropertySupplier getPropertySupplier() {
        return this.brokerContext.getPropertySupplier();
    }

    public int getRetryRandomBound(String topic, String app) {
        int topicRandomBound = this.doGetTopicRetryRandomBound(topic);
        if (topicRandomBound != -1) {
            return topicRandomBound;
        }
        int appRandomBound = this.doGetAppRetryRandomBound(app);
        if (appRandomBound != -1) {
            return appRandomBound;
        }
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.brokerContext.getPropertySupplier(), (PropertyDef)ConsumeConfigKey.RETRY_RANDOM_BOUND);
    }

    protected int doGetTopicRetryRandomBound(String topic) {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.brokerContext.getPropertySupplier(), (String)(ConsumeConfigKey.RETRY_RANDOM_BOUND_TOPIC_PREFIX.getName() + topic), (PropertyDef.Type)ConsumeConfigKey.RETRY_RANDOM_BOUND_TOPIC_PREFIX.getType(), (Object)ConsumeConfigKey.RETRY_RANDOM_BOUND_TOPIC_PREFIX.getValue());
    }

    protected int doGetAppRetryRandomBound(String app) {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.brokerContext.getPropertySupplier(), (String)(ConsumeConfigKey.RETRY_RANDOM_BOUND_APP_PREFIX.getName() + app), (PropertyDef.Type)ConsumeConfigKey.RETRY_RANDOM_BOUND_APP_PREFIX.getType(), (Object)ConsumeConfigKey.RETRY_RANDOM_BOUND_APP_PREFIX.getValue());
    }

    public Consumer getConsumer(TopicName topic, String app) throws JoyQueueException {
        Consumer consumer = this.tryGetConsumer(topic, app);
        if (null == consumer) {
            throw new JoyQueueException(JoyQueueCode.FW_CONSUMER_NOT_EXISTS, new Object[0]);
        }
        return consumer;
    }

    public Consumer tryGetConsumer(TopicName topic, String app) {
        return this.localCache.getConsumerByTopicAndApp(topic, app);
    }

    public Consumer.ConsumerPolicy tryGetConsumerPolicy(TopicName topic, String app) {
        Consumer consumer = this.localCache.getConsumerByTopicAndApp(topic, app);
        if (consumer == null) {
            if (StringUtils.equals((CharSequence)this.brokerConfig.getAdminUser(), (CharSequence)app)) {
                return this.brokerContext.getConsumerPolicy();
            }
            return null;
        }
        return this.getConsumerPolicyOrDefault(consumer);
    }

    public Producer.ProducerPolicy tryGetProducerPolicy(TopicName topic, String app) {
        Producer producer = this.localCache.getProducerByTopicAndApp(topic, app);
        if (producer == null) {
            if (StringUtils.equals((CharSequence)this.brokerConfig.getAdminUser(), (CharSequence)app)) {
                return this.brokerContext.getProducerPolicy();
            }
            return null;
        }
        return this.getProducerPolicyOrDefault(producer);
    }

    public boolean isNeedLongPull(String topic) {
        if (topic == null) {
            return false;
        }
        TopicConfig config = (TopicConfig)this.localCache.getTopicConfigCache().get(topic);
        return config == null || !config.checkSequential();
    }

    public Producer getProducer(TopicName topic, String app) throws JoyQueueException {
        Producer producer = this.tryGetProducer(topic, app);
        if (null == producer) {
            throw new JoyQueueException(JoyQueueCode.FW_PRODUCER_NOT_EXISTS, new Object[0]);
        }
        return producer;
    }

    public Producer tryGetProducer(TopicName topic, String app) {
        return this.localCache.getProducerByTopicAndApp(topic, app);
    }

    public Producer.ProducerPolicy getProducerPolicy(TopicName topic, String app) throws JoyQueueException {
        Producer producer = this.localCache.getProducerByTopicAndApp(topic, app);
        if (null == producer) {
            if (StringUtils.equals((CharSequence)this.brokerConfig.getAdminUser(), (CharSequence)app)) {
                return this.brokerContext.getProducerPolicy();
            }
            throw new JoyQueueException(JoyQueueCode.FW_PRODUCER_NOT_EXISTS, new Object[0]);
        }
        return this.getProducerPolicyOrDefault(producer);
    }

    private Producer.ProducerPolicy getProducerPolicyOrDefault(Producer producer) {
        Producer.ProducerPolicy producerPolicy = producer.getProducerPolicy();
        if (producerPolicy == null) {
            return this.brokerContext.getProducerPolicy();
        }
        return producer.getProducerPolicy();
    }

    private Consumer.ConsumerPolicy getConsumerPolicyOrDefault(Consumer consumer) {
        Consumer.ConsumerPolicy consumerPolicy = consumer.getConsumerPolicy();
        if (consumerPolicy == null) {
            return this.brokerContext.getConsumerPolicy();
        }
        return consumer.getConsumerPolicy();
    }

    public boolean isLeader(String topic, short partition) {
        return this.isLeader(TopicName.parse((String)topic), partition);
    }

    public boolean isLeader(String topic, int partitionGroup) {
        return this.isLeader(TopicName.parse((String)topic), partitionGroup);
    }

    public boolean isLeader(TopicName topic, int partitionGroupId) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig == null) {
            return false;
        }
        PartitionGroup partitionGroup = topicConfig.fetchPartitionGroupByGroup(partitionGroupId);
        return partitionGroup != null && this.isLeader(partitionGroup);
    }

    public boolean isLeader(TopicName topic, short partition) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig == null) {
            return false;
        }
        PartitionGroup partitionGroup = topicConfig.fetchPartitionGroupByPartition(partition);
        return partitionGroup != null && this.isLeader(partitionGroup);
    }

    public boolean isLeader(PartitionGroup partitionGroup) {
        if (!partitionGroup.getReplicas().contains(this.getBrokerId())) {
            return false;
        }
        if (!this.config.getTopicLocalElectionEnable() || partitionGroup.getElectType().equals((Object)PartitionGroup.ElectType.fix)) {
            return this.getBrokerId().equals(partitionGroup.getLeader());
        }
        ClusterNode clusterNode = this.clusterNameService.getTopicGroupNode(partitionGroup.getTopic(), partitionGroup.getGroup());
        if (clusterNode == null) {
            return false;
        }
        return clusterNode.getLeader() == this.getBrokerId().intValue();
    }

    public BooleanResponse checkWritable(TopicName topic, String app, String address) {
        Set blackList;
        BooleanResponse brokerWritable = this.checkBrokerWritable();
        if (!brokerWritable.isSuccess()) {
            return brokerWritable;
        }
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig == null) {
            this.logger.error("topic[{}] app[{}] cant't be write on broker [{}],has no topicConfig", new Object[]{topic, app, this.broker.getId() + "[" + this.broker.getIp() + ":" + this.broker.getPort() + "]"});
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.FW_TOPIC_NOT_EXIST);
        }
        Producer.ProducerPolicy producerPolicy = null;
        try {
            producerPolicy = this.getProducerPolicy(topic, app);
        }
        catch (JoyQueueException e) {
            this.logger.error("topic[{}],app[{}],error[{}]", new Object[]{topic, app, e.getMessage()});
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.valueOf((int)e.getCode()));
        }
        Set set = blackList = producerPolicy != null ? producerPolicy.getBlackList() : null;
        if (blackList != null && blackList.stream().anyMatch(ip -> ip.trim().equals(address))) {
            this.logger.error("topic[{}] app[{}] cant't be write on broker [] in blacklist", new Object[]{topic, app, this.broker.getId() + "[" + this.broker.getIp() + ":" + this.broker.getPort() + "]"});
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.FW_PUT_MESSAGE_TOPIC_NOT_WRITE);
        }
        List partitionGroups = topicConfig.fetchTopicPartitionGroupsByBrokerId(this.broker.getId().intValue());
        if (partitionGroups.stream().noneMatch(partitionGroup -> this.isLeader((PartitionGroup)partitionGroup))) {
            this.logger.error("topic[{}] cant't be write on broker [] ", new Object[]{topic, app, this.broker.getId() + "[" + this.broker.getIp() + ":" + this.broker.getPort() + "]"});
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.FW_PRODUCE_MESSAGE_BROKER_NOT_LEADER);
        }
        return BooleanResponse.success();
    }

    public BooleanResponse checkWritable(TopicName topic, String app, String address, short partition) {
        BooleanResponse response = this.checkWritable(topic, app, address);
        if (!response.isSuccess()) {
            return response;
        }
        TopicConfig topicConfig = this.getTopicConfig(topic);
        PartitionGroup group = topicConfig.fetchPartitionGroupByPartition(partition);
        if (group == null || !this.isLeader(group)) {
            this.logger.error("topic[{}],app[{}],partition[{}],error[{}]", new Object[]{topic, app, partition, JoyQueueCode.FW_FETCH_TOPIC_MESSAGE_BROKER_NOT_LEADER.getMessage(new Object[0])});
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.FW_PRODUCE_MESSAGE_BROKER_NOT_LEADER);
        }
        return BooleanResponse.success();
    }

    public BooleanResponse checkReadable(TopicName topic, String app, String address) {
        BooleanResponse brokerReadable = this.checkBrokerReadable();
        if (!brokerReadable.isSuccess()) {
            return brokerReadable;
        }
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig == null) {
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.FW_TOPIC_NOT_EXIST);
        }
        Consumer.ConsumerPolicy consumerPolicy = null;
        try {
            consumerPolicy = this.getConsumerPolicy(topic, app);
        }
        catch (JoyQueueException e) {
            this.logger.error("topic[{}],app[{}],error[{}]", new Object[]{topic, app, e.getMessage()});
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.valueOf((int)e.getCode()));
        }
        Boolean paused = consumerPolicy.getPaused();
        if (paused.booleanValue()) {
            this.logger.info("topic is paused, topic: {}, app: {}", (Object)topic, (Object)app);
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.FW_FETCH_TOPIC_MESSAGE_PAUSED);
        }
        Set blackList = consumerPolicy.getBlackList();
        if (blackList != null && blackList.stream().anyMatch(ip -> ip.trim().equals(address))) {
            this.logger.info("app client ip not readable, topic: {}, app: {}, ip: {}", new Object[]{topic, app, address});
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.FW_GET_MESSAGE_APP_CLIENT_IP_NOT_READ);
        }
        List partitionGroups = topicConfig.fetchTopicPartitionGroupsByBrokerId(this.broker.getId().intValue());
        if (partitionGroups.stream().noneMatch(partitionGroup -> this.isLeader((PartitionGroup)partitionGroup))) {
            this.logger.error("topic[{}],app[{}],error[{}]", new Object[]{topic, app, JoyQueueCode.FW_FETCH_TOPIC_MESSAGE_BROKER_NOT_LEADER.getMessage(new Object[0])});
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.FW_FETCH_TOPIC_MESSAGE_BROKER_NOT_LEADER);
        }
        return BooleanResponse.success();
    }

    public BooleanResponse checkReadable(TopicName topic, String app, String address, short partition) {
        BooleanResponse response = this.checkReadable(topic, app, address);
        if (!response.isSuccess()) {
            return response;
        }
        TopicConfig topicConfig = this.getTopicConfig(topic);
        PartitionGroup group = topicConfig.fetchPartitionGroupByPartition(partition);
        if (group == null || !this.isLeader(group)) {
            this.logger.error("topic[{}],app[{}],partition[{}],error[{}]", new Object[]{topic, app, partition, JoyQueueCode.FW_FETCH_TOPIC_MESSAGE_BROKER_NOT_LEADER.getMessage(new Object[0])});
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.FW_FETCH_TOPIC_MESSAGE_BROKER_NOT_LEADER);
        }
        return BooleanResponse.success();
    }

    public BooleanResponse checkBrokerReadable() {
        Broker broker = this.getBroker();
        if (Broker.PermissionEnum.FULL != broker.getPermission() && Broker.PermissionEnum.READ != broker.getPermission()) {
            this.logger.error("No read permission broker:[{}]", (Object)broker);
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.FW_BROKER_NOT_READABLE);
        }
        return BooleanResponse.success();
    }

    public BooleanResponse checkBrokerWritable() {
        Broker broker = this.getBroker();
        if (Broker.PermissionEnum.FULL != broker.getPermission() && Broker.PermissionEnum.WRITE != broker.getPermission()) {
            this.logger.error("No write permission broker info is [{}]", (Object)broker);
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.FW_BROKER_NOT_WRITABLE);
        }
        return BooleanResponse.success();
    }

    public List<String> getAppByTopic(TopicName topic) {
        List consumerByTopic = this.nameService.getConsumerByTopic(topic);
        if (CollectionUtils.isEmpty((Collection)consumerByTopic)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> appList = new ArrayList<String>(consumerByTopic.size());
        consumerByTopic.stream().forEach(consume -> appList.add(consume.getApp()));
        return appList;
    }

    public List<String> getLocalSubscribeAppByTopic(TopicName topic) {
        Map<String, MetaDataLocalCache.CacheConsumer> consumers;
        List<String> result = Collections.emptyList();
        if (topic != null && (consumers = this.localCache.getTopicConsumers(topic)) != null) {
            result = new ArrayList<String>(consumers.keySet());
        }
        return result;
    }

    public List<Producer> getLocalProducersByTopic(TopicName topic) {
        Map<String, MetaDataLocalCache.CacheProducer> producers = this.localCache.getTopicProducers(topic);
        if (MapUtils.isEmpty(producers)) {
            return Collections.emptyList();
        }
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry<String, MetaDataLocalCache.CacheProducer> entry : producers.entrySet()) {
            result.add(entry.getValue().getProducer());
        }
        return result;
    }

    public List<Consumer> getLocalConsumersByTopic(TopicName topic) {
        Map<String, MetaDataLocalCache.CacheConsumer> consumers = this.localCache.getTopicConsumers(topic);
        if (MapUtils.isEmpty(consumers)) {
            return Collections.emptyList();
        }
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry<String, MetaDataLocalCache.CacheConsumer> entry : consumers.entrySet()) {
            result.add(entry.getValue().getConsumer());
        }
        return result;
    }

    public AppToken getAppToken(String app, String token) {
        return this.nameService.getAppToken(app, token);
    }

    public boolean checkArchiveable(TopicName topicName) {
        Map<String, MetaDataLocalCache.CacheConsumer> consumers;
        Map<String, MetaDataLocalCache.CacheProducer> producers = this.localCache.getTopicProducers(topicName);
        if (null != producers && producers.size() > 0) {
            Iterator<MetaDataLocalCache.CacheProducer> it = producers.values().iterator();
            while (it.hasNext()) {
                if (!this.getProducerPolicyOrDefault(it.next().getProducer()).getArchive().booleanValue()) continue;
                return true;
            }
        }
        if (null != (consumers = this.localCache.getTopicConsumers(topicName)) && consumers.size() > 0) {
            Iterator<MetaDataLocalCache.CacheConsumer> it = consumers.values().iterator();
            while (it.hasNext()) {
                if (!this.getConsumerPolicyOrDefault(it.next().getConsumer()).getArchive().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Broker> getLocalRetryBroker() {
        List brokers = this.nameService.getAllBrokers();
        LinkedList localRetryBrokers = Lists.newLinkedList();
        if (brokers != null) {
            for (Broker broker : brokers) {
                if ("RemoteRetry".equals(broker.getRetryType())) continue;
                localRetryBrokers.add(broker);
            }
        }
        return localRetryBrokers;
    }

    public void leaderReport(TopicName topic, int partitionGroup, int leaderBrokerId, Set<Integer> isrId, Integer termId) {
        this.nameService.leaderReport(topic, partitionGroup, leaderBrokerId, isrId, termId.intValue());
    }

    public boolean hasSubscribe(String subscribeApp, Subscription.Type subscribe) {
        return this.nameService.hasSubscribe(subscribeApp, subscribe);
    }

    private void writeBroker(Integer brokerId) throws Exception {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.brokerIdFile));){
            bufferedWriter.write(brokerId.toString());
        }
    }

    private Integer readBroker() throws Exception {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.brokerIdFile));){
            String brokerId = bufferedReader.readLine();
            if (null != brokerId && !"".equals(brokerId.trim())) {
                Integer n = Integer.valueOf(brokerId);
                return n;
            }
            Integer n = null;
            return n;
        }
    }

    public boolean doAuthorization(String app, String token) {
        Date now = Calendar.getInstance().getTime();
        AppToken appToken = this.nameService.getAppToken(app, token);
        return null != appToken && appToken.getEffectiveTime().before(now) && appToken.getExpirationTime().after(now);
    }

    public NameService getNameService() {
        return this.nameService;
    }

    protected void doStop() {
        super.doStop();
        if (this.eventBus.isStarted()) {
            this.eventBus.stop();
        }
        if (this.localCache.isStarted()) {
            this.localCache.stop();
        }
        this.logger.info("clusterManager is stopped");
    }

    private class MetaDataLocalCache
    implements LifeCycle {
        private AtomicBoolean start = new AtomicBoolean(false);
        private final NameService nameService;
        private ScheduledExecutorService timerUpdateAllExecutor;
        private long cacheTime = 60000L;
        private ConcurrentMap<String, TopicConfig> topicConfigCache = new ConcurrentHashMap<String, TopicConfig>();
        private ConcurrentMap<String, ConcurrentHashMap<String, CacheConsumer>> consumerCache = new ConcurrentHashMap<String, ConcurrentHashMap<String, CacheConsumer>>();
        private ConcurrentMap<String, ConcurrentHashMap<String, CacheProducer>> producerCache = new ConcurrentHashMap<String, ConcurrentHashMap<String, CacheProducer>>();
        private Cache<TopicConfig, List<Short>> partitionCache = CacheBuilder.newBuilder().expireAfterWrite(5000L, TimeUnit.MILLISECONDS).build();

        MetaDataLocalCache(NameService nameService) {
            this.nameService = nameService;
            nameService.addListener((EventListener)new MetaDataListener());
        }

        protected void initCache() {
            this.buildTopicConfigCaches();
        }

        protected void buildTopicConfigCaches() {
            Map topicConfigByBroker = this.nameService.getTopicConfigByBroker(ClusterManager.this.brokerConfig.getBrokerId());
            if (null != topicConfigByBroker) {
                for (Map.Entry entry : topicConfigByBroker.entrySet()) {
                    ClusterManager.this.logger.info("build topic config, topic: {}", entry.getKey());
                    this.buildTopicConfigCache((TopicConfig)entry.getValue());
                }
            }
        }

        protected TopicConfig getTopicConfig(TopicName topic) {
            TopicConfig topicConfig = (TopicConfig)this.topicConfigCache.get(topic.getFullName());
            if (null != topicConfig) {
                return topicConfig;
            }
            return this.buildTopicConfigCache(topic);
        }

        protected TopicConfig buildTopicConfigCache(TopicName topic) {
            TopicConfig topicConfig = this.nameService.getTopicConfig(topic);
            if (null != topicConfig) {
                return this.buildTopicConfigCache(topicConfig);
            }
            return null;
        }

        private TopicConfig buildTopicConfigCache(TopicConfig topicConfig) {
            ClusterManager.this.logger.info("build topic cache, topic: {}", (Object)topicConfig.getName());
            TopicName topic = topicConfig.getName();
            this.topicConfigCache.put(topic.getFullName(), topicConfig);
            if (!this.consumerCache.containsKey(topic.getFullName())) {
                this.consumerCache.put(topic.getFullName(), new ConcurrentHashMap());
            }
            if (!this.producerCache.containsKey(topic.getFullName())) {
                this.producerCache.put(topic.getFullName(), new ConcurrentHashMap());
            }
            return topicConfig;
        }

        protected Consumer buildConsumeCache(TopicName topic, String app) {
            ClusterManager.this.logger.info("build consumer cache, topic: {}, app: {}", (Object)topic, (Object)app);
            Consumer consumerByTopic = this.nameService.getConsumerByTopicAndApp(topic, app);
            if (null != consumerByTopic) {
                ((ConcurrentHashMap)this.consumerCache.get(topic.getFullName())).put(app, new CacheConsumer(consumerByTopic, SystemClock.now()));
            }
            return consumerByTopic;
        }

        protected Consumer buildConsumeCache(Consumer consumer) {
            ClusterManager.this.logger.info("build consumer cache, topic: {}, app: {}", (Object)consumer.getTopic(), (Object)consumer.getApp());
            ConcurrentHashMap consumers = (ConcurrentHashMap)this.consumerCache.get(consumer.getTopic().getFullName());
            if (consumers == null) {
                consumers = new ConcurrentHashMap();
                this.consumerCache.putIfAbsent(consumer.getTopic().getFullName(), consumers);
                consumers = (ConcurrentHashMap)this.consumerCache.get(consumer.getTopic().getFullName());
            }
            consumers.put(consumer.getApp(), new CacheConsumer(consumer, SystemClock.now()));
            return consumer;
        }

        protected Consumer getConsumerByTopicAndApp(TopicName topic, String app) {
            if (!this.consumerCache.containsKey(topic.getFullName())) {
                ClusterManager.this.logger.warn("topic {} is not exist on this broker", (Object)topic.getFullName());
                return null;
            }
            CacheConsumer consumer = (CacheConsumer)((ConcurrentHashMap)this.consumerCache.get(topic.getFullName())).get(app);
            if (null == consumer && this.topicConfigCache.containsKey(topic.getFullName())) {
                return this.buildConsumeCache(topic, app);
            }
            return consumer.getConsumer();
        }

        protected Producer getProducerByTopicAndApp(TopicName topic, String app) {
            if (!this.producerCache.containsKey(topic.getFullName())) {
                ClusterManager.this.logger.warn("topic {} is not exist on this broker", (Object)topic.getFullName());
                return null;
            }
            CacheProducer producer = (CacheProducer)((ConcurrentHashMap)this.producerCache.get(topic.getFullName())).get(app);
            if (null == producer && this.topicConfigCache.containsKey(topic.getFullName())) {
                return this.buildProduceCache(topic, app);
            }
            return producer.getProducer();
        }

        protected Producer buildProduceCache(TopicName topic, String app) {
            ClusterManager.this.logger.info("build producer cache, topic: {}, app: {}", (Object)topic, (Object)app);
            Producer producerByTopic = this.nameService.getProducerByTopicAndApp(topic, app);
            if (null != producerByTopic) {
                ((ConcurrentHashMap)this.producerCache.get(topic.getFullName())).put(app, new CacheProducer(producerByTopic));
            }
            return producerByTopic;
        }

        protected Producer buildProduceCache(Producer producer) {
            ClusterManager.this.logger.info("build producer cache, topic: {}, app: {}", (Object)producer.getTopic(), (Object)producer.getApp());
            ConcurrentHashMap producers = (ConcurrentHashMap)this.producerCache.get(producer.getTopic().getFullName());
            if (producers == null) {
                producers = new ConcurrentHashMap();
                this.producerCache.putIfAbsent(producer.getTopic().getFullName(), producers);
                producers = (ConcurrentHashMap)this.producerCache.get(producer.getTopic().getFullName());
            }
            producers.put(producer.getApp(), new CacheProducer(producer));
            return producer;
        }

        public ConcurrentMap<String, TopicConfig> getTopicConfigCache() {
            return this.topicConfigCache;
        }

        public Map<String, CacheConsumer> getTopicConsumers(TopicName topic) {
            return (Map)this.consumerCache.get(topic.getFullName());
        }

        public Map<String, CacheProducer> getTopicProducers(TopicName topic) {
            return (Map)this.producerCache.get(topic.getFullName());
        }

        public Cache<TopicConfig, List<Short>> getPartitionCache() {
            return this.partitionCache;
        }

        @Deprecated
        private void clearConsumerCache(TopicName topicName) {
            Map cacheConsuemerMap = (Map)this.consumerCache.get(topicName.getFullName());
            cacheConsuemerMap.values().forEach(cacheConsuemer -> {
                if (SystemClock.now() > cacheConsuemer.getExpireTime()) {
                    cacheConsuemerMap.remove(cacheConsuemer.getConsumer().getApp());
                }
            });
        }

        private void updateConsumerCache(TopicName topicName) {
            Map cacheConsumerMapOld = (Map)this.consumerCache.get(topicName.getFullName());
            Iterator iterator = cacheConsumerMapOld.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String app = (String)next.getKey();
                Consumer consumerByTopicAndApp = this.nameService.getConsumerByTopicAndApp(topicName, app);
                if (null != consumerByTopicAndApp) {
                    cacheConsumerMapOld.put(app, new CacheConsumer(consumerByTopicAndApp));
                    continue;
                }
                iterator.remove();
            }
        }

        private void compensateAddProduceEvent(TopicName topicName) {
            List producerByTopic = this.nameService.getProducerByTopic(topicName);
            ConcurrentHashMap localProducerCache = (ConcurrentHashMap)this.producerCache.get(topicName.getFullName());
            producerByTopic.stream().forEach(producer -> {
                if (producer != null) {
                    String app = producer.getApp();
                    if (!localProducerCache.contains(app)) {
                        ProducerEvent producerEvent = new ProducerEvent();
                        producerEvent.setEventType(EventType.ADD_PRODUCER);
                        producerEvent.setApp(app);
                        producerEvent.setTopic(topicName);
                        ClusterManager.this.eventBus.add((Object)producerEvent);
                    }
                    localProducerCache.put(app, new CacheProducer((Producer)producer));
                }
            });
        }

        private void compensateAddConsumeEvent(TopicName topicName) {
            List consumerByTopic = this.nameService.getConsumerByTopic(topicName);
            ConcurrentHashMap localConsumeCache = (ConcurrentHashMap)this.consumerCache.get(topicName.getFullName());
            consumerByTopic.stream().forEach(consumer -> {
                if (consumer != null) {
                    String app = consumer.getApp();
                    if (!localConsumeCache.contains(app)) {
                        ConsumerEvent consumerEvent = new ConsumerEvent();
                        consumerEvent.setEventType(EventType.ADD_CONSUMER);
                        consumerEvent.setApp(app);
                        consumerEvent.setTopic(topicName);
                        ClusterManager.this.eventBus.add((Object)consumerEvent);
                    }
                    localConsumeCache.put(app, new CacheConsumer((Consumer)consumer));
                }
            });
        }

        @Deprecated
        private void clearProducerCache(TopicName topicName) {
            Map cacheProducerMap = (Map)this.producerCache.get(topicName.getFullName());
            cacheProducerMap.values().forEach(cacheProducer -> {
                if (SystemClock.now() > cacheProducer.getExpireTime()) {
                    cacheProducerMap.remove(cacheProducer.getProducer().getApp());
                }
            });
        }

        private void updateProducerCache(TopicName topicName) {
            Map cacheProducerMapOld = (Map)this.producerCache.get(topicName.getFullName());
            Iterator iterator = cacheProducerMapOld.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String app = (String)next.getKey();
                Producer producerByTopic = this.nameService.getProducerByTopicAndApp(topicName, app);
                if (null != producerByTopic) {
                    cacheProducerMapOld.put(app, new CacheProducer(producerByTopic));
                    continue;
                }
                iterator.remove();
            }
        }

        public void start() throws Exception {
            this.timerUpdateAllExecutor = Executors.newSingleThreadScheduledExecutor();
            this.start.compareAndSet(false, true);
        }

        public void stop() {
            this.timerUpdateAllExecutor.shutdown();
            this.start.compareAndSet(true, false);
        }

        public boolean isStarted() {
            return this.start.get();
        }

        protected void publishEvent(MetaEvent event) {
            ClusterManager.this.eventBus.inform((Object)event);
        }

        private class CacheProducer {
            private Producer producer;
            private long expireTime;

            CacheProducer(Producer producer) {
                this.producer = producer;
                this.expireTime = SystemClock.now() + MetaDataLocalCache.this.cacheTime;
            }

            CacheProducer(Producer producer, long expireTime) {
                this.producer = producer;
                this.expireTime = expireTime;
            }

            public Producer getProducer() {
                return this.producer;
            }

            public long getExpireTime() {
                return this.expireTime;
            }
        }

        private class CacheConsumer {
            private Consumer consumer;
            private long expireTime;

            CacheConsumer(Consumer consumer) {
                this.consumer = consumer;
                this.expireTime = SystemClock.now() + MetaDataLocalCache.this.cacheTime;
            }

            CacheConsumer(Consumer consumer, long expireTime) {
                this.consumer = consumer;
                this.expireTime = expireTime;
            }

            public Consumer getConsumer() {
                return this.consumer;
            }

            public long getExpireTime() {
                return this.expireTime;
            }
        }

        class MetaDataListener
        implements EventListener<NameServerEvent> {
            MetaDataListener() {
            }

            public void onEvent(NameServerEvent event) {
                if (ClusterManager.this.logger.isDebugEnabled()) {
                    ClusterManager.this.logger.debug("onEvent, event: {}", (Object)JSON.toJSONString((Object)event));
                }
                switch (event.getEventType()) {
                    case ADD_TOPIC: {
                        AddTopicEvent addTopicEvent = (AddTopicEvent)event.getMetaEvent();
                        TopicConfig topicConfig = TopicConfig.toTopicConfig((Topic)addTopicEvent.getTopic(), (List)addTopicEvent.getPartitionGroups());
                        MetaDataLocalCache.this.buildTopicConfigCache(topicConfig);
                        break;
                    }
                    case UPDATE_TOPIC: {
                        UpdateTopicEvent updateTopicEvent = (UpdateTopicEvent)event.getMetaEvent();
                        TopicConfig oldTopicConfig = (TopicConfig)MetaDataLocalCache.this.topicConfigCache.get(updateTopicEvent.getOldTopic().getName().getFullName());
                        if (oldTopicConfig == null) break;
                        TopicConfig newTopicConfig = TopicConfig.toTopicConfig((Topic)updateTopicEvent.getNewTopic());
                        newTopicConfig.setPartitionGroups(oldTopicConfig.getPartitionGroups());
                        MetaDataLocalCache.this.buildTopicConfigCache(newTopicConfig);
                        break;
                    }
                    case REMOVE_TOPIC: {
                        RemoveTopicEvent removeTopicEvent = (RemoveTopicEvent)event.getMetaEvent();
                        TopicConfig topicConfig = (TopicConfig)MetaDataLocalCache.this.topicConfigCache.remove(removeTopicEvent.getTopic().getName().getFullName());
                        if (topicConfig == null) break;
                        MetaDataLocalCache.this.consumerCache.remove(topicConfig.getName().getFullName());
                        MetaDataLocalCache.this.producerCache.remove(topicConfig.getName().getFullName());
                        for (PartitionGroup partitionGroup : topicConfig.fetchTopicPartitionGroupsByBrokerId(ClusterManager.this.brokerConfig.getBrokerId().intValue())) {
                            MetaDataLocalCache.this.publishEvent((MetaEvent)new RemovePartitionGroupEvent(topicConfig.getName(), partitionGroup));
                        }
                        break;
                    }
                    case ADD_PARTITION_GROUP: {
                        AddPartitionGroupEvent addPartitionGroupEvent = (AddPartitionGroupEvent)event.getMetaEvent();
                        PartitionGroup partitionGroup = addPartitionGroupEvent.getPartitionGroup();
                        TopicConfig oldTopicConfig = (TopicConfig)MetaDataLocalCache.this.topicConfigCache.get(addPartitionGroupEvent.getTopic().getFullName());
                        if (oldTopicConfig == null) break;
                        HashMap topicPartitionGroups = Maps.newHashMap((Map)oldTopicConfig.getPartitionGroups());
                        topicPartitionGroups.put(addPartitionGroupEvent.getPartitionGroup().getGroup(), partitionGroup);
                        oldTopicConfig.setPartitionGroups((Map)topicPartitionGroups);
                        MetaDataLocalCache.this.buildTopicConfigCache(oldTopicConfig);
                        break;
                    }
                    case UPDATE_PARTITION_GROUP: {
                        UpdatePartitionGroupEvent updatePartitionGroupEvent = (UpdatePartitionGroupEvent)event.getMetaEvent();
                        PartitionGroup oldPartitionGroup = updatePartitionGroupEvent.getOldPartitionGroup();
                        PartitionGroup newPartitionGroup = updatePartitionGroupEvent.getNewPartitionGroup();
                        TopicConfig oldTopicConfig = (TopicConfig)MetaDataLocalCache.this.topicConfigCache.get(updatePartitionGroupEvent.getTopic().getFullName());
                        if (oldTopicConfig == null) break;
                        HashMap topicPartitionGroups = Maps.newHashMap((Map)oldTopicConfig.getPartitionGroups());
                        topicPartitionGroups.put(newPartitionGroup.getGroup(), newPartitionGroup);
                        oldTopicConfig.setPartitionGroups((Map)topicPartitionGroups);
                        MetaDataLocalCache.this.buildTopicConfigCache(oldTopicConfig);
                        break;
                    }
                    case REMOVE_PARTITION_GROUP: {
                        RemovePartitionGroupEvent removePartitionGroupEvent = (RemovePartitionGroupEvent)event.getMetaEvent();
                        PartitionGroup partitionGroup = removePartitionGroupEvent.getPartitionGroup();
                        TopicConfig oldTopicConfig = (TopicConfig)MetaDataLocalCache.this.topicConfigCache.get(removePartitionGroupEvent.getTopic().getFullName());
                        if (oldTopicConfig == null) break;
                        HashMap topicPartitionGroups = Maps.newHashMap((Map)oldTopicConfig.getPartitionGroups());
                        topicPartitionGroups.remove(partitionGroup.getGroup());
                        oldTopicConfig.setPartitionGroups((Map)topicPartitionGroups);
                        TopicConfig newTopiConfig = MetaDataLocalCache.this.buildTopicConfigCache(oldTopicConfig);
                        if (!CollectionUtils.isEmpty((Collection)newTopiConfig.fetchTopicPartitionGroupsByBrokerId(ClusterManager.this.getBrokerId().intValue()))) break;
                        MetaDataLocalCache.this.consumerCache.remove(newTopiConfig.getName().getFullName());
                        MetaDataLocalCache.this.producerCache.remove(newTopiConfig.getName().getFullName());
                        break;
                    }
                    case ADD_CONSUMER: {
                        AddConsumerEvent addConsumerEvent = (AddConsumerEvent)event.getMetaEvent();
                        MetaDataLocalCache.this.buildConsumeCache(addConsumerEvent.getConsumer());
                        break;
                    }
                    case UPDATE_CONSUMER: {
                        UpdateConsumerEvent updateConsumerEvent = (UpdateConsumerEvent)event.getMetaEvent();
                        MetaDataLocalCache.this.buildConsumeCache(updateConsumerEvent.getNewConsumer());
                        break;
                    }
                    case REMOVE_CONSUMER: {
                        RemoveConsumerEvent removeConsumerEvent = (RemoveConsumerEvent)event.getMetaEvent();
                        ConcurrentHashMap topicConsumerCache = (ConcurrentHashMap)MetaDataLocalCache.this.consumerCache.get(removeConsumerEvent.getTopic().getFullName());
                        if (topicConsumerCache == null) break;
                        topicConsumerCache.remove(removeConsumerEvent.getConsumer().getApp());
                        break;
                    }
                    case ADD_PRODUCER: {
                        AddProducerEvent addProducerEvent = (AddProducerEvent)event.getMetaEvent();
                        MetaDataLocalCache.this.buildProduceCache(addProducerEvent.getProducer());
                        break;
                    }
                    case UPDATE_PRODUCER: {
                        UpdateProducerEvent updateProducerEvent = (UpdateProducerEvent)event.getMetaEvent();
                        MetaDataLocalCache.this.buildProduceCache(updateProducerEvent.getNewProducer());
                        break;
                    }
                    case REMOVE_PRODUCER: {
                        RemoveProducerEvent removeProducerEvent = (RemoveProducerEvent)event.getMetaEvent();
                        ConcurrentHashMap topicProducerCache = (ConcurrentHashMap)MetaDataLocalCache.this.producerCache.get(removeProducerEvent.getTopic().getFullName());
                        if (topicProducerCache == null) break;
                        topicProducerCache.remove(removeProducerEvent.getProducer().getApp());
                        break;
                    }
                    case UPDATE_BROKER: {
                        UpdateBrokerEvent updateBrokerEvent = (UpdateBrokerEvent)event.getMetaEvent();
                        if (ClusterManager.this.broker == null) break;
                        ClusterManager.this.broker.setPermission(updateBrokerEvent.getNewBroker().getPermission());
                        ClusterManager.this.broker.setRetryType(updateBrokerEvent.getNewBroker().getRetryType());
                        break;
                    }
                    case COMPENSATE: {
                        org.joyqueue.nsr.event.CompensateEvent compensateEvent = (org.joyqueue.nsr.event.CompensateEvent)event.getMetaEvent();
                        MetaDataLocalCache.this.publishEvent(new CompensateEvent((Map)compensateEvent.getNewCache().getTopicConfigBrokerMap().get(ClusterManager.this.getBrokerId())));
                        break;
                    }
                }
                if (!event.getEventType().equals((Object)EventType.COMPENSATE)) {
                    MetaDataLocalCache.this.publishEvent(event.getMetaEvent());
                }
            }
        }
    }
}

