/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.cluster;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.broker.Plugins;
import org.joyqueue.broker.cluster.ClusterNameServiceCache;
import org.joyqueue.broker.cluster.ClusterNameServiceExecutorService;
import org.joyqueue.broker.cluster.ClusterNodeManager;
import org.joyqueue.broker.cluster.config.ClusterConfig;
import org.joyqueue.broker.cluster.entry.ClusterNode;
import org.joyqueue.broker.cluster.entry.ClusterPartitionGroup;
import org.joyqueue.broker.cluster.entry.SplittedCluster;
import org.joyqueue.broker.cluster.helper.ClusterSplitHelper;
import org.joyqueue.broker.event.BrokerEventBus;
import org.joyqueue.broker.network.command.GetPartitionGroupClusterRequest;
import org.joyqueue.broker.network.command.GetPartitionGroupClusterResponse;
import org.joyqueue.broker.network.support.BrokerTransportClientFactory;
import org.joyqueue.config.BrokerConfigKey;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.monitor.PointTracer;
import org.joyqueue.monitor.TraceStat;
import org.joyqueue.network.transport.TransportClientFactory;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.command.JoyQueueCommand;
import org.joyqueue.network.transport.command.JoyQueuePayload;
import org.joyqueue.network.transport.config.TransportConfigSupport;
import org.joyqueue.network.transport.session.session.TransportSession;
import org.joyqueue.network.transport.session.session.TransportSessionManager;
import org.joyqueue.network.transport.session.session.config.TransportSessionConfig;
import org.joyqueue.nsr.NameService;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNameService
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(ClusterNameService.class);
    private Broker broker;
    private NameService nameService;
    private BrokerEventBus eventBus;
    private TransportSessionManager transportSessionManager;
    private PropertySupplier propertySupplier;
    private ClusterConfig config;
    private ClusterNameServiceCache cache;
    private PointTracer tracer;
    private ClusterNodeManager clusterNodeManager;
    private ClusterNameServiceExecutorService clusterNameServiceExecutorService;

    public ClusterNameService(NameService nameService, BrokerEventBus eventBus, PropertySupplier propertySupplier) {
        this.nameService = nameService;
        this.eventBus = eventBus;
        this.propertySupplier = propertySupplier;
        this.config = new ClusterConfig(propertySupplier);
    }

    protected void validate() throws Exception {
        this.tracer = (PointTracer)Plugins.TRACERERVICE.get(PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerConfigKey.TRACER_TYPE));
        this.transportSessionManager = new TransportSessionManager(new TransportSessionConfig(this.propertySupplier), TransportConfigSupport.buildClientConfig((PropertySupplier)this.propertySupplier, (String)"cluster."), (TransportClientFactory)new BrokerTransportClientFactory());
        this.clusterNodeManager = new ClusterNodeManager(this.nameService, this.eventBus);
        this.cache = new ClusterNameServiceCache(this.config, this.nameService);
        this.clusterNameServiceExecutorService = new ClusterNameServiceExecutorService(this.config);
    }

    protected void doStart() throws Exception {
        this.cache.start();
        this.clusterNodeManager.start();
        this.transportSessionManager.start();
        this.clusterNameServiceExecutorService.start();
    }

    protected void doStop() {
        this.clusterNameServiceExecutorService.stop();
        this.transportSessionManager.stop();
        this.clusterNodeManager.stop();
        this.cache.stop();
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
        this.clusterNodeManager.setBroker(broker);
    }

    public ClusterNode getTopicGroupNode(TopicName topicName, int group) {
        return this.getTopicGroupNode(topicName.getFullName(), group);
    }

    public ClusterNode getTopicGroupNode(String topic, int group) {
        return this.clusterNodeManager.getTopicGroupNode(topic, group);
    }

    public Map<TopicName, TopicConfig> getTopicConfigByApp(String subscribeApp, Subscription.Type subscribe) {
        Map topicConfigMap = this.nameService.getTopicConfigByApp(subscribeApp, subscribe);
        if (MapUtils.isEmpty((Map)topicConfigMap)) {
            return topicConfigMap;
        }
        if (topicConfigMap.size() > this.config.getTopicDynamicMetadataMaxBatchThreshold()) {
            return topicConfigMap;
        }
        TraceStat begin = this.tracer.begin("ClusterNameService.getTopicConfigByApp");
        try {
            CountDownLatch latch = new CountDownLatch(topicConfigMap.size());
            HashMap result = Maps.newHashMap();
            for (Map.Entry entry : topicConfigMap.entrySet()) {
                if (this.config.getTopicDynamicMetadataBatchParallelEnable()) {
                    result.put(entry.getKey(), entry.getValue());
                    this.clusterNameServiceExecutorService.execute(() -> {
                        result.put(entry.getKey(), this.doGetTopicConfig((TopicConfig)entry.getValue()));
                        latch.countDown();
                    });
                    continue;
                }
                result.put(entry.getKey(), this.doGetTopicConfig((TopicConfig)entry.getValue()));
                latch.countDown();
            }
            if (!latch.await(this.config.getTopicDynamicMetadataBatchTimeout(), TimeUnit.MILLISECONDS)) {
                logger.error("getTopicConfigByApp timeout, subscribeApp: {}, subscribe: {}", (Object)subscribeApp, (Object)subscribe);
            }
            this.tracer.end(begin);
            return result;
        }
        catch (Exception e) {
            logger.error("getTopicConfigByApp exception, subscribeApp: {}, subscribe: {}", new Object[]{subscribeApp, subscribe, e});
            this.tracer.error(begin);
            return topicConfigMap;
        }
    }

    public Map<String, TopicConfig> getTopicConfigs(List<String> topics) {
        HashMap topicConfigMap = Maps.newHashMap();
        for (String topic : topics) {
            TopicConfig topicConfig = this.nameService.getTopicConfig(TopicName.parse((String)topic));
            if (topicConfig == null) continue;
            topicConfigMap.put(topic, topicConfig);
        }
        if (MapUtils.isEmpty((Map)topicConfigMap)) {
            return topicConfigMap;
        }
        if (topicConfigMap.size() > this.config.getTopicDynamicMetadataMaxBatchThreshold()) {
            return topicConfigMap;
        }
        TraceStat begin = this.tracer.begin("ClusterNameService.getTopicConfigs");
        try {
            CountDownLatch latch = new CountDownLatch(topicConfigMap.size());
            HashMap result = Maps.newHashMap();
            for (Map.Entry entry : topicConfigMap.entrySet()) {
                if (this.config.getTopicDynamicMetadataBatchParallelEnable()) {
                    result.put(entry.getKey(), entry.getValue());
                    this.clusterNameServiceExecutorService.execute(() -> {
                        result.put(entry.getKey(), this.doGetTopicConfig((TopicConfig)entry.getValue()));
                        latch.countDown();
                    });
                    continue;
                }
                result.put(entry.getKey(), this.doGetTopicConfig((TopicConfig)entry.getValue()));
                latch.countDown();
            }
            if (!latch.await(this.config.getTopicDynamicMetadataBatchTimeout(), TimeUnit.MILLISECONDS)) {
                logger.error("getTopicConfigs timeout, topics: {}", topics);
            }
            this.tracer.end(begin);
            return result;
        }
        catch (Exception e) {
            logger.error("getTopicConfigs exception, topics: {}", topics, (Object)e);
            this.tracer.error(begin);
            return topicConfigMap;
        }
    }

    public TopicConfig getTopicConfig(TopicName topicName) {
        TopicConfig topicConfig = this.nameService.getTopicConfig(topicName);
        if (topicConfig == null) {
            return null;
        }
        return this.doGetTopicConfig(topicConfig);
    }

    public TopicConfig doGetTopicConfig(TopicConfig topicConfig) {
        if (!this.config.getTopicDynamicEnable()) {
            return topicConfig;
        }
        TopicConfig clone = ClusterSplitHelper.cloneTopicConfig(topicConfig);
        return this.getDynamicTopicConfig(clone);
    }

    protected TopicConfig getDynamicTopicConfig(TopicConfig topicConfig) {
        SplittedCluster splittedCluster = ClusterSplitHelper.split(topicConfig, this.clusterNodeManager);
        if (splittedCluster.isLocal()) {
            return topicConfig;
        }
        try {
            if (this.config.getTopicDynamicMetadataCacheEnable()) {
                try {
                    TopicConfig finalTopicConfig = topicConfig;
                    topicConfig = this.cache.getTopicConfig(topicConfig.getName(), () -> this.doGetDynamicTopicConfig(finalTopicConfig, splittedCluster));
                }
                catch (Exception e) {
                    logger.error("get dynamic topic config exception, topic: {}", (Object)topicConfig.getName(), (Object)e);
                }
            } else {
                topicConfig = this.doGetDynamicTopicConfig(topicConfig, splittedCluster);
            }
            return topicConfig;
        }
        catch (Exception e) {
            logger.error("get dynamic topic config exception, topic: {}", (Object)topicConfig.getName(), (Object)e);
            return topicConfig;
        }
    }

    protected TopicConfig doGetDynamicTopicConfig(TopicConfig topicConfig, SplittedCluster splittedCluster) {
        TraceStat begin = this.tracer.begin("ClusterNameService.doGetDynamicTopicConfig");
        try {
            if (splittedCluster.getSplittedByGroup().size() < this.config.getTopicDynamicMetadataMinParallelThreshold()) {
                this.doGetRemoteTopicConfig(topicConfig, splittedCluster.getSplittedByGroup());
                return topicConfig;
            }
            if (!this.doGetRemoteTopicConfig(topicConfig, splittedCluster.getSplittedByLeader())) {
                Map<Integer, List<Integer>> splittedByRewrite = ClusterSplitHelper.splitByReWrite(topicConfig);
                for (Map.Entry<Integer, List<Integer>> entry : splittedCluster.getSplittedByLeader().entrySet()) {
                    splittedByRewrite.remove(entry.getKey());
                }
                if (splittedByRewrite.size() > this.config.getTopicDynamicMetadataMaxParallelThreshold()) {
                    this.tracer.end(this.tracer.begin("ClusterNameService.doGetDynamicTopicConfig.all." + topicConfig.getName().getFullName()));
                } else {
                    this.doGetRemoteTopicConfig(topicConfig, splittedByRewrite);
                }
            }
            this.tracer.end(begin);
            return topicConfig;
        }
        catch (Exception e) {
            this.tracer.error(begin);
            throw e;
        }
    }

    protected boolean doGetRemoteTopicConfig(final TopicConfig topicConfig, Map<Integer, List<Integer>> splittedByGroup) {
        if (MapUtils.isEmpty(splittedByGroup)) {
            return true;
        }
        TraceStat begin = this.tracer.begin("ClusterNameService.doGetRemoteTopicConfig");
        try {
            Map brokerMap = topicConfig.fetchAllBroker();
            final CountDownLatch latch = new CountDownLatch(splittedByGroup.size());
            final HashMap partitionGroupClusterMap = Maps.newHashMap();
            final boolean[] isSuccess = new boolean[]{true};
            for (final Map.Entry<Integer, List<Integer>> entry : splittedByGroup.entrySet()) {
                Broker broker = (Broker)brokerMap.get(entry.getKey());
                if (broker == null) {
                    latch.countDown();
                    logger.error("broker not exist, topic: {}, broker: {}", (Object)topicConfig.getName(), (Object)entry.getKey());
                    continue;
                }
                TransportSession session = this.transportSessionManager.getOrCreateSession(broker);
                GetPartitionGroupClusterRequest getPartitionGroupClusterRequest = new GetPartitionGroupClusterRequest();
                HashMap groups = Maps.newHashMap();
                groups.put(topicConfig.getName().getFullName(), entry.getValue());
                getPartitionGroupClusterRequest.setGroups(groups);
                session.async((Command)new JoyQueueCommand((JoyQueuePayload)getPartitionGroupClusterRequest), this.config.getTopicDynamicMetadataTransportTimeout(), new CommandCallback(){

                    public void onSuccess(Command request, Command response) {
                        GetPartitionGroupClusterResponse getPartitionGroupClusterResponse = (GetPartitionGroupClusterResponse)((Object)response.getPayload());
                        if (MapUtils.isNotEmpty(getPartitionGroupClusterResponse.getGroups())) {
                            for (Map.Entry<String, Map<Integer, GetPartitionGroupClusterResponse.PartitionGroupCluster>> entry2 : getPartitionGroupClusterResponse.getGroups().entrySet()) {
                                for (Map.Entry<Integer, GetPartitionGroupClusterResponse.PartitionGroupCluster> clusterEntry : entry2.getValue().entrySet()) {
                                    partitionGroupClusterMap.putIfAbsent(clusterEntry.getKey(), clusterEntry.getValue());
                                }
                            }
                        }
                        latch.countDown();
                    }

                    public void onException(Command request, Throwable cause) {
                        logger.error("get topic remote metadata exception, topic: {}, group: {}, broker: {}", new Object[]{topicConfig.getName(), entry.getValue(), entry.getKey(), cause});
                        isSuccess[0] = false;
                        latch.countDown();
                    }
                });
            }
            try {
                if (!latch.await(this.config.getTopicDynamicMetadataTimeout(), TimeUnit.MILLISECONDS)) {
                    isSuccess[0] = false;
                    logger.error("get topic remote metadata timeout, topic: {}, group: {}", (Object)topicConfig.getName(), splittedByGroup);
                }
            }
            catch (InterruptedException e) {
                logger.error("get topic remote metadata timeout, topic: {}, group: {}", (Object)topicConfig.getName(), splittedByGroup);
            }
            for (Map.Entry<Integer, List<Integer>> entry : partitionGroupClusterMap.entrySet()) {
                ClusterPartitionGroup partitionGroup;
                GetPartitionGroupClusterResponse.PartitionGroupCluster cluster = (GetPartitionGroupClusterResponse.PartitionGroupCluster)((Object)entry.getValue());
                GetPartitionGroupClusterResponse.PartitionGroupNode rwNode = cluster.getRWNode();
                if (rwNode == null || (partitionGroup = (ClusterPartitionGroup)((Object)topicConfig.getPartitionGroups().get(entry.getKey()))) == null) continue;
                partitionGroup.setLeader(rwNode.getId());
                partitionGroup.setRewrite(true);
            }
            this.tracer.end(begin);
            return isSuccess[0];
        }
        catch (Exception e) {
            this.tracer.error(begin);
            throw e;
        }
    }

    public NameService getNameService() {
        return this.nameService;
    }
}

